/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.diamondback;

import au.com.diamondback.xmlintegration.booking.DiamondBooking;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.diamondback.DiamondBackBookingHandler;

@Path(value="")
public class DiamondBackWebResource
extends AbstractResource {
    private static Semaphore resender = new Semaphore(1);

    @POST
    @Path(value="bookings/update")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response postBookingsUpdate(DiamondBooking booking) {
        if (booking == null) {
            OrderMate.LOG.error("Cannot process a null booking");
            return this.getBadRequestResponse("No booking provided");
        }
        OrderMate.LOG.info("Processing incoming booking ");
        if (ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration())) {
            new DiamondBackBookingHandler(booking).processBooking();
            return this.getOKResponse("OK");
        }
        return this.getBadRequestResponse("Diamondback bookings not configured");
    }

    @GET
    @Path(value="bookings/type")
    @Produces(value={"text/plain"})
    public Response getType() {
        if (ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration())) {
            if (PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.ReservationIntegrationEnabled) == 1) {
                return this.getOKResponse("Setup and Licensed");
            }
            return this.getBadRequestResponse("Not Licensed");
        }
        return this.getBadRequestResponse("Not Configured");
    }

    @GET
    @Path(value="bookings/timezoneoffset")
    @Produces(value={"text/plain"})
    public Response getTimezoneOffset() {
        return this.getOKResponse("" + TimeZone.getDefault().getOffset(System.currentTimeMillis()));
    }

    @GET
    @Path(value="sales/touchaccounts")
    @Produces(value={"text/plain"})
    public Response touchAccounts(@QueryParam(value="date") String dateString, @QueryParam(value="fromHour") int fromHour, @QueryParam(value="toHour") int toHour) {
        OrderMate.LOG.info("Requested to re-send accounts for " + dateString + " from " + fromHour + " to " + toHour);
        if (!resender.tryAcquire()) {
            OrderMate.LOG.warn("Still sending accounts from last time");
            return this.getBadRequestResponse("Still sending from last time");
        }
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
        }
        catch (ParseException ex) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateTimeUtils.clearTimePart(cal);
        cal.set(11, fromHour);
        Date from = cal.getTime();
        cal.set(11, toHour);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date to = cal.getTime();
        TradingDay td = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, date, SQLDateType.DATE).toString());
        if (td != null) {
            final List<Account> accounts = PersistenceManager.getObjectList(Account.class, Query.select(Account.class).equals(Account.Properties.TRADING_DAY, td).greaterThanOrEqual(Account.Properties.CREATION_DATE_TIME, from, SQLDateType.TIMESTAMP).lessThanOrEqual(Account.Properties.CREATION_DATE_TIME, to, SQLDateType.TIMESTAMP).toString());
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    OrderMate.LOG.info("Resending " + accounts.size() + " accounts");
                    for (Account account : accounts) {
                        PersistenceManager.save(account);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    OrderMate.LOG.info("Resending complete");
                }
            };
            new Thread(runner, "Account Toucher").start();
        }
        return this.getOKResponse("Touched");
    }
}

