/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.diamondback;

import ordermate.OrderMate;

abstract class DiamondBackWorker {
    private static final long WAIT_TIME = 5000L;
    private static final long MAX_WAIT_TIME = 30000L;
    private static final int MAX_ATTEMPTS = 20;

    DiamondBackWorker() {
    }

    protected abstract String getName();

    void start() {
        if (this.tryWork()) {
            return;
        }
        Runnable offThread = new Runnable(){

            @Override
            public void run() {
                boolean done = false;
                for (int count = 1; !done && count < 20; ++count) {
                    DiamondBackWorker.this.snooze(Math.min(5000L * (long)count, 30000L));
                    done = DiamondBackWorker.this.tryWork();
                }
                if (!done) {
                    OrderMate.LOG.warn("Problem with " + DiamondBackWorker.this.getName() + " - aborting.");
                }
            }
        };
        new Thread(offThread, this.getName()).start();
    }

    private boolean tryWork() {
        if (!this.validate()) {
            return true;
        }
        return this.performWork();
    }

    protected abstract boolean validate();

    protected abstract boolean performWork();

    private void snooze(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

