/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.drivertracking;

import au.com.diamondback.xmlintegration.drivertracking.DiamondDelivery;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDriverStatus;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.database.integration.drivertracking.DriverTrackingConfig;
import ordermate.database.integration.drivertracking.DriverTrackingType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.webresource.WebResourceValidator;
import ordermate.webresource.WebValidatorResponse;

public enum DiamondDeliveryValidator implements WebResourceValidator<DiamondDelivery>
{
    INSTANCE;


    @Override
    public WebValidatorResponse validate(DiamondDelivery delivery) {
        if (delivery == null) {
            return this.getInvalidResponse("Delivery entity should be valid!");
        }
        if (!this.isDriverStatusAcceptable(delivery.getStatus())) {
            return this.getInvalidResponse("The incoming delivery status " + delivery.getStatus() + " is NOT acceptable!");
        }
        String integratorName = delivery.getProvider();
        DriverTrackingType driverTrackingType = this.getDriverTrackingType(integratorName != null ? integratorName.toUpperCase() : "");
        if (driverTrackingType == null) {
            return this.getInvalidResponse("There is NO Driver Tracking Type for the given integrator name: " + integratorName);
        }
        DriverTrackingConfig driverTrackingConfig = DriverTrackingConfig.getDriverTrackingConfig(driverTrackingType);
        if (driverTrackingConfig == null || !driverTrackingConfig.isEnabled()) {
            return this.getInvalidResponse((Object)((Object)driverTrackingType) + " Driver Tracking is NOT enabled in the system!");
        }
        Account account = PersistenceManager.getByID(delivery.getAccountId(), Account.class);
        if (account == null) {
            return this.getInvalidResponse("There is NO account for the given account ID: " + delivery.getAccountId());
        }
        if (!this.isValidAccountType(account.getAccountType())) {
            return this.getInvalidResponse("This account type " + account.getType() + " is NOT a delivery account!");
        }
        return new WebValidatorResponse.WebValidatorResponseBuilder(true).build();
    }

    private WebValidatorResponse getInvalidResponse(String reason) {
        return new WebValidatorResponse.WebValidatorResponseBuilder(false).message(reason).build();
    }

    private DriverTrackingType getDriverTrackingType(String integratorName) {
        try {
            return DriverTrackingType.valueOf(integratorName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isValidAccountType(AccountType accountType) {
        return AccountType.onlineDeliveryType.equals(accountType) || AccountType.deliveryType.equals(accountType);
    }

    private boolean isDriverStatusAcceptable(DiamondDriverStatus status) {
        return DiamondDriverStatus.DELIVERED.equals((Object)status) || DiamondDriverStatus.CANCELLED.equals((Object)status);
    }
}

