/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.drivertracking;

import au.com.diamondback.xmlintegration.drivertracking.DiamondDelivery;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDriver;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDriverResponse;
import au.com.diamondback.xmlintegration.drivertracking.DiamondDriverStatus;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.User;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.WebValidatorResponse;
import ordermate.webresource.drivertracking.DiamondDeliveryValidator;
import ordermate.webresource.drivertracking.gateway.DriverTrackingGateway;
import ordermate.webresource.drivertracking.gateway.DriverTrackingRequest;
import ordermate.webresource.drivertracking.gateway.DriverTrackingRequestType;

@Path(value="")
public class DriverTrackingResource
extends AbstractResource {
    private DriverTrackingGateway gateway = DriverTrackingGateway.getInstance();

    public DriverTrackingResource() {
        if (this.gateway == null) {
            this.gateway = DriverTrackingGateway.init(Terminal.getServerMateTerminal(), User.getSystemUser());
        }
    }

    @PUT
    @Path(value="/orderstatus")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response orderStatus(DiamondDelivery delivery) {
        WebValidatorResponse validatorResponse = DiamondDeliveryValidator.INSTANCE.validate(delivery);
        if (!validatorResponse.isSuccessful()) {
            OrderMate.LOG.warn("DriverTrackingResource invalid delivery order: " + validatorResponse.getMessage());
            return this.getBadRequestResponse(validatorResponse.getMessage());
        }
        this.gateway.addRequest(this.convertToRequest(delivery));
        return this.getResponse(this.getSuccessResponse("Diamond delivery order status is successfully processed!"));
    }

    private DriverTrackingRequest convertToRequest(DiamondDelivery delivery) {
        DriverTrackingRequest.DriverTrackingRequestBuilder builder = new DriverTrackingRequest.DriverTrackingRequestBuilder(delivery.getAccountId(), this.getRequestType(delivery.getStatus()));
        DiamondDriver diamondDriver = delivery.getDriver();
        if (diamondDriver != null) {
            builder.driverName(diamondDriver.getName());
            builder.driverId(diamondDriver.getId());
        }
        return builder.build();
    }

    private DriverTrackingRequestType getRequestType(DiamondDriverStatus status) {
        switch (status) {
            case DELIVERED: {
                return DriverTrackingRequestType.DELIVERED;
            }
            case CANCELLED: {
                return DriverTrackingRequestType.CANCELLED;
            }
        }
        throw new IllegalArgumentException("Invalid Delivery Request Type: " + status);
    }

    private DiamondDriverResponse getSuccessResponse(String description) {
        DiamondDriverResponse response = new DiamondDriverResponse();
        response.setSuccess(Boolean.TRUE);
        response.setDescription(description);
        response.setTimestamp(System.currentTimeMillis());
        response.setCommand("");
        return response;
    }
}

