/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.drivertracking.gateway;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.NotInGatewayAuthorizer;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.User;
import ordermate.webresource.drivertracking.gateway.DriverTrackingProcessor;
import ordermate.webresource.drivertracking.gateway.DriverTrackingRequest;

public class DriverTrackingGateway
implements GatewayNotifier<DriverTrackingRequest> {
    private final Gateway<DriverTrackingRequest> gateway;
    private static DriverTrackingGateway instance;
    private DriverTrackingProcessor processor;
    private Set<DriverTrackingRequest> retrySet;
    private Timer retryTimer;
    private static final int RETRY_MAX_ATTEMPTS = 5;
    private static final int RETRY_WAIT_TIME = 30000;
    private static final int GATEWAY_QUEUE_SIZE = 1000;

    public static synchronized DriverTrackingGateway getInstance() {
        return instance;
    }

    public static synchronized DriverTrackingGateway init(Terminal terminal, User user) {
        if (instance == null) {
            instance = new DriverTrackingGateway(terminal, user);
        }
        return instance;
    }

    private DriverTrackingGateway(Terminal terminal, User user) {
        this(terminal, user, 30000, 5);
    }

    DriverTrackingGateway(Terminal terminal, User user, int retyWaitTime, int retyMaxAttempts) {
        OrderMate.LOG.info("Constructing a new Driver Tracking Gateway!");
        this.processor = new DriverTrackingProcessor(terminal, user);
        this.gateway = new Gateway<DriverTrackingRequest>(this.processor, this, new NotInGatewayAuthorizer(), 1000);
        this.gateway.startService();
        this.retrySet = new HashSet<DriverTrackingRequest>();
        this.retryTimer = new Timer();
        this.retryTimer.schedule((TimerTask)new RetryQueueWorker(retyMaxAttempts), retyWaitTime, (long)retyWaitTime);
    }

    public void addRequest(DriverTrackingRequest request) {
        OrderMate.LOG.info("Adding a driver tracking delivery request to gateway: " + request);
        if (this.gateway.isAuthorised(request)) {
            if (!this.gateway.putIntoQueue(request)) {
                OrderMate.LOG.warn("DriverTrackingGateway wasn't able to put delivery request into queue! " + request);
                this.notifyProcess(request, false);
            }
        } else {
            OrderMate.LOG.warn("The driver tracking request is in already gateway's blocking queue! " + request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcess(DriverTrackingRequest request, boolean processSuccessful) {
        if (processSuccessful) {
            Set<DriverTrackingRequest> set = this.retrySet;
            synchronized (set) {
                this.retrySet.remove(request);
            }
        }
        Set<DriverTrackingRequest> set = this.retrySet;
        synchronized (set) {
            this.retrySet.add(request);
        }
    }

    int getQueueSize() {
        return this.gateway.getIncomingQueue().size();
    }

    int getRetrySetSize() {
        return this.retrySet.size();
    }

    private class RetryQueueWorker
    extends TimerTask {
        private final int maxAttempts;

        public RetryQueueWorker(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet needToProcess;
            Set set = DriverTrackingGateway.this.retrySet;
            synchronized (set) {
                if (DriverTrackingGateway.this.retrySet.size() <= 0) {
                    return;
                }
                needToProcess = new HashSet();
                needToProcess.addAll(DriverTrackingGateway.this.retrySet);
            }
            for (DriverTrackingRequest request : needToProcess) {
                if (request.getAttempts() < this.maxAttempts) {
                    DriverTrackingGateway.this.addRequest(request);
                    continue;
                }
                OrderMate.LOG.debug("Max attempts exceeded - Delivery Request dropped from the retrySet: " + request);
                DriverTrackingGateway.this.notifyProcess(request, true);
            }
        }
    }
}

