/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.drivertracking.gateway;

import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.users.User;
import ordermate.gui.SimpleSaveAccount;
import ordermate.webresource.drivertracking.gateway.DriverTrackingRequest;

public class DriverTrackingProcessor
implements GatewayProcessor<DriverTrackingRequest> {
    private final EventContext eventContext;
    private final SimpleSaveAccount simpleSaveAccount;

    public DriverTrackingProcessor(Terminal terminal, User user) {
        this.eventContext = new EventContext(terminal, user);
        this.simpleSaveAccount = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
    }

    @Override
    public boolean processIncoming(DriverTrackingRequest toProcess) {
        toProcess.increaseAttempts();
        boolean successful = false;
        try {
            switch (toProcess.getRequestType()) {
                case DELIVERED: {
                    successful = this.completeDelivery(toProcess);
                    break;
                }
                case CANCELLED: {
                    successful = this.cancelDelivery(toProcess);
                    break;
                }
                default: {
                    successful = true;
                }
            }
            return successful;
        }
        catch (Exception e) {
            OrderMate.LOG.warn("DriverTrackingProcess internal server exception!", (Throwable)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeDelivery(DriverTrackingRequest request) {
        Account account = PersistenceManager.getByID(request.getAccountId(), Account.class);
        if (!this.isAccountValidForProcess(account, request)) {
            return true;
        }
        if (!account.isLocked()) {
            try {
                account.lock(this.eventContext.getUser());
                Date now = new Date();
                PhoneAccount phoneAccount = (PhoneAccount)account;
                phoneAccount.setDelivered();
                if (phoneAccount.getDelivery() != null) {
                    phoneAccount.getDelivery().setTimeCompleted(now);
                    phoneAccount.getDelivery().setExtDriverName(request.getDriverName());
                    phoneAccount.getDelivery().setExtDriverId(request.getDriverId());
                    phoneAccount.getDelivery().save();
                }
                if (account.getEta() == null) {
                    phoneAccount.setEta(now);
                }
                if (account instanceof OnlineAccount) {
                    ((OnlineAccount)account).acknowledge();
                }
                phoneAccount.save();
                if (!this.simpleSaveAccount.closeAccount(account, true, true, this.eventContext)) {
                    this.simpleSaveAccount.saveAccount(account, this.eventContext);
                    OrderMate.LOG.info("The account of Driver Tracking Delivery Request is saved: " + account + ", but it was unable to be closed.");
                } else {
                    this.markDeliveryAsPaid(phoneAccount.getDelivery());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                account.unlock();
            }
        }
        return false;
    }

    private void markDeliveryAsPaid(Delivery delivery) {
        if (delivery != null) {
            delivery.markAsPaid();
            delivery.save();
        }
    }

    private boolean cancelDelivery(DriverTrackingRequest request) {
        OrderMate.LOG.warn("Driver Tracking - Cancelled delivery for the account id : " + request.getAccountId() + " , which will need to be reassigned.");
        long id = request.getAccountId();
        Account acc = PersistenceManager.getByID(id, Account.class);
        if (acc != null && AccountType.deliveryType.equals(acc.getAccountType())) {
            PhoneAccount pAcc = (PhoneAccount)acc;
            Delivery delivery = pAcc.getDelivery();
            delivery.lock(User.getSystemUser());
            delivery.removeAccount(pAcc);
            pAcc.setDelivery(null);
            delivery.save();
            pAcc.save();
            delivery.unlock();
            if (delivery.getNumberOfAccounts() == 0) {
                delivery.delete();
            }
        }
        return true;
    }

    private boolean isAccountValidForProcess(Account account, DriverTrackingRequest request) {
        if (account == null) {
            OrderMate.LOG.warn("There is NO account for the account id of the driver tracking request" + request);
            return false;
        }
        if (!AccountType.onlineDeliveryType.equals(account.getAccountType()) && !AccountType.deliveryType.equals(account.getAccountType())) {
            OrderMate.LOG.warn("The account type " + account.getAccountType() + " is INVALID for Driver Tracking Process!");
            return false;
        }
        return true;
    }
}

