/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.drivertracking.gateway;

import java.util.concurrent.atomic.AtomicInteger;
import ordermate.webresource.drivertracking.gateway.DriverTrackingRequestType;

public class DriverTrackingRequest {
    private final long accountId;
    private final DriverTrackingRequestType requestType;
    private AtomicInteger attempts = new AtomicInteger(0);
    private final String driverName;
    private final Long driverId;

    private DriverTrackingRequest(DriverTrackingRequestBuilder builder) {
        this.accountId = builder.accountId;
        this.requestType = builder.requestType;
        this.driverName = builder.driverName;
        this.driverId = builder.driverId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public DriverTrackingRequestType getRequestType() {
        return this.requestType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Long getDriverId() {
        return this.driverId;
    }

    public void increaseAttempts() {
        this.attempts.incrementAndGet();
    }

    public int getAttempts() {
        return this.attempts.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverTrackingRequest that = (DriverTrackingRequest)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (this.requestType != that.requestType) {
            return false;
        }
        if (this.driverName != null ? !this.driverName.equals(that.driverName) : that.driverName != null) {
            return false;
        }
        return this.driverId != null ? this.driverId.equals(that.driverId) : that.driverId == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + this.requestType.hashCode();
        result = 31 * result + (this.driverName != null ? this.driverName.hashCode() : 0);
        result = 31 * result + (this.driverId != null ? this.driverId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Driver Tracking Request Account Id: " + this.accountId + ", Type: " + (Object)((Object)this.requestType);
    }

    public static class DriverTrackingRequestBuilder {
        private final long accountId;
        private final DriverTrackingRequestType requestType;
        private String driverName;
        private Long driverId;

        public DriverTrackingRequestBuilder(long accountId, DriverTrackingRequestType requestType) {
            this.accountId = accountId;
            this.requestType = requestType;
        }

        public DriverTrackingRequestBuilder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public DriverTrackingRequestBuilder driverId(Long driverId) {
            this.driverId = driverId;
            return this;
        }

        public DriverTrackingRequest build() {
            return new DriverTrackingRequest(this);
        }
    }
}

