/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.email;

import au.com.ordermate.util.InputStreamUtil;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.nudgeback.EmailBuilder;
import ordermate.webresource.AbstractResource;

@Path(value="")
public class EmailResource
extends AbstractResource {
    private static final String FORM_FIELD_FILES = "files";
    private static final String FORM_FIELD_SUBJECT = "subject";
    private static final String FORM_FIELD_MAILTO = "mailto";
    private static final String FORM_FIELD_BODY = "body";
    private final NudgeUtil nudgeUtil;

    public EmailResource() {
        this.nudgeUtil = new NudgeUtil();
    }

    public EmailResource(NudgeUtil nudgeUtil) {
        this.nudgeUtil = nudgeUtil;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"application/json", "text/plain"})
    @Path(value="/send")
    public Response postEmail(@FormDataParam(value="files") List<FormDataBodyPart> formFiles, @FormDataParam(value="subject") String subject, @FormDataParam(value="mailto") String mailto, @FormDataParam(value="body") String body, @Context HttpServletRequest request) {
        boolean emailSuccess;
        EmailBuilder emailBuilder = new EmailBuilder(subject, body, true, mailto);
        if (formFiles != null) {
            for (FormDataBodyPart bodyPart : formFiles) {
                try {
                    InputStream fileInputStream = (InputStream)bodyPart.getEntityAs(InputStream.class);
                    File createdFile = new File("C:\\temp\\" + bodyPart.getFormDataContentDisposition().getFileName());
                    OutputStream fileOutputStream = Files.newOutputStream(createdFile.toPath(), new OpenOption[0]);
                    fileOutputStream.write(InputStreamUtil.toByteArray(fileInputStream));
                    emailBuilder.addAttachment(new File(createdFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    return this.getInternalServerErrorResponse(e.getMessage());
                }
            }
        }
        if (!(emailSuccess = this.nudgeUtil.sendEmail(emailBuilder.build()))) {
            return this.getInternalServerErrorResponse("Email failed to send");
        }
        return this.getOKResponse("Success!");
    }
}

