/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.finance.timesheet;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.User;
import ordermate.integration.jaxb.webservice.finance.timesheet.ObjectFactory;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetDepartment;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetEvent;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetEventType;
import ordermate.integration.jaxb.webservice.finance.timesheet.TimesheetReport;
import ordermate.webresource.WebResourceExporter;

class TimesheetExporter
extends WebResourceExporter<TimesheetReport> {
    TimesheetExporter() {
    }

    TimesheetReport generateTimesheetReport(String fromDate, String toDate) {
        ObjectFactory factory = new ObjectFactory();
        if (this.helper == null) {
            OrderMate.LOG.error("TimesheetExport cannot export if helper is null.");
            return factory.createTimesheetReport();
        }
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        if (fromDate != null) {
            from.setTime(this.helper.convertLongStringToDate(fromDate));
        }
        if (toDate != null) {
            to.setTime(this.helper.convertLongStringToDate(toDate));
        }
        this.helper.validateDates(from, to);
        ObjectQuery query = Query.select(FinanceTimesheet.class).wherePropertyBetween(FinanceTimesheet.Properties.TIME_IN, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP).or().wherePropertyBetween(FinanceTimesheet.Properties.TIME_OUT, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP);
        List<FinanceTimesheet> sheets = PersistenceManager.getObjectList(FinanceTimesheet.class, query.toString());
        TimesheetReport report = factory.createTimesheetReport();
        this.setupReport(from, to, sheets, report, factory);
        return report;
    }

    private void setupReport(Calendar from, Calendar to, List<FinanceTimesheet> sheets, TimesheetReport report, ObjectFactory factory) {
        report.setBusinessName(BusinessInfo.getInstance().getName());
        report.setFromDate(this.helper.makeDate(from));
        report.setToDate(this.helper.makeDate(to));
        for (Department department : PersistenceManager.getObjectList(Department.class, Query.select(Department.class).active(Department.class).toString())) {
            TimesheetDepartment dep = new TimesheetDepartment();
            dep.setId(department.getID());
            dep.setLabel(department.getLabel());
            report.getDepartments().add(dep);
        }
        for (FinanceTimesheet sheet : sheets) {
            TimesheetEvent event = this.createEvent(factory, sheet, TimesheetEventType.LOGIN);
            if (event != null) {
                report.getEvents().add(event);
            }
            if ((event = this.createEvent(factory, sheet, TimesheetEventType.LOGOUT)) == null) continue;
            report.getEvents().add(event);
        }
    }

    private TimesheetEvent createEvent(ObjectFactory factory, FinanceTimesheet sheet, TimesheetEventType type) {
        Date date = null;
        if (TimesheetEventType.LOGIN.equals((Object)type)) {
            date = sheet.getTimeIn();
        } else if (TimesheetEventType.LOGOUT.equals((Object)type)) {
            date = sheet.getTimeOut();
        }
        if (date == null) {
            return null;
        }
        User user = sheet.getUser();
        if (user == null) {
            return null;
        }
        Department dept = sheet.getDepartment();
        if (dept == null) {
            return null;
        }
        TimesheetEvent event = factory.createTimesheetEvent();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        event.setDate(this.helper.makeDate(cal));
        event.setEvent(type);
        event.setStaffId(user.getPayrollID());
        event.setStaffName(user.getName());
        event.setTime(this.helper.makeTime(cal));
        event.setUserId(user.getID());
        event.setClockLogId(sheet.getID());
        event.setDepartmentId(dept.getID());
        event.setPayRate(sheet.getPayRate().doubleValue());
        return event;
    }

    @Override
    public String getName() {
        return "Timesheets";
    }

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{TimesheetEvent.class, TimesheetReport.class};
    }
}

