/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.humpback;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.humpback.store.HMAdjustmentType;
import au.com.ordermate.xmlintegration.humpback.store.HMPosUser;
import au.com.ordermate.xmlintegration.humpback.store.HMPriceAdjustment;
import au.com.ordermate.xmlintegration.humpback.store.HMPriceLevel;
import au.com.ordermate.xmlintegration.humpback.store.HMProfile;
import au.com.ordermate.xmlintegration.humpback.store.HMStoreSetup;
import au.com.ordermate.xmlintegration.humpback.store.HMTerminal;
import java.math.BigDecimal;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.User;
import ordermate.integration.onlinesales.notifier.OnlineUpdateInterceptor;
import ordermate.webresource.AbstractResource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="")
public class HumpBackWebResource
extends AbstractResource {
    private static final String DECONFIGURE = "DECONFIGURE";

    @POST
    @Path(value="config/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postHumpBackConfig(String payload) {
        OrderMate.LOG.info("Incoming Humpback Config:" + payload);
        try {
            JSONObject data = new JSONObject(payload);
            String oorbyUrl = data.getString("OORB");
            String humpyUrl = data.getString("HUMPBACK");
            String snakeyUrl = data.getString("DIAMONDBACK");
            this.setUrl(CloudServerType.Oorby, oorbyUrl);
            this.setUrl(CloudServerType.HumpBack, humpyUrl);
            this.setUrl(CloudServerType.DiamondBack, snakeyUrl);
            this.handleExtraParams(data, CloudServerType.DiamondBack);
            OnlineUpdateInterceptor.getInstance().restart();
        }
        catch (JSONException ex) {
            OrderMate.LOG.error("Unknown command from humpback " + payload, (Throwable)ex);
            return this.getBadRequestResponse("Unknown Command");
        }
        return this.getResponse("HumpBack Configuration Set");
    }

    private void handleExtraParams(JSONObject data, CloudServerType type) throws JSONException {
        String paramKey = type.name().toUpperCase() + "_params";
        if (!data.has(paramKey)) {
            return;
        }
        JSONArray extraParams = data.getJSONArray(paramKey);
        if (extraParams != null && extraParams.length() > 0) {
            CloudBackConfig config = CloudBackConfig.getCloudBackConfig(type);
            for (int i = 0; i < extraParams.length(); ++i) {
                JSONObject nextParam = extraParams.getJSONObject(i);
                if (nextParam == null) continue;
                String key = nextParam.getString("key");
                String value = nextParam.getString("value");
                config.setCloudProperty(key, value);
            }
            config.save();
        }
    }

    private void setUrl(CloudServerType cloudType, String newUrl) {
        if (DECONFIGURE.equals(newUrl)) {
            CloudBackConfig config = CloudBackConfig.getCloudBackConfig(cloudType);
            if (config != null) {
                config.getWebConfig().setUrl(null);
                config.setEnabled(false);
                config.save();
            }
            OrderMate.LOG.info("Deconfigured cloud " + (Object)((Object)cloudType));
        } else if (!StringUtils.isEmpty(newUrl)) {
            CloudBackConfig config = CloudBackConfig.getCloudBackConfig(cloudType);
            if (config == null) {
                config = new CloudBackConfig(cloudType);
            }
            config.setEnabled(true);
            config.getWebConfig().setUrl(newUrl);
            config.save();
            OrderMate.LOG.info("Setting " + (Object)((Object)cloudType) + " url to " + newUrl);
        }
    }

    @POST
    @Path(value="sitesetup")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response postStoreSetup(String payload) {
        return this.getBadRequestResponse("Not implemented yet - Give Jez Coffee");
    }

    @GET
    @Path(value="sitesetup")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response getStoreSetup() {
        OrderMate.LOG.info("Site info requested");
        HMStoreSetup hmSetup = new HMStoreSetup();
        hmSetup.setLabel(BusinessInfo.getInstance().getName());
        Terminal servermate = Terminal.getServerMateTerminal();
        HMTerminal smTerm = new HMTerminal();
        smTerm.setActive(true);
        smTerm.setLabel(servermate.getLabel());
        smTerm.setLocation(servermate.getLocation() == null ? null : servermate.getLocation().toString());
        smTerm.setPosId(servermate.getID().toString());
        hmSetup.getTerminals().add(smTerm);
        List<Terminal> terminals = PersistenceManager.getObjectList(Terminal.class, Query.select(Terminal.class).equals(Terminal.Properties.TERMINAL_TYPE, "WaiterMate").orderBy(Terminal.Properties.ID).toString());
        for (Terminal terminal : terminals) {
            HMTerminal hMTerminal = new HMTerminal();
            hMTerminal.setActive("ACTIVE".equals(terminal.getSystemState()));
            hMTerminal.setLabel(terminal.getLabel());
            hMTerminal.setLocation(terminal.getLocation() == null ? null : terminal.getLocation().getLabel());
            hMTerminal.setPosId(terminal.getID().toString());
            hmSetup.getTerminals().add(hMTerminal);
        }
        List<User> users = PersistenceManager.getObjectList(User.class, Query.select(User.class).active(User.class).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME).toString());
        for (User user : users) {
            HMPosUser hmUser = new HMPosUser();
            hmUser.setPosId(user.getID().toString());
            hmUser.setFirstName(user.getFirstName());
            hmUser.setLastName(user.getLastName());
            hmSetup.getUsers().add(hmUser);
        }
        List<InventoryPriceAdjustment> list = PersistenceManager.getObjectList(InventoryPriceAdjustment.class, Query.select(InventoryPriceAdjustment.class).active(InventoryPriceAdjustment.class).orderBy(InventoryPriceAdjustment.Properties.ID).toString());
        for (InventoryPriceAdjustment adj : list) {
            if (!PriceAdjustmentType.NORMAL.equals(adj.getType()) || !SystemState.ACTIVE_STATE.equals(adj.getSystemState()) || !PriceAdjustmentUnit.DOLLAR_UNIT.equals(adj.getUnit()) && !PriceAdjustmentUnit.PERCENTAGE_UNIT.equals(adj.getUnit())) continue;
            HMPriceAdjustment hmAdj = new HMPriceAdjustment();
            hmAdj.setLabel(adj.getLabel());
            hmAdj.setPosId(adj.getID().toString());
            if (PriceAdjustmentUnit.DOLLAR_UNIT.equals(adj.getUnit())) {
                hmAdj.setAmount(adj.getDollarAmount().toBigDecimal());
                hmAdj.setType(HMAdjustmentType.DOLLAR);
            } else {
                hmAdj.setAmount(new BigDecimal(adj.getPercentage()));
                hmAdj.setType(HMAdjustmentType.PERCENT);
            }
            if (PriceAdjustmentDirection.DISCOUNT.equals(adj.getDirection())) {
                hmAdj.setAmount(hmAdj.getAmount().negate());
            }
            hmSetup.getAdjustments().add(hmAdj);
        }
        for (InventoryProfile profile : InventoryProfile.getAllProfiles()) {
            HMProfile hmProfile = new HMProfile();
            hmProfile.setLabel(profile.getLabel());
            hmProfile.setPosId(profile.getID().toString());
            hmSetup.getProfiles().add(hmProfile);
        }
        List<PriceLevel> list2 = PersistenceManager.getObjectList(PriceLevel.class, Query.select(PriceLevel.class).active(PriceLevel.class).orderBy(PriceLevel.Properties.DEFAULT_LEVEL).orderBy(PriceLevel.Properties.ID).toString());
        for (PriceLevel level : list2) {
            HMPriceLevel hmLevel = new HMPriceLevel();
            hmLevel.setDefaultLevel(Boolean.valueOf(level.isDefaultLevel()));
            hmLevel.setLabel(level.getLabel());
            hmLevel.setPosId(level.getID().toString());
            hmSetup.getPriceLevels().add(hmLevel);
        }
        return this.getResponse(hmSetup);
    }
}

