/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.invoice;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.Account;
import ordermate.reports.printing.InvoiceReport;
import ordermate.webresource.AbstractResource;

@Path(value="")
public class TaxInvoiceResource
extends AbstractResource {
    private static final String MEDIA_TYPE_PDF = "application/pdf";

    @GET
    @Produces(value={"text/plain", "application/pdf"})
    @Path(value="{accountId}")
    public Response getTaxInvoice(@PathParam(value="accountId") String accountId) {
        try {
            Account account = PersistenceManager.getByID(Long.parseLong(accountId), Account.class);
            if (account == null) {
                return this.getNotFoundResponse();
            }
            InvoiceReport invoiceReport = new InvoiceReport("/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            invoiceReport.setAccount(account);
            invoiceReport.generate();
            String businessNameNoSpaces = BusinessInfo.getInstance().getName().replace(' ', '_');
            String fileName = String.format("C:\\Temp\\%s-Tax_Invoice-%s.pdf", businessNameNoSpaces, account.getID());
            JasperPrintManager.printReportToPdfFile((JasperPrint)invoiceReport.getReport(), (String)fileName);
            File createdFile = new File(fileName);
            createdFile.deleteOnExit();
            return this.getOKResponse(createdFile);
        }
        catch (Exception ex) {
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }
}

