/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.kiosk;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.kiosk.Kiosk;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.KioskProperty;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuCombo;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.GridOrderingKioskPage;
import ordermate.database.kiosk.pages.ImageAndTextKioskPage;
import ordermate.database.kiosk.pages.KioskPage;
import ordermate.database.kiosk.pages.KioskPageType;
import ordermate.database.kiosk.pages.TabbedOrderingKioskPage;
import ordermate.database.kiosk.pages.item.KioskPageCombo;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;
import ordermate.database.kiosk.pages.item.KioskPageUnitPrice;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.jaxb.kiosk.ObjectFactory;
import ordermate.integration.jaxb.kiosk.WebKiosk;
import ordermate.integration.jaxb.kiosk.WebKioskCourse;
import ordermate.integration.jaxb.kiosk.WebKioskMenu;
import ordermate.integration.jaxb.kiosk.WebKioskMenuCombo;
import ordermate.integration.jaxb.kiosk.WebKioskPage;
import ordermate.integration.jaxb.kiosk.WebKioskPageCombo;
import ordermate.integration.jaxb.kiosk.WebKioskPageGroupType;
import ordermate.integration.jaxb.kiosk.WebKioskPageItem;
import ordermate.integration.jaxb.kiosk.WebKioskPageType;
import ordermate.integration.jaxb.kiosk.WebKioskPageUnitPrice;
import ordermate.integration.jaxb.kiosk.WebKioskPath;
import ordermate.integration.jaxb.kiosk.WebKioskPathType;
import ordermate.integration.jaxb.kiosk.WebKioskPaymentIntegrationType;
import ordermate.integration.jaxb.kiosk.WebKioskProperty;
import ordermate.integration.jaxb.kiosk.WebKioskType;
import ordermate.integration.jaxb.kiosk.WebKioskUnitPriceLevel;
import ordermate.integration.jaxb.kiosk.WebTable;
import ordermate.integration.jaxb.kiosk.WebTableGroup;
import ordermate.webresource.WebResourceExporter;

public class KioskSettingsExporter
extends WebResourceExporter<Kiosk> {
    ObjectFactory kioskObjectFactory = new ObjectFactory();

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{WebKiosk.class, WebKioskPath.class, WebKioskPage.class, WebKioskPageItem.class, WebKioskUnitPriceLevel.class, WebKioskMenuCombo.class, WebKioskPageType.class, WebKioskPathType.class, WebKioskType.class};
    }

    @Override
    public String getName() {
        return "Kiosk Settings Resource";
    }

    public WebKiosk getCurrentlyActiveKioskSettings(String ip) {
        WebKiosk result = this.kioskObjectFactory.createWebKiosk();
        List<Kiosk> kioskSettings = PersistenceManager.getObjectList(Kiosk.class, Query.select(Kiosk.class).toString());
        for (Kiosk kiosk : kioskSettings) {
            if (kiosk.getIp() == null || !kiosk.getIp().equalsIgnoreCase(ip)) continue;
            if (this.fillWebKioskFromKioskSource(result, kiosk)) {
                return result;
            }
            result = null;
            return result;
        }
        result = null;
        return result;
    }

    public long getCurrentlyActiveKioskSettingsVersion(String ip) {
        long version = 0L;
        List<Kiosk> kioskSettings = PersistenceManager.getObjectList(Kiosk.class, Query.select(Kiosk.class).toString());
        for (Kiosk kiosk : kioskSettings) {
            if (!kiosk.getIp().equalsIgnoreCase(ip)) continue;
            version = kiosk.getVersion();
            return version;
        }
        return version;
    }

    private boolean fillWebKioskFromKioskSource(WebKiosk webKiosk, Kiosk posKiosk) {
        boolean result = true;
        if (webKiosk == null || posKiosk == null) {
            OrderMate.LOG.error("webresource object or database object is null - not able to fill webresource 'WebKiosk'...");
            result = false;
            return result;
        }
        try {
            webKiosk.setID(posKiosk.getID());
            webKiosk.setIp(posKiosk.getIp());
            webKiosk.setLabel(posKiosk.getLabel());
            webKiosk.setSettingversion(posKiosk.getSettingversion());
            webKiosk.setKioskType(WebKioskType.fromValue(posKiosk.getKioskType().toString()));
            webKiosk.setWelcomeTitle(posKiosk.getWelcomeTitle());
            webKiosk.setWelcomeText(posKiosk.getWelcomeText());
            webKiosk.setTheme(posKiosk.getTheme());
            webKiosk.setPaymentIntegrationType(WebKioskPaymentIntegrationType.fromValue(posKiosk.getIntegratedPaymentType().toString()));
            if (posKiosk.getPaymentCashDrawer() != null) {
                webKiosk.setIntegratedPaymentCashdrawer(posKiosk.getPaymentCashDrawer().getID());
            }
            webKiosk.setMaxIntegratedPaymentAmount(posKiosk.getMaxIntegratedPaymentAmount().doubleValue());
            this.addTableGroupsToWebKiosk(webKiosk);
            ArrayList<WebKioskProperty> kioskProperties = new ArrayList<WebKioskProperty>();
            for (KioskProperty prop : posKiosk.getKioskProps()) {
                WebKioskProperty webProp = this.kioskObjectFactory.createWebKioskProperty();
                webProp.setKey(prop.getKey());
                webProp.setValue(prop.getValue());
                kioskProperties.add(webProp);
            }
            webKiosk.getKioskPropertys().addAll(kioskProperties);
            HashSet<KioskMenu> menus = new HashSet<KioskMenu>();
            for (KioskPath path : posKiosk.getPaths()) {
                WebKioskPath webPath = this.kioskObjectFactory.createWebKioskPath();
                webPath.setID(path.getID());
                webPath.setLabel(path.getLabel());
                webPath.setRequireLogin(path.isRequireLogin());
                webPath.setShowLoginAtStart(path.isShowLoginAtStart());
                webPath.setPathAlias(path.getAlias());
                webPath.setPathIcon(path.getPathIcon());
                if (path.getPathType() != null && !path.getPathType().toString().isEmpty()) {
                    webPath.setPathType(WebKioskPathType.fromValue(path.getPathType().toString()));
                }
                for (KioskPage page : path.getPages()) {
                    KioskPageType type = page.getKioskPageType();
                    WebKioskPage webPage = this.kioskObjectFactory.createWebKioskPage();
                    webPage.setID(page.getID());
                    webPage.setForced(page.isForced());
                    webPage.setWelcomeText(page.getWelcomeText());
                    webPage.setSequence(page.getSequence());
                    webPage.setLabel(page.getLabel());
                    webPage.setBackground(page.getBackground());
                    webPage.setOneTouchOrdering(page.isOneTouchOrdering());
                    webPage.setFastFinish(page.getFastFinish());
                    if (type.equals((Object)KioskPageType.ImageAndText)) {
                        webPage.setPageImage(((ImageAndTextKioskPage)page).getPageImage());
                        webPage.setPageText(((ImageAndTextKioskPage)page).getPageText());
                        webPage.setPageType(WebKioskPageType.IMAGE_AND_TEXT);
                    } else if (type.equals((Object)KioskPageType.GridOrdering) || type.equals((Object)KioskPageType.TabbedOrdering)) {
                        AbstractOrderingKioskPage orderingPage = (AbstractOrderingKioskPage)page;
                        webPage.setPageGroupType(WebKioskPageGroupType.fromValue(orderingPage.getItemGroupType().name()));
                        if (orderingPage.getCourse() != null) {
                            WebKioskCourse webCourse = this.kioskObjectFactory.createWebKioskCourse();
                            webCourse.setID(orderingPage.getCourse().getID());
                            webCourse.setName(orderingPage.getCourse().getName());
                            webCourse.setSequence(orderingPage.getCourse().getSequence());
                            webPage.setWebKioskCourse(webCourse);
                        }
                        this.setPageItems(webPage, orderingPage);
                        if (KioskPageType.GridOrdering.equals((Object)type)) {
                            webPage.setColumns(((GridOrderingKioskPage)page).getColumns());
                            webPage.setRows(((GridOrderingKioskPage)page).getRows());
                            webPage.setPageType(WebKioskPageType.GRID_ORDERING);
                        } else if (KioskPageType.TabbedOrdering.equals((Object)type)) {
                            webPage.setColumns(((TabbedOrderingKioskPage)page).getColumns());
                            webPage.setRows(((TabbedOrderingKioskPage)page).getRows());
                            webPage.setPageType(WebKioskPageType.TABBED_ORDERING);
                        }
                    }
                    webPath.getWebKioskPages().add(webPage);
                }
                menus.add(path.getMenu());
                webKiosk.getKioskPaths().add(webPath);
            }
            for (KioskMenu nextMenu : menus) {
                webKiosk.getKioskMenus().add(this.createKioskMenuWithAllAvailableMenuItems(nextMenu));
            }
        }
        catch (Exception ex) {
            result = false;
            ex.printStackTrace();
            OrderMateLog.LOG.error("error while trying to fill the kiosk settings webresource... exception: " + ex.getMessage());
        }
        return result;
    }

    private void addTableGroupsToWebKiosk(WebKiosk webKiosk) {
        webKiosk.getWebTableGroups().addAll(this.getWebTableGroups());
    }

    public List<WebTableGroup> getWebTableGroups() {
        ArrayList<WebTableGroup> groups = new ArrayList<WebTableGroup>();
        for (TableGroup tg : TableGroupQueries.getTableGroups()) {
            WebTableGroup webTableGroup = this.kioskObjectFactory.createWebTableGroup();
            webTableGroup.setID(tg.getID());
            webTableGroup.setName(tg.getName());
            webTableGroup.setSequence(tg.getSequence());
            this.addTablesToGroup(tg, webTableGroup);
            groups.add(webTableGroup);
        }
        return groups;
    }

    private void addTablesToGroup(TableGroup posTableGroup, WebTableGroup webTableGroup) {
        List<WebTable> kioskTables = webTableGroup.getTables();
        for (LogicalTable nextTable : posTableGroup.getTables()) {
            PhysicalTable primPhysTable = nextTable.getPrimaryPhysicalTable();
            WebTable webTable = this.kioskObjectFactory.createWebTable();
            webTable.setID(primPhysTable.getID());
            webTable.setName(primPhysTable.getName());
            kioskTables.add(webTable);
        }
    }

    private WebKioskMenu createKioskMenuWithAllAvailableMenuItems(KioskMenu menu) {
        List<KioskMenuUnitPriceLevel> levels = menu.getActiveLevels();
        WebKioskMenu webMenu = this.kioskObjectFactory.createWebKioskMenu();
        webMenu.setID(menu.getID());
        webMenu.setLabel(menu.getLabel());
        webMenu.setStoreId(menu.getStoreId());
        webMenu.setVersion(menu.getVersion());
        for (KioskMenuUnitPriceLevel kioskUnitPrice : levels) {
            WebKioskUnitPriceLevel webUnitPrice = this.kioskObjectFactory.createWebKioskUnitPriceLevel();
            webUnitPrice.setID(kioskUnitPrice.getID());
            webUnitPrice.setUnitId(kioskUnitPrice.getUnitPriceLevel().getUnit().getID());
            webUnitPrice.setPriceLevelId(kioskUnitPrice.getUnitPriceLevel().getPriceLevel().getID());
            webUnitPrice.setLabel(kioskUnitPrice.getUnitPriceLevel().getUnit().getItemLabel());
            webUnitPrice.setIcon(kioskUnitPrice.getIcon());
            webUnitPrice.setItemAlias(kioskUnitPrice.getItemAlias());
            webMenu.getWebKioskUnitPriceLevels().add(webUnitPrice);
        }
        for (KioskMenuCombo kioskCombo : menu.getActiveCombos()) {
            WebKioskMenuCombo webCombo = this.kioskObjectFactory.createWebKioskMenuCombo();
            webCombo.setID(kioskCombo.getID());
            webCombo.setComboId(kioskCombo.getCombo().getID());
            webCombo.setLabel(kioskCombo.getCombo().getLabel());
            webCombo.setComboIcon(kioskCombo.getComboIcon());
            webCombo.setComboAlias(kioskCombo.getComboAlias());
            webMenu.getWebKioskCombos().add(webCombo);
        }
        return webMenu;
    }

    private void setPageItems(WebKioskPage webPage, AbstractOrderingKioskPage page) {
        this.loadPageItem(page.getPageItems(KioskPageItemType.UnitPrice), webPage.getWebKioskPageUnitPrices());
        this.loadPageItem(page.getPageItems(KioskPageItemType.Combo), webPage.getWebKioskPageCombos());
        this.loadPageItem(page.getPageItems(KioskPageItemType.Clickable), webPage.getWebKioskPageClickables());
    }

    private void loadPageItem(List<KioskPageItem> items, List webItems) {
        webItems.clear();
        for (KioskPageItem item : items) {
            webItems.add(this.makePageItem(item));
        }
    }

    private WebKioskPageItem makePageItem(KioskPageItem posPageItem) {
        WebKioskPageItem webPageItem;
        if (KioskPageItemType.Clickable.equals((Object)posPageItem.getItemType())) {
            webPageItem = this.kioskObjectFactory.createWebKioskPageClickable();
        } else if (KioskPageItemType.Combo.equals((Object)posPageItem.getItemType())) {
            webPageItem = this.kioskObjectFactory.createWebKioskPageCombo();
            KioskMenuCombo combo = ((KioskPageCombo)posPageItem).getOrderableCombo();
            if (combo != null) {
                ((WebKioskPageCombo)webPageItem).setWebKioskMenuComboId(combo.getID());
            }
        } else if (KioskPageItemType.UnitPrice.equals((Object)posPageItem.getItemType())) {
            webPageItem = this.kioskObjectFactory.createWebKioskPageUnitPrice();
            KioskPageUnitPrice unitPriceItem = (KioskPageUnitPrice)posPageItem;
            KioskMenuUnitPriceLevel unitPriceLevel = unitPriceItem.getOrderableUnitPriceLevel();
            if (unitPriceLevel != null) {
                ((WebKioskPageUnitPrice)webPageItem).setWebKioskMenuUnitPriceLevelId(unitPriceLevel.getID());
            }
        } else {
            throw new IllegalArgumentException("Unknown kind of KioskPageItemType:" + (Object)((Object)posPageItem.getItemType()));
        }
        webPageItem.setID(posPageItem.getID());
        webPageItem.setSequence(posPageItem.getSequence());
        webPageItem.setLabel(posPageItem.getLabel());
        webPageItem.setIcon(posPageItem.getIcon());
        KioskPage nextPage = posPageItem.getNextPage();
        if (nextPage != null) {
            webPageItem.setNextPageId(nextPage.getID());
        }
        return webPageItem;
    }
}

