/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.menu;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.humpback.table.HMTable;
import au.com.ordermate.xmlintegration.humpback.table.HMTableSection;
import au.com.ordermate.xmlintegration.humpback.table.HMTableSetup;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Semaphore;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockSupplier;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.hom.commandqueue.menu.MenuDownloadAction;
import ordermate.hom.commandqueue.menu.MenuDownloadRequestActionFactory;
import ordermate.jaxb.exporter.handlers.posdatabase.ExportMode;
import ordermate.jaxb.exporter.handlers.posdatabase.PosMenuExportTask;
import ordermate.jaxb.exporter.handlers.posdatabase.PosMenuImportTask;
import ordermate.scheduler.quartz.CronExpression;
import ordermate.webresource.AbstractResource;
import org.apache.commons.codec.digest.DigestUtils;

@Path(value="")
public class PosMenuResource
extends AbstractResource {
    private static final Semaphore lock = new Semaphore(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml"})
    @Path(value="export")
    public Response exportMenu(@QueryParam(value="exportMode") String exportMode, @QueryParam(value="isExportStock") String isExportStock) {
        OrderMate.LOG.info("PosMenu export requested");
        if (lock.tryAcquire()) {
            try {
                PosMenuExportTask export = new PosMenuExportTask();
                if (isExportStock == null || isExportStock.equalsIgnoreCase("true")) {
                    export.setStockAreas(StockArea.getStockAreas());
                    export.setStockSuppliers(StockSupplier.getSuppliers());
                }
                export.setCombos(InventoryCombo.getAllActiveCombos());
                export.setDiscounts(InventoryPriceAdjustment.getAllPriceAdjustments());
                export.setProfiles(InventoryProfile.getAllProfiles());
                export.setMenuGroups(PersistenceManager.getObjectList(InventoryGroup.class, Query.select(InventoryGroup.class).wherePropertyIn(InventoryGroup.Properties.PROFILE, InventoryProfile.getAllProfiles()).toString()));
                export.setPriceLevels(PriceLevel.getAllPriceLevels());
                export.setExportMode(exportMode != null ? ExportMode.valueOf(exportMode) : ExportMode.Complete);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                export.setOutputStream(bout);
                export.runLocal();
                bout.flush();
                bout.close();
                Response response = this.getOKResponse(bout.toString(StandardCharsets.UTF_8.name()));
                return response;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot export menu:", (Throwable)ex);
            }
            finally {
                lock.release();
            }
        }
        return this.getBadRequestResponse("Menu is concurrently being accessed. Try again later.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    @Path(value="import")
    public Response importMenu(@QueryParam(value="mangle") String mangle, String menuXml) {
        if (lock.tryAcquire()) {
            OnlineIntegrationIDStrategy oldStrat = null;
            SystemProperty sysProp = SystemProperty.getInstance();
            try {
                if (!this.checkValidity(mangle, menuXml)) {
                    Response response = this.getBadRequestResponse("Checksum invalid.");
                    return response;
                }
                this.saveToFile(menuXml);
                oldStrat = sysProp.getOnlineIntegrationIdStrategy();
                if (OnlineIntegrationIDStrategy.POS_DB.equals((Object)oldStrat)) {
                    sysProp.setOnlineIntegrationIdStrategy(OnlineIntegrationIDStrategy.MASTER_ID);
                    sysProp.save();
                }
                PosMenuImportTask importTask = new PosMenuImportTask();
                importTask.setInputStream(new ByteArrayInputStream(menuXml.getBytes("UTF-8")));
                importTask.runLocal();
                Response response = this.getOKResponse("Menu successfully imported");
                return response;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot import menu:", (Throwable)ex);
                Response response = this.getInternalServerErrorResponse("Error importing menu");
                return response;
            }
            finally {
                if (oldStrat != null && OnlineIntegrationIDStrategy.POS_DB.equals((Object)oldStrat)) {
                    sysProp.setOnlineIntegrationIdStrategy(OnlineIntegrationIDStrategy.POS_DB);
                    sysProp.save();
                }
                lock.release();
            }
        }
        return this.getBadRequestResponse("Menu is concurrently being accessed. Try again later.");
    }

    private void saveToFile(String menuXml) {
        try {
            File output = new File("C:\\temp\\humpbackMenu.xml");
            if (output.exists()) {
                output.delete();
            }
            StringUtils.writeTextToFile(output, menuXml);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot save HumpBack menu file", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    @Path(value="scheduleimport")
    public Response scheduleImportMenu(@QueryParam(value="cron") String cron, @QueryParam(value="url") String url, @QueryParam(value="exportid") Long exportId, @QueryParam(value="exportname") String exportName, @QueryParam(value="exportmode") String exportMode) {
        if (lock.tryAcquire()) {
            try {
                if (StringUtils.isEmpty(cron)) {
                    Response response = this.getBadRequestResponse("cron cannot be empty");
                    return response;
                }
                if (!CronExpression.isValidExpression(cron)) {
                    Response response = this.getBadRequestResponse("cron is invalid");
                    return response;
                }
                if (url == null || exportId == null || exportName == null || exportMode == null) {
                    Response response = this.getBadRequestResponse("Invalid, non-optional parameters:\r\n" + url + " " + exportId + " " + exportName + " " + exportMode);
                    return response;
                }
                MenuDownloadAction action = (MenuDownloadAction)new MenuDownloadRequestActionFactory().createMessageAction(null, null);
                action.setProperty("menuDownloadLocation", url);
                action.setProperty("cronSchedule", cron);
                action.setProperty("menuId", exportId);
                action.setProperty("menuName", exportName);
                action.setProperty("exportMode", exportMode);
                action.call();
                Response response = this.getOKResponse("Schedule has been successful");
                return response;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot save menu download schedule", (Throwable)ex);
                Response response = this.getInternalServerErrorResponse("Cannot save schedule");
                return response;
            }
            finally {
                lock.release();
            }
        }
        return this.getBadRequestResponse("Menu is concurrently being accessed. Try again later.");
    }

    private boolean checkValidity(String md5, String menuXml) {
        long rbId = SystemCurrentInfo.getInstance().getRedbackId();
        String digest = DigestUtils.md5Hex((String)(DigestUtils.md5Hex((String)menuXml) + rbId));
        boolean valid = md5.equals(digest);
        if (!valid) {
            OrderMate.LOG.info("Menu import checksum not valid for " + rbId + ":\r\n" + md5 + " vs \r\n" + digest);
        }
        return valid;
    }

    @GET
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/tablesetup")
    public Response getHumpBackTables(@QueryParam(value="orderable") Boolean orderable, @QueryParam(value="onlinesections") Boolean onlineSections) {
        OrderMate.LOG.info("Table setup information requested");
        HMTableSetup setup = new HMTableSetup();
        setup.setLabel("OMTables");
        TableGroupQueries.clearCache();
        for (TableGroup tg : TableGroupQueries.getTableGroups()) {
            HMTableSection nextSection = new HMTableSection();
            if (onlineSections != null && onlineSections.booleanValue() != tg.isOnline()) continue;
            nextSection.setPosId(tg.getID().toString());
            nextSection.setOnlineOnly(Boolean.valueOf(tg.isOnline()));
            nextSection.setName(tg.getLabel());
            setup.getSections().add(nextSection);
            for (LogicalTable logTable : tg.getTables()) {
                if (!"ACTIVE".equals(logTable.getSystemState()) || orderable != null && orderable.booleanValue() != logTable.canOrderTo()) continue;
                for (PhysicalTable table : logTable.getPhysicalTables()) {
                    if (!"ACTIVE".equals(table.getSystemState())) continue;
                    HMTable nextTable = new HMTable();
                    nextTable.setName(table.getName());
                    nextTable.setOrderable(Boolean.valueOf(logTable.canOrderTo()));
                    nextTable.setPosId(table.getID().toString());
                    nextTable.setSeats(BigInteger.valueOf(table.getSeats()));
                    nextSection.getTables().add(nextTable);
                }
            }
        }
        return this.getOKResponse(setup);
    }
}

