/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.online;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.TableAccount;
import ordermate.integration.jaxb.online.status.OnlineOrderStatusEntry;
import ordermate.integration.jaxb.online.status.StatusCodeType;
import ordermate.jaxb.exporter.XMLHelper;

public class AccountStatusHelper {
    private static final String DOSHII = "Doshii";

    public OnlineOrderStatusEntry getStatus(Long orderId, String vendorId) throws Exception {
        OnlineOrderStatusEntry entry = new OnlineOrderStatusEntry();
        entry.setOrderId(orderId);
        entry.setRequestDatetime(XMLHelper.getDateType(new Date()));
        if (!this.isGoodEntry(orderId, entry)) {
            throw new IllegalArgumentException("orderId was invalid!");
        }
        Account account = this.getAccount(orderId, entry);
        if (account == null) {
            throw new IllegalArgumentException("orderId was invalid!");
        }
        if (!this.isValidVendor(account, vendorId, entry)) {
            throw new IllegalArgumentException("vendorId was invalid!");
        }
        this.doStatus(account, entry);
        return entry;
    }

    public void doStatus(Account account, OnlineOrderStatusEntry entry) {
        entry.setOrderExtId(account.getExtOrderID());
        if (!account.isOpen() && account.getItems().isEmpty()) {
            OrderMate.LOG.warn("Online account is marked as rejected:" + entry.getOrderId());
            entry.setStatusCode(StatusCodeType.REJECTED);
            return;
        }
        if (account.getEta() != null) {
            entry.setExpectedReadyTime(XMLHelper.getDateType(account.getEta()));
        }
        if (!account.isOpen()) {
            entry.setStatusCode(StatusCodeType.CLOSED);
        } else if (account instanceof OnlineAccount) {
            if (DOSHII.equals(account.getSource())) {
                entry.setStatusCode(StatusCodeType.APPROVED);
            } else if (((OnlineAccount)account).getAcknowledgedTime() == null) {
                entry.setStatusCode(StatusCodeType.VALID);
            } else {
                entry.setStatusCode(StatusCodeType.APPROVED);
            }
        } else {
            entry.setStatusCode(StatusCodeType.APPROVED);
        }
    }

    private boolean isGoodEntry(Long orderId, OnlineOrderStatusEntry entry) {
        if (orderId == null || orderId <= 0L) {
            OrderMate.LOG.warn("Cannot retrieve online status for null or 0 id: " + orderId);
            entry.setStatusCode(StatusCodeType.NOT_AVAILABLE);
            return false;
        }
        return true;
    }

    private Account getAccount(Long orderId, OnlineOrderStatusEntry entry) {
        Account account = PersistenceManager.getByID(orderId, Account.class);
        if (account == null) {
            OrderMate.LOG.warn("Cannot retrieve online status for account:" + orderId);
            entry.setStatusCode(StatusCodeType.NOT_AVAILABLE);
            return null;
        }
        return account;
    }

    private boolean isValidVendor(Account account, String providerId, OnlineOrderStatusEntry entry) {
        if (account instanceof BarTabAccount) {
            return true;
        }
        String source = account.getSource();
        if (account instanceof OnlineAccount) {
            if (source != null && !source.trim().isEmpty() && source.equals(providerId)) {
                return true;
            }
            OrderMate.LOG.warn("Vendor cannot access other party's accounts:" + source + " but was " + providerId);
        }
        if (source != null && !source.trim().isEmpty() && source.equals(providerId)) {
            return true;
        }
        if (account instanceof TableAccount && AccountType.onlineTableType.equals(account.getAccountType())) {
            return true;
        }
        if (!StringUtils.isEmpty(source) && source.equals(providerId)) {
            return true;
        }
        OrderMate.LOG.warn("Vendor cannot access other party's accounts:" + source + " but was " + providerId);
        entry.setStatusCode(StatusCodeType.NOT_AVAILABLE);
        return false;
    }
}

