/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.online;

import au.com.ordermate.integration.jaxb.exceptions.CouldNotMarshalException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.database.sales.OnlineAccount;
import ordermate.integration.jaxb.online.sales.ErrorCodeType;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OnlineOrderErrorEntry;
import ordermate.integration.jaxb.online.sales.OnlineOrderErrorList;
import ordermate.webresource.WebResourceExporter;
import org.xml.sax.SAXParseException;

public class OnlineOrderErrorExporter
extends WebResourceExporter<OnlineOrderErrorList> {
    private final DatatypeFactory datatypeFactory;
    private ObjectFactory objFactory = new ObjectFactory();

    public OnlineOrderErrorExporter() throws DatatypeConfigurationException {
        this.datatypeFactory = DatatypeFactory.newInstance();
    }

    public void exportFailedOnlineAccounts(List<OnlineAccount> failedAccounts, OutputStream output) throws JAXBException {
        if (output == null) {
            throw new IllegalArgumentException("The outputStream cannot be null.");
        }
        if (failedAccounts == null || failedAccounts.isEmpty()) {
            throw new IllegalArgumentException("There are no errors of failedAccounts in the list.");
        }
        OnlineOrderErrorList errorList = this.buildErrorListFromResult(failedAccounts);
        Class[] boundClasses = new Class[]{OnlineOrderErrorEntry.class, OnlineOrderErrorList.class};
        Marshaller marshaller = JAXBContext.newInstance((Class[])boundClasses).createMarshaller();
        marshaller.marshal((Object)errorList, output);
    }

    public void exportFailedOnlineOrder(Exception e, FileOutputStream output) throws JAXBException {
        if (output == null) {
            throw new IllegalArgumentException("The outputStream cannot be null.");
        }
        if (e == null) {
            throw new IllegalArgumentException("There is no exception available to process the error.");
        }
        OnlineOrderErrorList errorList = this.buildErrorListFromException(e);
        Class[] boundClasses = new Class[]{OnlineOrderErrorEntry.class, OnlineOrderErrorList.class};
        Marshaller marshaller = JAXBContext.newInstance((Class[])boundClasses).createMarshaller();
        marshaller.marshal((Object)errorList, (OutputStream)output);
    }

    private OnlineOrderErrorList buildErrorListFromResult(List<OnlineAccount> failedAccounts) {
        OnlineOrderErrorList result = new OnlineOrderErrorList();
        if (failedAccounts != null && !failedAccounts.isEmpty()) {
            for (OnlineAccount failedAccount : failedAccounts) {
                OnlineOrderErrorEntry entry = new OnlineOrderErrorEntry();
                entry.setIdFailedSaleOrder(failedAccount.getID());
                String errorText = "an error occured on online order nr. '" + failedAccount.getOrderNumber() + "'/" + failedAccount.getLabel() + ".";
                entry.setDescription(errorText);
                Calendar cal = Calendar.getInstance();
                cal.setTime(failedAccount.getCreationDateTime());
                entry.setDate(this.makeXMLDate(cal));
                result.getOnlineOrderError().add(entry);
            }
        }
        return result;
    }

    public OnlineOrderErrorList buildErrorListFromException(Exception e) {
        OnlineOrderErrorList result = new OnlineOrderErrorList();
        OnlineOrderErrorEntry entry = new OnlineOrderErrorEntry();
        this.processExceptionMessage(e, entry);
        result.getOnlineOrderError().add(entry);
        return result;
    }

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{OnlineOrderErrorEntry.class, OnlineOrderErrorList.class};
    }

    @Override
    public String getName() {
        return "Online Order Errors";
    }

    private XMLGregorianCalendar makeXMLDate(Calendar date) {
        return this.datatypeFactory.newXMLGregorianCalendarDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE);
    }

    private void processExceptionMessage(Exception e, OnlineOrderErrorEntry entry) {
        String errorMessage = "";
        if (e != null) {
            entry.setDate(this.makeXMLDate(Calendar.getInstance()));
            if (e instanceof CouldNotMarshalException) {
                entry.setErrorCode(ErrorCodeType.XML_FORMAT_ERROR);
                if (e.getCause() instanceof UnmarshalException) {
                    if (((UnmarshalException)e.getCause()).getLinkedException() instanceof SAXParseException) {
                        int lineNumber = 0;
                        int columnNumber = 0;
                        if ((SAXParseException)((UnmarshalException)e.getCause()).getLinkedException() != null) {
                            lineNumber = ((SAXParseException)((UnmarshalException)e.getCause()).getLinkedException()).getLineNumber();
                            columnNumber = ((SAXParseException)((UnmarshalException)e.getCause()).getLinkedException()).getColumnNumber();
                            errorMessage = errorMessage + "Error in column " + columnNumber + " / line " + lineNumber + ": ";
                        }
                    }
                    errorMessage = errorMessage + ((UnmarshalException)e.getCause()).getLinkedException().getMessage();
                } else {
                    errorMessage = e.getMessage();
                }
            } else if (e instanceof SAXParseException) {
                entry.setErrorCode(ErrorCodeType.XML_FORMAT_ERROR);
                errorMessage = "Error in column " + ((SAXParseException)e).getColumnNumber() + " / line " + ((SAXParseException)e).getLineNumber() + ": " + e.getMessage();
            } else if (e instanceof IllegalArgumentException) {
                entry.setErrorCode(ErrorCodeType.ORDER_INVALID);
                errorMessage = e.getMessage();
            } else if (e instanceof IllegalStateException) {
                entry.setErrorCode(ErrorCodeType.ORDER_NOT_COMPLETE);
                errorMessage = e.getMessage();
            } else {
                entry.setErrorCode(ErrorCodeType.ORDER_OTHER_ERROR);
                errorMessage = e.getMessage();
            }
            entry.setDescription(errorMessage);
        }
    }
}

