/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.online;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.queries.inventory.InventoryAddQueries;
import ordermate.database.queries.inventory.InventoryComboGroupQueries;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.queries.inventory.InventoryItemQueries;
import ordermate.database.queries.inventory.InventoryOptionQueries;
import ordermate.database.queries.inventory.InventoryRemoveQueries;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.SimplePrintJob;
import ordermate.gui.SimpleSaveAccount;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.jaxb.online.menu.OrderMateMenu;
import ordermate.integration.jaxb.online.menumapping.IdMapping;
import ordermate.integration.jaxb.online.menumapping.IdStrategy;
import ordermate.integration.jaxb.online.menumapping.MenuMapping;
import ordermate.integration.jaxb.online.menumapping.MenuMappingData;
import ordermate.integration.jaxb.online.menumapping.MenuMappingType;
import ordermate.integration.jaxb.online.order.OnlineOrderResult;
import ordermate.integration.jaxb.online.order.PriceLevel;
import ordermate.integration.jaxb.online.order.PriceLevelList;
import ordermate.integration.jaxb.online.order.Profile;
import ordermate.integration.jaxb.online.order.ProfileList;
import ordermate.integration.jaxb.online.sales.ExportCustomer;
import ordermate.integration.jaxb.online.sales.LineItem;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OnlinePrePayment;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.jaxb.online.status.OnlineOrderStatusEntry;
import ordermate.integration.jaxb.online.status.OnlineOrderStatusList;
import ordermate.integration.onlinesales.OnlineAccountIntegrator;
import ordermate.integration.onlinesales.OnlineTableAccountIntegrator;
import ordermate.integration.onlinesales.TableBusyException;
import ordermate.jaxb.exporter.handlers.online.InventoryProfilerExporter;
import ordermate.jaxb.exporter.handlers.online.sales.AccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.CustomerHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderAccountType;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPostwork;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.online.AccountStatusHelper;
import ordermate.webresource.online.OnlineOrderResultCode;
import org.apache.logging.log4j.Level;

@Path(value="")
public class OnlineOrderResource
extends AbstractResource {
    private static WeakReference<OrderMateMenu> menuRef = new WeakReference<Object>(null);
    private static List<Object> menuCacheKey = new ArrayList<Object>();
    private static Map<String, OrderMateSale> onlineOrderInProcessingCache = new ConcurrentHashMap<String, OrderMateSale>();

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/menuversion")
    public Response getMenuVersion() {
        try {
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            onlineOrderResult.setMenuVersion(Long.valueOf(SystemCurrentInfo.getMenuRevisionCount()));
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getMenuVersion method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/tablesversion")
    public Response getTablesVersion() {
        try {
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            onlineOrderResult.setTablesVersion(Long.valueOf(SystemCurrentInfo.getTablesRevisionCount()));
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getTablesVersion method");
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/examine")
    public Response examineOrder(OrderMateSale saleOrder) {
        OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
        OnlineAccountIntegrator onlineAccInt = new OnlineAccountIntegrator();
        try {
            this.localiseCustomerID(saleOrder);
            OrderMateSale sale = onlineAccInt.examine(saleOrder);
            onlineOrderResult.setSaleOrder(sale);
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (AccountHandlerException ex) {
            String preWorkErrorMessage = ex.getPrework().errorMessage;
            OrderMate.LOG.error("AccountHandlerException within processOrder method - " + preWorkErrorMessage);
            return this.getBadRequestResponse(preWorkErrorMessage);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within processOrder method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    private void localiseCustomerID(OrderMateSale saleOrder) {
        ExportCustomer customer = saleOrder.getCustomer();
        if (customer != null && customer.getID() != null) {
            saleOrder.getCustomer().setID(new LocalIdTranslator().convertToLocalId(customer.getID()));
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/cancel")
    public Response cancelOrder(OrderMateSale saleOrder) {
        try {
            StringBuilder SB = new StringBuilder("** CANCEL ONLINE ORDER **");
            SB.append(" -- ").append("\r\n");
            if (!StringUtils.isEmpty(saleOrder.getExtChannelName())) {
                SB.append("Channel: ").append(saleOrder.getExtChannelName()).append("\r\n");
            }
            SB.append("Source: ").append(saleOrder.getExtSourceName()).append("\r\n");
            SB.append("Order: ").append(saleOrder.getExtOrderID()).append("\r\n");
            if (!StringUtils.isEmpty(saleOrder.getExtHRef())) {
                SB.append("Ref: ").append(saleOrder.getExtHRef()).append("\r\n");
            }
            SB.append("Customer: ");
            ExportCustomer customer = saleOrder.getCustomer();
            if (customer.getName() != null) {
                if (customer.getName() != null) {
                    SB.append(customer.getName().getFirstName());
                }
                if (customer.getName().getLastName() != null) {
                    SB.append(" ").append(saleOrder.getCustomer().getName().getLastName());
                }
                SB.append("\r\n");
            }
            SB.append("Order Date: " + saleOrder.getOrderDate()).append("\r\n");
            SB.append("Total: " + saleOrder.getTotalPrice()).append("\r\n");
            SB.append("\r\n");
            SB.append("Items:").append("\r\n");
            for (LineItem line : saleOrder.getLineItems()) {
                if (line.getSalesCombo() != null) {
                    SB.append(line.getSalesCombo().getQty()).append(" ").append(line.getSalesCombo().getLabel()).append("\r\n");
                    continue;
                }
                SB.append(line.getSalesItem().getQty()).append(" ").append(line.getSalesItem().getLabel()).append("\r\n");
            }
            SB.append("\r\n").append("Please delete these items");
            SimplePrintJob printJob = new SimplePrintJob(SB.toString(), this.resolvePrinterForCancel(saleOrder));
            DocketProcessor.printSimpleDocket(printJob);
            OnlineOrderResult result = new OnlineOrderResult();
            this.setResultCode(result, OnlineOrderResultCode.SUCCESS_CANCEL);
            return this.getResponse(result, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot cancel online order", (Throwable)ex);
            return this.getBadRequestResponse(Boolean.FALSE.toString());
        }
    }

    private List<VirtualPrinter> resolvePrinterForCancel(OrderMateSale saleOrder) {
        List<SalesAccountDocket> dockets;
        Account account;
        ArrayList<VirtualPrinter> vp = new ArrayList<VirtualPrinter>();
        String extId = saleOrder.getExtOrderID();
        if (!StringUtils.isEmpty(extId) && (account = PersistenceManager.getObject(Account.class, Query.select(Account.class).equals(Account.Properties.EXT_ORDER_ID, extId).toString())) != null && (dockets = PersistenceManager.getObjectList(SalesAccountDocket.class, Query.select(SalesAccountDocket.class).equals(SalesAccountDocket.Properties.SALES_ACCOUNT, account).toString())) != null) {
            for (SalesAccountDocket docket : dockets) {
                VirtualPrinter printer = docket.getOriginalPrinter();
                if (printer.isWindowPrinter() || !(printer.getPrintDevice() instanceof PhysicalPrinter)) continue;
                vp.add(printer);
            }
            if (!vp.isEmpty()) {
                return vp;
            }
        }
        for (VirtualPrinter next : VirtualPrinter.getAllPrinters()) {
            PhysicalPrinter printer;
            if (!(next.getPrintDevice() instanceof PhysicalPrinter) || "None".equals((printer = (PhysicalPrinter)next.getPrintDevice()).getPortType()) || "Windows".equals(printer.getPortType())) continue;
            vp.add(next);
            return vp;
        }
        vp.add(VirtualPrinter.getAllPrinters().get(0));
        return vp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/order")
    public Response processOrder(OrderMateSale saleOrder) {
        OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
        OnlineAccountIntegrator onlineAccInt = this.getOnlineAccountIntegrator(saleOrder);
        if (this.isExistingOnlineOrder(saleOrder)) {
            onlineOrderResult.setResultDesc(OnlineOrderResultCode.ERROR_DUPLICATE.toString());
            return this.getResponse(onlineOrderResult, Response.Status.CONFLICT, this.getMediaType());
        }
        try {
            onlineOrderInProcessingCache.put(saleOrder.getExtOrderID(), saleOrder);
            this.localiseCustomerID(saleOrder);
            OnlineOrderPostwork postwork = onlineAccInt.process(saleOrder);
            if (OnlineOrderPostwork.ProcessedStatus.Success.equals((Object)postwork.status)) {
                onlineOrderResult.setOrderId(postwork.prework.account.getID());
                this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            } else if (OnlineOrderPostwork.ProcessedStatus.PendingRetry.equals((Object)postwork.status)) {
                onlineOrderResult.setOrderId(postwork.prework.account.getID());
                this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS_TABLE_LOCKED);
            } else {
                if (OnlineOrderPostwork.ProcessedStatus.Spam.equals((Object)postwork.status)) {
                    if (postwork.prework.account != null) {
                        onlineOrderResult.setOrderId(postwork.prework.account.getID());
                    }
                    onlineOrderResult.setResultDesc(OnlineOrderResultCode.ERROR_DUPLICATE.toString());
                    Response response = this.getResponse(onlineOrderResult, Response.Status.CONFLICT, this.getMediaType());
                    return response;
                }
                Response response = this.handleFailedProcessedOrder(postwork.prework);
                return response;
            }
            this.logResult(onlineOrderResult, saleOrder);
            this.saveLastOrderTime(saleOrder.getExtSourceName());
            Response response = this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
            return response;
        }
        catch (AccountHandlerException ex) {
            Response response = this.handleExceptionInProcessOrder(ex);
            return response;
        }
        catch (IllegalStateException ex) {
            OrderMate.LOG.error("Error within processOrder method", (Throwable)ex);
            Response response = this.getBadRequestResponse(ex.getMessage());
            return response;
        }
        catch (TableBusyException ex) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)ex.getMessage()).build();
            return response;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within processOrder method", (Throwable)ex);
            Response response = this.getInternalServerErrorResponse(ex.getMessage());
            return response;
        }
        finally {
            onlineOrderInProcessingCache.remove(saleOrder.getExtOrderID());
        }
    }

    private boolean isExistingOnlineOrder(OrderMateSale saleOrder) {
        return saleOrder.getExtOrderID() != null && onlineOrderInProcessingCache.containsKey(saleOrder.getExtOrderID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/update")
    public Response updateOrder(OrderMateSale saleOrder) {
        OrderMate.LOG.info("Received update to order " + saleOrder.getExtOrderID() + " for " + saleOrder.getID());
        OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
        OnlineAccountIntegrator onlineAccInt = new OnlineAccountIntegrator();
        Account existing = AccountQueries.getOnlineOrderAccountForThirdParty(saleOrder);
        if (existing == null) {
            ObjectQuery query = Query.select(Account.class).equals(Account.Properties.EXT_ORDER_ID, saleOrder.getExtOrderID()).equals(Account.Properties.SOURCE, saleOrder.getExtSourceName()).orderBy(Account.Properties.ID);
            existing = PersistenceManager.getObject(Account.class, query.toString());
        }
        if (existing == null) {
            return this.getResponse(this.getBadResult(403, "Cannot update, doesn't exist"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        if (!existing.isOpen()) {
            return this.getResponse(this.getBadResult(403, "Cannot update, account is closed"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        if (!existing.lock(User.getSystemUser())) {
            return this.getResponse(this.getBadResult(403, "Cannot update, account is locked by another user"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        try {
            OnlineOrderPrework prework = new OnlineOrderPrework(saleOrder, null, null, true, true);
            Account incoming = onlineAccInt.scanAhead(prework);
            boolean save = false;
            for (FinanceTransaction response : incoming.getFinanceTransactions()) {
                if (response.getTransactionReference() == null) continue;
                FinanceTransaction match = null;
                for (FinanceTransaction nextExisting : existing.getFinanceTransactions()) {
                    if (!nextExisting.getTransactionReference().equals(nextExisting.getTransactionReference())) continue;
                    match = nextExisting;
                    break;
                }
                if (match != null) continue;
                save = true;
                existing.addFinanceTransaction(match);
            }
            List<SalesLineItem> existingItems = existing.getItems();
            for (SalesLineItem line : incoming.getItems()) {
                SalesLineItem match = null;
                for (SalesLineItem exLine : existingItems) {
                    if (!line.isEquivalentTo(exLine)) continue;
                    match = line;
                }
                if (match != null) {
                    existingItems.remove(match);
                    continue;
                }
                save = true;
                existing.addOrderedItemToAccount(line);
            }
            if (save) {
                SimpleSaveAccount simpleSaveAccount = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
                simpleSaveAccount.saveAccount(existing, new EventContext(User.getSystemUser()));
                simpleSaveAccount.printPrep(existing);
            }
            Response response = this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
            existing.unlock();
            return response;
        }
        catch (Exception ex) {
            try {
                try {
                    OrderMate.LOG.error("Problem updating account from online", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    existing.unlock();
                }
                return this.getResponse(this.getBadResult(500, "Error while updating order"), Response.Status.INTERNAL_SERVER_ERROR, this.getMediaType());
            }
            catch (AccountHandlerException ex2) {
                String preWorkErrorMessage = ex2.getPrework().errorMessage;
                OrderMate.LOG.error("AccountHandlerException within processOrder method - " + preWorkErrorMessage);
                return this.getBadRequestResponse(preWorkErrorMessage);
            }
            catch (Exception ex3) {
                OrderMate.LOG.error("Error within processOrder method", (Throwable)ex3);
                return this.getInternalServerErrorResponse(ex3.getMessage());
            }
        }
    }

    protected OnlineAccountIntegrator getOnlineAccountIntegrator(OrderMateSale saleOrder) {
        OnlineAccountIntegrator onlineAccInt = null;
        OnlineOrderAccountType accType = OnlineOrderAccountType.getOnlineOrderAccountType(saleOrder.getAccountType());
        onlineAccInt = OnlineOrderAccountType.KioskTable.equals((Object)accType) || OnlineOrderAccountType.OnlineTable.equals((Object)accType) ? new OnlineTableAccountIntegrator() : new OnlineAccountIntegrator();
        return onlineAccInt;
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/prepare_payment")
    public Response preparePayment(OrderMateSale saleOrder) {
        OrderMate.LOG.info("Receiving payment lock request");
        Account existing = this.getAccountById(saleOrder.getID(), saleOrder.getExtOrderID(), saleOrder.getExtSourceName());
        if (existing == null) {
            OrderMate.LOG.warn("Cannot prepare for payment, doesn't exist");
            return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, doesn't exist"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        if (!existing.isOpen()) {
            OrderMate.LOG.warn("Cannot prepare for payment, account is closed");
            return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, account is closed"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        if (saleOrder.getPayments().isEmpty()) {
            OrderMate.LOG.warn("Cannot prepare for payment, no payments given");
            return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, no payment given"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        OnlinePrePayment payment = saleOrder.getPayments().get(0);
        Price amount = new Price(payment.getAmount(), 0.01);
        Price due = existing.getDue();
        if (due.lessThan(amount)) {
            OrderMate.LOG.warn("Cannot prepare for payment, overpay not allowed:" + amount + " due:" + due);
            return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, overpay not allowed:" + amount + " due:" + due), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        if (existing.isLocked()) {
            if (!existing.isLocked(User.getSystemUser())) {
                OrderMate.LOG.warn("Cannot prepare for payment, account is locked by another user");
                return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, account is locked by another user"), Response.Status.BAD_REQUEST, this.getMediaType());
            }
        } else if (!existing.lock(User.getSystemUser())) {
            OrderMate.LOG.warn("Cannot prepare for payment, can't lock");
            return this.getResponse(this.getBadResult(403, "Cannot prepare for payment, can't lock"), Response.Status.BAD_REQUEST, this.getMediaType());
        }
        OnlineOrderResult result = new OnlineOrderResult();
        result.setResultCode(BigInteger.valueOf(200L));
        result.setResultDesc("Account " + existing.getID() + " locked, ready for payment");
        OrderMate.LOG.info("Payment lock request succeeded for " + existing.getID());
        return this.getResponse(result, Response.Status.OK, this.getMediaType());
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/cancel_payment")
    public Response cancelPayment(OrderMateSale saleOrder) {
        OrderMate.LOG.info("Receiving payment cancellation");
        Account existing = this.getAccountById(saleOrder.getID(), saleOrder.getExtOrderID(), saleOrder.getExtSourceName());
        try {
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            onlineOrderResult.setResultCode(BigInteger.valueOf(200L));
            if (existing == null) {
                onlineOrderResult.setResultDesc("Payment request cancelled - account doesn't exist anyway");
            } else if (!existing.isOpen()) {
                onlineOrderResult.setResultDesc("Payment request cancelled - account is closed");
            } else if (!existing.isLocked(User.getSystemUser()) && !existing.lock(User.getSystemUser())) {
                onlineOrderResult.setResultDesc("Payment request cancelled - account isn't locked");
            } else {
                OrderMate.LOG.info("Cancelling payment request");
                onlineOrderResult.setResultDesc("Payment request cancelled");
                existing.unlock();
            }
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error cancel payment method", (Throwable)ex);
            return this.getResponse(this.getBadResult(501, ex.getMessage()), Response.Status.INTERNAL_SERVER_ERROR, this.getMediaType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/payment")
    public Response updatePayment(OrderMateSale saleOrder) {
        OrderMate.LOG.info("Receiving payment request");
        Account existing = this.getAccountById(saleOrder.getID(), saleOrder.getExtOrderID(), saleOrder.getExtSourceName());
        try {
            if (existing == null) {
                return this.getResponse(this.getBadResult(403, "Cannot update, account doesn't exist"));
            }
            if (saleOrder.getPayments().isEmpty()) {
                OrderMate.LOG.info("Cancelling payment request");
                OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
                onlineOrderResult.setResultCode(BigInteger.valueOf(200L));
                onlineOrderResult.setResultDesc("Payment request cancelled");
                existing.unlock();
                return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
            }
            OnlinePrePayment payment = saleOrder.getPayments().get(0);
            if (!existing.isOpen()) {
                FinanceTransaction txn;
                Iterator<FinanceTransaction> iterator = existing.getFinanceTransactions().iterator();
                do {
                    if (!iterator.hasNext()) return this.getResponse(this.getBadResult(403, "Cannot update, account is closed"), Response.Status.BAD_REQUEST, this.getMediaType());
                    txn = iterator.next();
                } while (payment.getReference() == null || !payment.getReference().equals(txn.getTransactionReference()));
                OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
                onlineOrderResult.setResultCode(BigInteger.valueOf(200L));
                onlineOrderResult.setResultDesc("Payment already exists");
                return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
            }
            if (!existing.isLocked(User.getSystemUser()) && !existing.lock(User.getSystemUser())) {
                return this.getResponse(this.getBadResult(403, "Cannot update, account is locked by another user"), Response.Status.BAD_REQUEST, this.getMediaType());
            }
            try {
                OrderMate.LOG.info("Processing payment request");
                OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
                onlineOrderResult.setResultCode(BigInteger.valueOf(200L));
                onlineOrderResult.setResultDesc("Payment request fulfilled");
                OnlineAccountIntegrator onlineAccInt = new OnlineAccountIntegrator();
                saleOrder.setTotalPrice(BigDecimal.ZERO);
                saleOrder.setIsPaid(Boolean.TRUE);
                OnlineOrderPrework prework = new OnlineOrderPrework(saleOrder, null, null, true, true);
                if (onlineAccInt.processPayment(prework, existing)) {
                    Response response = this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
                    return response;
                }
                Response response = this.getResponse(this.getBadResult(403, "Cannot add payment, refused"), Response.Status.BAD_REQUEST, this.getMediaType());
                return response;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem updating account payment from online", (Throwable)ex);
                return this.getResponse("Error while paying order", Response.Status.INTERNAL_SERVER_ERROR, this.getMediaType());
            }
            finally {
                existing.unlock();
            }
        }
        catch (AccountHandlerException ex2) {
            String preWorkErrorMessage = ex2.getPrework().errorMessage;
            OrderMate.LOG.error("AccountHandlerException within payment method - " + preWorkErrorMessage);
            return this.getBadRequestResponse(preWorkErrorMessage);
        }
        catch (Exception ex3) {
            OrderMate.LOG.error("Error within payment method", (Throwable)ex3);
            return this.getInternalServerErrorResponse(ex3.getMessage());
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/checkin")
    public Response checkin(OrderMateSale saleOrder) {
        OrderMate.LOG.info("Receiving Checkin request");
        String specifiedTables = saleOrder.getExtWebTableName();
        List<String> list = StringUtils.splitToList(specifiedTables, ",");
        if (list.isEmpty()) {
            return this.getResponse(this.getBadResult(406, "Cannot checkin, no tables"));
        }
        String sectionName = null;
        TableGroup section = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        for (String nextTable : list) {
            Pair<String, String> sectionAndTable = StringUtils.splitToPair(nextTable, "-");
            if (sectionName == null) {
                sectionName = (String)sectionAndTable.key;
                section = PersistenceManager.getObject(TableGroup.class, Query.select(TableGroup.class).equals(TableGroup.Properties.NAME, sectionName).toString());
                if (section == null) {
                    return this.getResponse(this.getBadResult(406, "Cannot checkin, table group " + section + " doesn't exist"));
                }
                tableNames.add((String)sectionAndTable.value);
                continue;
            }
            if (sectionName.equals(sectionAndTable.key)) {
                tableNames.add((String)sectionAndTable.value);
                continue;
            }
            OrderMate.LOG.warn("Will not include table for checkin, different section " + (String)sectionAndTable.key + " is not " + sectionName);
        }
        List<PhysicalTable> phTables = PhysicalTableQueries.getPhysicalTables(tableNames, section);
        if (phTables.isEmpty()) {
            return this.getResponse(this.getBadResult(406, "Cannot checkin, no available tables for " + specifiedTables));
        }
        LogicalTable table = phTables.get(0).getLogicalTable();
        if (!table.canOrderTo()) {
            return this.getResponse(this.getBadResult(406, "Cannot checkin, table cannot be ordered to."));
        }
        OnlineOrderResult result = new OnlineOrderResult();
        boolean openTableOnCheckin = false;
        if (openTableOnCheckin) {
            EventContext context = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
            BigInteger patrons = saleOrder.getPatrons();
            if (patrons == null) {
                patrons = BigInteger.ONE;
            }
            TableAccount account = new TableAccount(context.getUser(), table, patrons.intValue(), context.getTerminal());
            account.setSource(saleOrder.getExtSourceName());
            account.setExtOrigin(saleOrder.getExtChannelName());
            account.setExtHRef(saleOrder.getExtHRef());
            if (saleOrder.getCustomer() != null) {
                SalesXMLIntegrationContext xmlContext = new SalesXMLIntegrationContext(null, context, true);
                CustomerHandler handler = new CustomerHandler(xmlContext);
                try {
                    Customer customer = handler.importElement(saleOrder.getCustomer(), (PersistentObject)null);
                    if (customer != null) {
                        account.setCustomer(customer, context);
                    }
                }
                catch (UnmarshalException ex) {
                    OrderMate.LOG.warn("Cannot import customer for checkin", (Throwable)ex);
                }
            }
            OrderMate.LOG.info("Opening table for checkin");
            account.lock(context.getUser());
            account.save();
            account.unlock();
            result.setOrderId(account.getID());
        }
        result.setResultCode(BigInteger.valueOf(200L));
        return this.getResponse(result, Response.Status.OK, this.getMediaType());
    }

    private Account getAccountById(Long posId, String extId, String extSource) {
        Account existing = null;
        if (posId != null) {
            existing = PersistenceManager.getByID(posId, Account.class);
        }
        if (existing == null && extId != null && (existing = AccountQueries.getOnlineOrderAccountForThirdParty(extId, extSource)) == null) {
            ObjectQuery query = Query.select(Account.class).equals(Account.Properties.ID, extId).equals(Account.Properties.SOURCE, extSource).orderBy(Account.Properties.ID);
            existing = PersistenceManager.getObject(Account.class, query.toString());
        }
        return existing;
    }

    private OnlineOrderResult getBadResult(int status, String reason) {
        OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
        onlineOrderResult.setResultCode(BigInteger.valueOf(status));
        onlineOrderResult.setResultDesc(reason);
        return onlineOrderResult;
    }

    private Response handleExceptionInProcessOrder(AccountHandlerException ex) {
        String preWorkErrorMessage = ex.getPrework().errorMessage;
        OrderMate.LOG.error("AccountHandlerException within processOrder method - " + preWorkErrorMessage, (Throwable)ex);
        String exceptionMessage = ex.getMessage();
        if (ex.getPrework().locked) {
            return this.handleFailedProcessedOrder(ex.getPrework());
        }
        if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
            return this.getBadRequestResponse(exceptionMessage);
        }
        return this.getBadRequestResponse(preWorkErrorMessage);
    }

    private Response handleFailedProcessedOrder(OnlineOrderPrework prework) {
        return this.getBadRequestResponse(prework.errorMessage);
    }

    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/orderstatus")
    public Response getOrderStatus(@QueryParam(value="orderid") Long orderId, @QueryParam(value="vendorid") String vendor) {
        try {
            OnlineOrderResult result = new OnlineOrderResult();
            OnlineOrderStatusList list = new OnlineOrderStatusList();
            AccountStatusHelper helper = new AccountStatusHelper();
            OnlineOrderStatusEntry entry = helper.getStatus(orderId, vendor);
            list.getOnlineOrderStatus().add(entry);
            result.setStatusList(list);
            this.setResultCode(result, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(result, Response.Status.OK, this.getMediaType());
        }
        catch (IllegalArgumentException ex) {
            OrderMate.LOG.error("Couldn't determine account status: ", (Throwable)ex);
            return this.getBadRequestResponse(ex.getMessage());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't determine account status: ", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/orderdetails")
    public Response getOrderDetails(@QueryParam(value="orderid") Long orderId, @QueryParam(value="vendorid") String vendor, @QueryParam(value="options") String options) {
        SalesXMLIntegrationContext context = new SalesXMLIntegrationContext(OnlineIntegrationConfig.getConfigFor(vendor).getInventoryProfile(), new EventContext(User.getSystemUser()), false);
        if (orderId == null || vendor == null) {
            OrderMate.LOG.warn("Cannot get account details for null id or vendor");
            return this.getBadRequestResponse("Cannot get account details for null id or vendor!");
        }
        Account account = PersistenceManager.getByID(orderId, Account.class);
        if (account != null && this.isValidAccountType(account.getType())) {
            ObjectFactory factory = new ObjectFactory();
            AccountHandler accountHandler = (AccountHandler)context.getHandler(Account.class, OrderMateSale.class);
            accountHandler.setExportOptions(options);
            OrderMateSale sale = accountHandler.exportDomainObject(account, factory);
            return this.getResponse(sale, Response.Status.OK, this.getMediaType());
        }
        return this.getBadRequestResponse("No account exists for this ID!");
    }

    private boolean isValidAccountType(String accountType) {
        return BarTabAccount.TYPE.getType().equals(accountType) || AccountType.onlineDeliveryType.getType().equals(accountType) || AccountType.deliveryType.getType().equals(accountType);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/menu")
    public Response getMenu(@QueryParam(value="profileid") Long profileId, @QueryParam(value="pricelevelid") Long priceLevelId, @QueryParam(value="includeItemUpTo") String includeUpTo, @QueryParam(value="source") String source, @QueryParam(value="priceLevelPolicy") String priceLevelPolicyName) {
        try {
            ExperimentalFeature cacheMenu;
            boolean useCache;
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            InventoryProfile profile = PersistenceManager.getObject(InventoryProfile.class, Query.select(InventoryProfile.class).equals(InventoryProfile.Properties.ID, profileId).active(InventoryProfile.class).toString(), null);
            ordermate.database.inventory.PriceLevel priceLevel = PersistenceManager.getObject(ordermate.database.inventory.PriceLevel.class, Query.select(ordermate.database.inventory.PriceLevel.class).equals(ordermate.database.inventory.PriceLevel.Properties.ID, priceLevelId).active(ordermate.database.inventory.PriceLevel.class).toString(), null);
            if (profile == null) {
                return this.getBadRequestResponse(OnlineOrderResultCode.INVALID_PROFILE_PARAM.toString());
            }
            if (priceLevel == null) {
                return this.getBadRequestResponse(OnlineOrderResultCode.INVALID_PRICE_LEVEL_PARAM.toString());
            }
            OrderMateMenu menu = new OrderMateMenu();
            InventoryProfilerExporter exporter = new InventoryProfilerExporter((InventoryProfile)PersistenceManager.reacquire(profile), Collections.singletonList(priceLevel), source);
            if (includeUpTo != null) {
                if ("INACTIVE".equals(includeUpTo)) {
                    exporter.setIncludeItemsUpTo(SystemState.INACTIVE_STATE);
                } else if ("DELETED".equals(includeUpTo)) {
                    exporter.setIncludeItemsUpTo(SystemState.DELETED_STATE);
                }
            } else {
                includeUpTo = "ACTIVE";
            }
            if (priceLevelPolicyName != null) {
                try {
                    exporter.setPriceLevelPolicy(InventoryProfilerExporter.PriceLevelPolicy.valueOf(priceLevelPolicyName));
                }
                catch (IllegalArgumentException ex) {
                    OrderMate.LOG.log(Level.WARN, "Invalid price level policy " + priceLevelPolicyName, (Throwable)ex);
                }
            } else {
                priceLevelPolicyName = "";
            }
            boolean bl = useCache = (cacheMenu = ExperimentalFeature.find("Cache Online Menu")) != null && cacheMenu.getBooleanValue(Boolean.FALSE) != false;
            if (!useCache) {
                exporter.exportProfile(profile, menu);
                onlineOrderResult.setMenu(menu);
            } else {
                if (!(menuRef.get() == null || menuCacheKey.size() == 5 && menuCacheKey.get(0).equals(profileId) && menuCacheKey.get(1).equals(priceLevelId) && menuCacheKey.get(2).equals(includeUpTo) && menuCacheKey.get(3).equals(priceLevelPolicyName) && menuCacheKey.get(4).equals(SystemCurrentInfo.getMenuRevisionCount()))) {
                    menuRef = new WeakReference<Object>(null);
                    menuCacheKey.clear();
                    menuCacheKey.add(profileId);
                    menuCacheKey.add(priceLevelId);
                    menuCacheKey.add(includeUpTo);
                    menuCacheKey.add(priceLevelPolicyName);
                    menuCacheKey.add(SystemCurrentInfo.getMenuRevisionCount());
                }
                if (menuRef.get() == null) {
                    exporter.exportProfile(profile, menu);
                    menuRef = new WeakReference<OrderMateMenu>(menu);
                }
                onlineOrderResult.setMenu((OrderMateMenu)menuRef.get());
            }
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            this.saveLastMenuImportTime(source);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getMenu method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    private void saveLastMenuImportTime(final String source) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigWithoutCache(source);
                if (config != null) {
                    config.setLastMenuImportTime(new Date());
                    config.save();
                }
            }
        }).start();
    }

    private void saveLastOrderTime(final String source) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigWithoutCache(source);
                if (config != null) {
                    config.setLastOrderTime(new Date());
                    config.save();
                }
            }
        }).start();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/allprofiles")
    public Response getAllProfiles() {
        try {
            Vector<InventoryProfile> profilesList = InventoryProfile.getAllProfiles();
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            ProfileList exportList = new ProfileList();
            for (InventoryProfile profile : profilesList) {
                Profile exportProfile = new Profile();
                exportProfile.setId(profile.getID());
                exportProfile.setName(profile.getLabel());
                exportProfile.setMasterId(profile.getMasterId());
                exportList.getProfiles().add(exportProfile);
            }
            onlineOrderResult.setProfileList(exportList);
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getAllProfiles method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/allpricelevels")
    public Response getAllPriceLevels() {
        try {
            List<ordermate.database.inventory.PriceLevel> profilesList = ordermate.database.inventory.PriceLevel.getAllPriceLevels();
            OnlineOrderResult onlineOrderResult = new OnlineOrderResult();
            PriceLevelList exportList = new PriceLevelList();
            for (ordermate.database.inventory.PriceLevel priceLevel : profilesList) {
                PriceLevel exportProfile = new PriceLevel();
                exportProfile.setId(priceLevel.getID());
                exportProfile.setName(priceLevel.getLabel());
                exportProfile.setMasterId(priceLevel.getMasterId());
                exportList.getPriceLevels().add(exportProfile);
            }
            onlineOrderResult.setPriceLevelList(exportList);
            this.setResultCode(onlineOrderResult, OnlineOrderResultCode.SUCCESS);
            return this.getResponse(onlineOrderResult, Response.Status.OK, this.getMediaType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getAllPriceLevels method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Path(value="accountbycard")
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getAccountIdForCustomerCard(@QueryParam(value="cardid") String cardId, @QueryParam(value="vendorid") String vendor) {
        CustomerCardHelper helper = new CustomerCardHelper();
        if (!helper.isValidCardId(cardId)) {
            return this.getBadRequestResponse("The card " + cardId + " is not a valid card: Perhaps missing a % or ;?");
        }
        CustomerCard card = helper.getCardByCardId(cardId);
        if (card == null) {
            return this.getBadRequestResponse("The card " + cardId + " is not a known card.");
        }
        BarTabAccount tab = helper.getBarTabForCard(card);
        if (tab == null) {
            return this.getBadRequestResponse("The card " + cardId + " is not linked to an open account.");
        }
        return this.getOrderDetails(tab.getID(), vendor, null);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/menumapping")
    public Response getMenuMapping() {
        try {
            MenuMappingData menuMappingData = new MenuMappingData();
            menuMappingData.setIdStrategy(OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy()) ? IdStrategy.MASTER : IdStrategy.POS);
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryProfile.getAllProfiles(), MenuMappingType.PROFILE));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(ordermate.database.inventory.PriceLevel.getAllPriceLevels(), MenuMappingType.PRICE_LEVEL));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryCategory.getAllCategories(), MenuMappingType.CATEGORY));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryGroupQueries.getAllGroups(), MenuMappingType.SECTION));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryItemQueries.getAllActiveInventoryItems(), MenuMappingType.ITEM));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryItemUnit.getPubliclyAccessibleInventoryItemUnits(), MenuMappingType.ITEM_UNIT));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(PersistenceManager.getObjectList(InventoryAdd.class, InventoryAddQueries.getAllActiveAdds().toString(), null), MenuMappingType.PLUS));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(PersistenceManager.getObjectList(InventoryRemove.class, InventoryRemoveQueries.getAllActiveRemoves().toString(), null), MenuMappingType.REMOVE));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(PersistenceManager.getObjectList(InventoryOption.class, InventoryOptionQueries.getAllActiveOptions().toString(), null), MenuMappingType.OPTION));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryCombo.getAllActiveCombos(), MenuMappingType.COMBO));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(PersistenceManager.getObjectList(InventoryComboGroup.class, InventoryComboGroupQueries.getActiveComboGroups().toString(), null), MenuMappingType.COMBO_GROUP));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryAddGroup.getAllAddGroups(), MenuMappingType.PLUS_GROUP));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryOptionGroup.getOptionGroups(), MenuMappingType.OPTION_GROUP));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryItemSize.getAllSizes(), MenuMappingType.SIZE));
            menuMappingData.getMenuMappings().add(this.getMenuMapping(InventoryItemPortion.getAllPortions(), MenuMappingType.PORTION));
            return this.getOKResponse(menuMappingData);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getMenuMapping method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    private <T extends ExportableObject> MenuMapping getMenuMapping(List<T> objectList, MenuMappingType type) {
        MenuMapping menuMapping = new MenuMapping();
        menuMapping.setType(type);
        for (ExportableObject object : objectList) {
            IdMapping idMapping = new IdMapping();
            idMapping.setId(object.getID());
            idMapping.setMasterId(object.getMasterId() != null ? object.getMasterId() : 0L);
            menuMapping.getIdMappings().add(idMapping);
        }
        return menuMapping;
    }

    private void setResultCode(OnlineOrderResult result, OnlineOrderResultCode code) {
        result.setResultCode(BigInteger.valueOf(code.getCode()));
        result.setResultDesc(code.toString());
    }

    private void logResult(OnlineOrderResult result, OrderMateSale order) {
        StringBuilder SB = new StringBuilder();
        SB.append("Online Order Processed: ").append(result.getResultCode()).append(" ID: ").append(result.getOrderId()).append(" Desc: ").append(result.getResultDesc()).append(" From ").append(order.getExtSourceName());
        OrderMate.LOG.info(SB.toString());
    }
}

