/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import ordermate.integration.jaxb.integratedpayment.IntegratedPaymentResult;
import ordermate.webresource.payments.IntegratedPaymentResultCode;
import ordermate.webresource.payments.gateway.DefaultPaymentProcessFactory;
import ordermate.webresource.payments.gateway.PaymentGateway;

@Path(value="")
public class IntegratedPaymentResource {
    private PaymentGateway gateway;

    public IntegratedPaymentResource() {
        DefaultPaymentProcessFactory.init();
        this.gateway = PaymentGateway.getInstance();
        if (this.gateway == null) {
            this.gateway = PaymentGateway.init(Terminal.getServerMateTerminal(), User.getSystemUser());
        }
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/kickcashdrawer")
    public IntegratedPaymentResult kickCashdrawer(@QueryParam(value="cashdrawerName") String cashdrawerName, @QueryParam(value="integratorName") String integratorName) {
        if (StringUtils.isEmpty(cashdrawerName)) {
            return IntegratedPaymentResultCode.NO_CASHDRAWER.getIntegratedPaymentResult();
        }
        if (StringUtils.isEmpty(integratorName)) {
            return IntegratedPaymentResultCode.UNSUPPORTED_OPERATION.getIntegratedPaymentResult();
        }
        CashDrawer cashdrawer = PersistenceManager.getObject(CashDrawer.class, Query.select(CashDrawer.class).active(CashDrawer.class).equals(CashDrawer.Properties.LABEL, cashdrawerName).toString());
        if (cashdrawer == null) {
            return IntegratedPaymentResultCode.UNKNOWN_CASHDRAWER.getIntegratedPaymentResult();
        }
        User user = User.getSystemUser();
        Terminal terminal = Terminal.getLocalHost();
        if (user == null || terminal == null) {
            OrderMate.LOG.error("Cannot find terminal or user to open cashdrawer " + user + " " + terminal);
        }
        try {
            cashdrawer.open(user);
            TerminalEventLog.logNoSale(user, terminal, cashdrawer, " by external integrator " + integratorName);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error opening cashdrawer " + cashdrawer.getLabel(), (Throwable)e);
            return IntegratedPaymentResultCode.FAILED.getIntegratedPaymentResult();
        }
        return IntegratedPaymentResultCode.SUCCESS.getIntegratedPaymentResult();
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/makepaymenttransaction")
    public IntegratedPaymentResult makePaymentTransaction(@QueryParam(value="cashdrawerid") Long cashdrawerId, @QueryParam(value="accountid") Long accountId, @QueryParam(value="amount") Double amount) {
        try {
            Account salesAccount;
            if (cashdrawerId == null) {
                return IntegratedPaymentResultCode.NO_CASHDRAWER.getIntegratedPaymentResult();
            }
            if (accountId == null) {
                return IntegratedPaymentResultCode.NO_ACCOUNT.getIntegratedPaymentResult();
            }
            CashDrawer cashDrawer = PersistenceManager.getByID(cashdrawerId, CashDrawer.class);
            IntegratedPaymentResult result = this.preliminaryCheck(cashDrawer, salesAccount = PersistenceManager.getByID(accountId, Account.class));
            if (result == null) {
                Price price = new Price(amount, 0.01);
                long requestToken = this.gateway.requestPayment(salesAccount, cashDrawer, price);
                result = IntegratedPaymentResultCode.SUCCESS.getIntegratedPaymentResult();
                result.setPaymentToken(requestToken);
            }
            return result;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within makePaymentTransaction method", (Throwable)ex);
            return IntegratedPaymentResultCode.UNKNOWN_ERROR.getIntegratedPaymentResult();
        }
    }

    private IntegratedPaymentResult preliminaryCheck(CashDrawer cashDrawer, Account salesAccount) {
        IntegratedPaymentResult result = null;
        if (cashDrawer == null) {
            result = IntegratedPaymentResultCode.UNKNOWN_CASHDRAWER.getIntegratedPaymentResult();
        } else if (salesAccount == null) {
            result = IntegratedPaymentResultCode.UNKNOWN_ACCOUNT.getIntegratedPaymentResult();
        } else if (!salesAccount.isOpen()) {
            result = IntegratedPaymentResultCode.ALREADY_CLOSED.getIntegratedPaymentResult();
        } else if (salesAccount.getDue().equals(Price.ZERO_DOLLAR)) {
            result = IntegratedPaymentResultCode.ZERO_DOLLAR.getIntegratedPaymentResult();
        }
        return result;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/querytransactionstatus")
    public IntegratedPaymentResult queryTransactionStatus(@QueryParam(value="token") long transactionId) {
        IntegratedPaymentResult result = null;
        try {
            EftposStatus status = this.gateway.getStatus(transactionId);
            OrderMate.LOG.info("Status " + status);
            if (EftposStatus.APPROVED.equals(status)) {
                OrderMate.LOG.info("Marking Integrated Payment result as success:" + transactionId);
                result = IntegratedPaymentResultCode.SUCCESS.getIntegratedPaymentResult();
            } else if (EftposStatus.PENDING.equals(status)) {
                OrderMate.LOG.info("Marking Integrated Payment result as in progress:" + transactionId);
                result = IntegratedPaymentResultCode.IN_PROGRESS.getIntegratedPaymentResult();
            } else {
                OrderMate.LOG.info("Marking Integrated Payment result as failed:" + transactionId);
                result = IntegratedPaymentResultCode.FAILED.getIntegratedPaymentResult();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within queryTransactionStatus method", (Throwable)ex);
            result = IntegratedPaymentResultCode.UNKNOWN_ERROR.getIntegratedPaymentResult();
        }
        result.setPaymentToken(transactionId);
        return result;
    }

    @PUT
    @Produces(value={"application/xml"})
    @Path(value="/canceltransaction")
    public IntegratedPaymentResult cancelTransaction(@QueryParam(value="token") Long transactionId) {
        OrderMate.LOG.info("IntegratedPaymentResource:cancelTransaction() is called transactionId = " + transactionId);
        IntegratedPaymentResult result = null;
        try {
            result = this.gateway.requestCancel(transactionId) ? IntegratedPaymentResultCode.SUCCESS.getIntegratedPaymentResult() : IntegratedPaymentResultCode.FAILED.getIntegratedPaymentResult();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within cancelTransaction method", (Throwable)ex);
            result = IntegratedPaymentResultCode.UNKNOWN_ERROR.getIntegratedPaymentResult();
        }
        result.setPaymentToken(transactionId);
        return result;
    }
}

