/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments;

import ordermate.integration.jaxb.integratedpayment.IntegratedPaymentResult;

public enum IntegratedPaymentResultCode {
    SUCCESS(0, "Successful"),
    FAILED(1, "Failed"),
    NO_CASHDRAWER(100, "Cashdrawer must be given"),
    UNKNOWN_CASHDRAWER(101, "Unknown Cashdrawer given"),
    NO_ACCOUNT(110, "No account was given to pay off"),
    UNKNOWN_ACCOUNT(111, "Unknown account given"),
    ZERO_DOLLAR(112, "Account has nothing to pay off"),
    ALREADY_CLOSED(113, "Account has already been closed off"),
    NO_AMOUNT(114, "No amount has been specified"),
    IN_PROGRESS(201, "Transaction is still in progress"),
    UNKNOWN_ERROR(666, "Unknown error"),
    UNSUPPORTED_OPERATION(900, "The requested operation is unsupported");

    private int code;
    private String description;

    private IntegratedPaymentResultCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.description;
    }

    public IntegratedPaymentResult getIntegratedPaymentResult() {
        IntegratedPaymentResult result = new IntegratedPaymentResult();
        result.setResult(this.code);
        result.setResultDesc(this.description);
        return result;
    }
}

