/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments.gateway;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.signals.Signal;
import ordermate.signals.ThreadLocalSignal;
import ordermate.webresource.payments.gateway.PaymentProcess;
import ordermate.webresource.payments.gateway.PaymentRequest;

public abstract class AbstractPaymentProcess
implements PaymentProcess {
    private final ThreadLocalSignal doneSignal = new ThreadLocalSignal(new Class[]{PaymentProcess.class});
    private PaymentRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPayment(PaymentRequest myRequest) {
        this.request = myRequest;
        boolean lockable = this.request.getPayable() instanceof Lockable;
        boolean iLockedIt = true;
        try {
            FinanceTransaction txn;
            Lockable locky;
            if (lockable && !(locky = (Lockable)((Object)this.request.getPayable())).isLocked(this.request.getUser())) {
                iLockedIt = false;
                if (!locky.lock(this.request.getUser())) {
                    this.request.requestProcessed(EftposStatus.ERROR, "Account cannot be locked.");
                    this.fireDone();
                    return;
                }
            }
            if ((txn = this.doForwardPayment(this.request)) != null && EftposStatus.APPROVED.equals(this.request.getStatus()) && ((EftposTransaction)txn).getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.PROCESSED)) {
                Payable payable = this.request.getPayable();
                EventContext context = new EventContext(myRequest.getTerminal(), myRequest.getUser());
                if (payable != null) {
                    if (payable instanceof PriceAdjustable) {
                        Price surchargeAmt = txn.getSurcharge();
                        if (FinanceSurchargeCalculator.shouldApplyPreSurcharge(txn)) {
                            surchargeAmt = myRequest.getSurcharge();
                        }
                        FinanceSurchargeCalculator.applySurcharge(payable, txn.getSubType(), surchargeAmt, context);
                    }
                    if (!payable.getFinanceTransactions().contains(txn)) {
                        payable.addFinanceTransaction(txn);
                    }
                    payable.save();
                }
            }
        }
        catch (Exception ex) {
            this.request.requestProcessed(EftposStatus.ERROR, "Payment cannot be handled");
            OrderMate.LOG.error("Cannot handle payment:", (Throwable)ex);
        }
        finally {
            if (lockable) {
                ((Lockable)((Object)myRequest.getPayable())).unlock();
            }
        }
        this.fireDone();
    }

    protected abstract FinanceTransaction doForwardPayment(PaymentRequest var1);

    @Override
    public Signal<PaymentProcess, ?, ?, ?, ?> getPaymentProcessedSignal() {
        return this.doneSignal;
    }

    private void fireDone() {
        this.doneSignal.emit(this);
    }

    @Override
    public PaymentRequest getProcessingRequest() {
        return this.request;
    }
}

