/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments.gateway;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import ordermate.webresource.payments.gateway.PaymentRequest;
import ordermate.webresource.payments.gateway.PaymentRequestProcessor;

public class PaymentGateway
implements GatewayNotifier<PaymentRequest> {
    private Gateway<PaymentRequest> gate;
    private long counter = 1L;
    private Map<Long, PaymentRequest> requestMap;
    private Terminal terminal;
    private User user;
    private PaymentRequestProcessor processor;
    private static PaymentGateway instance;

    public static synchronized PaymentGateway getInstance() {
        return instance;
    }

    public static synchronized PaymentGateway init(Terminal serverMateTerminal, User systemUser) {
        if (instance == null) {
            instance = new PaymentGateway(serverMateTerminal, systemUser);
        }
        return instance;
    }

    public PaymentGateway(Terminal yourTerminal, User yourUser) {
        OrderMate.LOG.info("MAKING NEW GATEWAY!");
        this.terminal = yourTerminal;
        this.user = yourUser;
        this.processor = new PaymentRequestProcessor();
        this.requestMap = new ConcurrentHashMap<Long, PaymentRequest>();
        this.gate = new Gateway<PaymentRequest>(this.processor, this);
        this.gate.startService();
    }

    public synchronized long requestPayment(Payable payable, CashDrawer cd, Price amount) {
        this.terminal = (Terminal)PersistenceManager.reacquire(this.terminal);
        PaymentRequest request = new PaymentRequest(this.counter, payable, amount, cd, this.terminal, this.user);
        this.requestMap.put(this.counter, request);
        OrderMate.LOG.info("Adding payment request to gateway :" + this.counter);
        ++this.counter;
        this.gate.putIntoQueue(request);
        return request.getId();
    }

    public synchronized boolean requestCancel(Long id) {
        PaymentRequest request = this.requestMap.get(id);
        if (request != null) {
            return this.processor.cancelPayment(request);
        }
        return false;
    }

    @Override
    public void notifyProcess(PaymentRequest processedValue, boolean processSuccessful) {
        OrderMate.LOG.info("Payment being processed:" + processedValue.getId() + " " + processSuccessful);
    }

    public synchronized EftposStatus getStatus(long tokenId) {
        PaymentRequest request = this.requestMap.get(tokenId);
        if (request != null) {
            return request.getStatus();
        }
        OrderMate.LOG.warn("Cannot find transaction token id in map:" + tokenId);
        return EftposStatus.UNKNOWN;
    }
}

