/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments.gateway;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.users.User;

public class PaymentRequest {
    private final long id;
    private final long timeRequested;
    private final Payable payable;
    private Price surcharge = Price.ZERO_DOLLAR;
    private final Price amount;
    private Price tip = Price.ZERO_DOLLAR;
    private final CashDrawer cashdrawer;
    private final Terminal terminal;
    private final User user;
    private boolean isWeb = false;
    private WebPaymentCustomer webCustomer;
    private EftposStatus status;
    private long timeCompleted;
    private String errorString;

    public PaymentRequest(long yourId, Payable yourPayable, Price amount, CashDrawer cashdrawer, Terminal terminal, User user) {
        this.id = yourId;
        this.payable = yourPayable;
        this.amount = amount;
        this.terminal = terminal;
        this.user = user;
        this.cashdrawer = cashdrawer;
        this.status = EftposStatus.PENDING;
        this.timeRequested = System.currentTimeMillis();
        this.timeCompleted = 0L;
    }

    public PaymentRequest setWebCustomer(WebPaymentCustomer customer) {
        this.webCustomer = customer;
        return this;
    }

    public PaymentRequest setTip(Price tip) {
        this.tip = tip;
        return this;
    }

    public PaymentRequest setWeb(boolean value) {
        this.isWeb = value;
        return this;
    }

    public final Payable getPayable() {
        return this.payable;
    }

    public final Price getAmount() {
        return this.amount == null ? Price.ZERO_DOLLAR : this.amount;
    }

    public Price getTip() {
        return this.tip == null ? Price.ZERO_DOLLAR : this.tip;
    }

    public Price getSurcharge() {
        return this.surcharge;
    }

    public PaymentRequest setSurcharge(Price value) {
        this.surcharge = value == null ? Price.ZERO_DOLLAR : value;
        return this;
    }

    public boolean isWeb() {
        return this.isWeb;
    }

    public final CashDrawer getCashdrawer() {
        return this.cashdrawer;
    }

    public final Terminal getTerminal() {
        return this.terminal;
    }

    public final User getUser() {
        return this.user;
    }

    public final synchronized EftposStatus getStatus() {
        return this.status;
    }

    public final long getId() {
        return this.id;
    }

    public final long getTimeRequested() {
        return this.timeRequested;
    }

    public final synchronized long getTimeCompleted() {
        return this.timeCompleted;
    }

    public final synchronized String getErrorString() {
        return this.errorString;
    }

    public final synchronized void requestProcessed(EftposStatus newStatus, String theErrorString) {
        StringBuilder SB;
        if (this.status == EftposStatus.PENDING) {
            SB = new StringBuilder("Marking transaction status ").append(this.id).append(" to ").append(newStatus);
            if (theErrorString != null) {
                SB.append(" because ").append(theErrorString);
            }
        } else {
            throw new IllegalArgumentException("Cannot set the payment request's status twice");
        }
        OrderMate.LOG.info(SB.toString());
        this.status = newStatus;
        this.timeCompleted = System.currentTimeMillis();
        this.errorString = theErrorString;
    }

    public WebPaymentCustomer getWebPaymentCustomer() {
        return this.webCustomer;
    }
}

