/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments.gateway;

import au.com.ordermate.gateway.GatewayProcessor;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.webresource.payments.gateway.PaymentProcess;
import ordermate.webresource.payments.gateway.PaymentProcessFactory;
import ordermate.webresource.payments.gateway.PaymentRequest;

class PaymentRequestProcessor
implements GatewayProcessor<PaymentRequest> {
    private Map<PaymentRequest, PaymentProcess> processes = new HashMap<PaymentRequest, PaymentProcess>();

    PaymentRequestProcessor() {
    }

    @Override
    public boolean processIncoming(PaymentRequest request) {
        PaymentProcess process = PaymentProcessFactory.getInstance().makePaymentProcess(request);
        if (process == null) {
            return false;
        }
        if (!process.canHandlePaymentRequest(request)) {
            request.requestProcessed(EftposStatus.ERROR, "Cannot handle payment at this time.");
            return false;
        }
        process.getPaymentProcessedSignal().connect(this, "gotPaymentProcessed");
        this.processRequest(process, request);
        return true;
    }

    private void processRequest(final PaymentProcess process, final PaymentRequest request) {
        this.processes.put(request, process);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                process.doPayment(request);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotPaymentProcessed(PaymentProcess process) {
        Map<PaymentRequest, PaymentProcess> map = this.processes;
        synchronized (map) {
            this.processes.remove(process.getProcessingRequest());
            process.getPaymentProcessedSignal().disconnect(this);
        }
        process.getProcessingRequest();
    }

    public boolean cancelPayment(PaymentRequest request) {
        PaymentProcess process = this.processes.get(request);
        if (process != null) {
            process.cancelPayment();
            return true;
        }
        return false;
    }
}

