/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.payments.gateway.eftpos;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.hardware.eftpos.WebPaymentRequest;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.sales.Account;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.gui.SimpleSaveAccount;
import ordermate.integration.eftpos.EftposResult;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.webresource.payments.gateway.AbstractPaymentProcess;
import ordermate.webresource.payments.gateway.PaymentRequest;
import ordermate.webresource.payments.gateway.eftpos.HeadlessPaymentUI;

public class HeadlessEftposPaymentProcess
extends AbstractPaymentProcess {
    private EftposManager manager;
    private EftposToolkit toolkit;

    public HeadlessEftposPaymentProcess() {
        DummyGUIHandler handler = new DummyGUIHandler();
        this.toolkit = new EftposToolkit(handler, new SimpleSaveAccount(handler, new SimplePrintAccount()), new HeadlessPaymentUI());
        this.manager = new EftposManager(this.toolkit);
    }

    @Override
    public FinanceTransaction doForwardPayment(PaymentRequest request) {
        EftposRequest eftRequest;
        VirtualEftpos eftpos = this.manager.getEftposForCashDrawer(request.getCashdrawer(), request.getTerminal());
        if (!request.isWeb() && eftpos == null) {
            String error = "Cannot perform eftpos payment: No virtual Eftpos for the CashDrawer";
            OrderMate.LOG.error(error);
            request.requestProcessed(EftposStatus.ERROR, error);
            return null;
        }
        Price toPay = request.getPayable().getDue();
        Price surchargeAmount = request.getSurcharge();
        if (Price.ZERO_DOLLAR.lessThan(surchargeAmount) && (eftpos == null || !eftpos.isAutoSurcharge())) {
            toPay = toPay.add(surchargeAmount);
        }
        if (eftpos != null && eftpos.isAutoSurcharge() && Price.ZERO_DOLLAR.lessThan(toPay)) {
            surchargeAmount = Price.ZERO_DOLLAR;
        }
        if (request.isWeb()) {
            WebTransaction newTransaction = new WebTransaction(request.getUser(), request.getTerminal(), toPay, request.getTip(), request.getCashdrawer(), FinanceUnit.getDefaultUnitFor(FinanceUnit.WEB_TYPE), request.getTerminal().getShift());
            newTransaction.setSurcharge(surchargeAmount);
            newTransaction.setVirtualEftpos(eftpos);
            eftRequest = new WebPaymentRequest((EftposTransaction)newTransaction, request.getPayable(), false, false, false, request.getWebPaymentCustomer());
        } else {
            CreditTransaction newTransaction = new CreditTransaction(request.getUser(), request.getTerminal(), toPay, request.getTip(), request.getCashdrawer(), null, request.getTerminal().getShift());
            newTransaction.setSurcharge(surchargeAmount);
            newTransaction.setVirtualEftpos(eftpos);
            eftRequest = new EftposRequest(newTransaction, request.getPayable(), false, false, false);
        }
        EftposResult result = this.manager.performTransaction(eftRequest);
        if (result.isApproved()) {
            OrderMate.LOG.info("Approved Transaction Result");
            if (request.getPayable() instanceof Account) {
                Account account = (Account)request.getPayable();
                EftposTransaction resultEftposTxn = eftRequest.getTransaction();
                EventContext context = new EventContext(request.getTerminal(), request.getUser());
                Price surchargeToApply = request.getSurcharge();
                if (!FinanceSurchargeCalculator.shouldApplyPreSurcharge(resultEftposTxn)) {
                    surchargeToApply = result.getActualSurcharge();
                    eftRequest.getTransaction().setSurcharge(surchargeToApply);
                }
                FinanceSurchargeCalculator.applySurcharge(account, resultEftposTxn.getSubType(), surchargeToApply, context);
                if (!account.getFinanceTransactions().contains(result.getRequest().getTransaction())) {
                    account.addFinanceTransaction(result.getRequest().getTransaction());
                }
                if (!this.toolkit.getSaveAccount().closeAccount((Account)request.getPayable(), true, true, new EventContext(request.getTerminal(), request.getUser()))) {
                    this.toolkit.getSaveAccount().saveAccount(account, new EventContext(request.getTerminal(), request.getUser()));
                    OrderMate.LOG.info("Web transaction saved to account " + account + ", but was unable to be closed.");
                }
            }
            request.requestProcessed(result.getEftposStatus(), null);
        } else {
            request.requestProcessed(result.getEftposStatus(), result.getExplicitError());
        }
        return eftRequest.getTransaction();
    }

    @Override
    public boolean canHandlePaymentRequest(PaymentRequest request) {
        return true;
    }

    @Override
    public void cancelPayment() {
        this.manager.getToolkit().getUI().getCancelSignal().emit();
    }
}

