/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.piggy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.piggy.PiggyRequestBuilder;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.piggy.GuestAccountSummary;
import au.com.ordermate.xmlintegration.piggy.GuestItem;
import au.com.ordermate.xmlintegration.piggy.PiggyAccountQueryModel;
import au.com.ordermate.xmlintegration.piggy.PiggyCategory;
import au.com.ordermate.xmlintegration.piggy.PiggyDayPart;
import au.com.ordermate.xmlintegration.piggy.PiggyRequest;
import au.com.ordermate.xmlintegration.piggy.PiggySalesLocation;
import au.com.ordermate.xmlintegration.piggy.PiggyStoreConfig;
import au.com.ordermate.xmlintegration.piggy.SalesItemInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.reports.debtor.DebtorSalesItemReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.piggy.PiggyDataHelper;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.webresource.AbstractResource;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="")
public class PiggyBackWebResource
extends AbstractResource {
    @GET
    @Path(value="/store_config")
    public Response syncPiggyStoreConfig() {
        OrderMate.LOG.info("Start Syncing PiggyS tore Config");
        try {
            PiggyStoreConfig piggyStoreConfig = new PiggyStoreConfig();
            long storeId = SystemCurrentInfo.getInstance().getRedbackId();
            List<DayPart> dayParts = PersistenceManager.getObjectList(DayPart.class, Query.select(DayPart.class).orderBy(DayPart.Properties.START_TIME).toString());
            List<InventoryCategory> categories = PersistenceManager.getObjectList(InventoryCategory.class, Query.select(InventoryCategory.class).equals(InventoryCategory.Properties.SYSTEM_STATE, "ACTIVE").orderBy(InventoryCategory.Properties.ID).toString());
            List<SalesLocation> salsLocations = PersistenceManager.getObjectList(SalesLocation.class, Query.select(SalesLocation.class).equals(SalesLocation.Properties.SYSTEM_STATE, "ACTIVE").orderBy(SalesLocation.Properties.ID).toString());
            ArrayList<PiggyDayPart> piggyDayPartList = new ArrayList<PiggyDayPart>();
            for (DayPart dayPart : dayParts) {
                PiggyDayPart piggyDayPart = new PiggyDayPart();
                piggyDayPart.setStartTime(Long.valueOf(dayPart.getStartTime().getTime()));
                piggyDayPart.setEndTime(Long.valueOf(dayPart.getEndTime().getTime()));
                piggyDayPart.setId(dayPart.getID());
                piggyDayPart.setLabel(dayPart.getLabel());
                piggyDayPartList.add(piggyDayPart);
            }
            ArrayList<PiggyCategory> piggyCategoryList = new ArrayList<PiggyCategory>();
            for (InventoryCategory inventoryCategory : categories) {
                PiggyCategory piggyCategory = new PiggyCategory();
                piggyCategory.setId(inventoryCategory.getID());
                piggyCategory.setName(inventoryCategory.getName());
                piggyCategoryList.add(piggyCategory);
            }
            ArrayList<PiggySalesLocation> arrayList = new ArrayList<PiggySalesLocation>();
            for (SalesLocation salesLocation : salsLocations) {
                PiggySalesLocation piggySalesLocation = new PiggySalesLocation();
                piggySalesLocation.setId(salesLocation.getID());
                piggySalesLocation.setName(salesLocation.getLabel());
                arrayList.add(piggySalesLocation);
            }
            piggyStoreConfig.setStoreId(Long.valueOf(storeId));
            piggyStoreConfig.getCategories().addAll(piggyCategoryList);
            piggyStoreConfig.getDayParts().addAll(piggyDayPartList);
            piggyStoreConfig.getSalesLocations().addAll(arrayList);
            String string = JSONUtil.toJson(piggyStoreConfig);
            OrderMate.LOG.info("PiggyBackWebResource:syncPiggyStoreConfig() json = " + string);
            return this.getResponse(string);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within syncPiggyStoreConfig method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @GET
    @Path(value="/non_room_sales")
    public Response getNonRoomAccountSales(@HeaderParam(value="from") long from, @HeaderParam(value="to") long to) {
        try {
            Date fromDate = new Date(from);
            Date toDate = new Date(to);
            List<TradingDay> tradingDays = TradingDayQueries.getClosedTradingDaysExStartIncEnd(fromDate, toDate);
            OrderMate.LOG.error("PiggyBackWebResource:getNonRoomAccountSales() for TradingDays " + tradingDays);
            PiggyDataHelper piggyDataHelper = new PiggyDataHelper();
            ArrayList<GuestItem> result = new ArrayList<GuestItem>();
            for (TradingDay tDay : tradingDays) {
                List<GuestItem> nonRoomAccountSales = piggyDataHelper.getNonRoomAccountSales(tDay);
                result.addAll(nonRoomAccountSales);
            }
            Long cashAccountId = SystemProperty.getInstance().getRmsCashAccountId();
            PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
            piggyRequestBuilder.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
            piggyRequestBuilder.setAccountId(cashAccountId);
            piggyRequestBuilder.setNonRoomAccountSales(result);
            PiggyRequest piggyRequest = piggyRequestBuilder.buildPushNonRoomSales();
            return this.getResponse(piggyRequest);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within getNonRoomAccountSales method");
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @POST
    @Path(value="update_piggy_property")
    public Response postPiggyBackConfig(String payload) {
        OrderMate.LOG.info("Incoming Piggy Config:" + payload);
        try {
            this.setCloudProperty(payload);
            return this.getResponse("PiggyBack Configuration Set");
        }
        catch (JSONException ex) {
            OrderMate.LOG.error("Unknown config from PiggyBack " + payload, (Throwable)ex);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @POST
    @Path(value="store_account")
    public Response postAccountInfo(String payload) {
        OrderMate.LOG.info("Incoming Piggy Account Query :" + payload);
        PiggyAccountQueryModel piggyAccountQueryModel = null;
        try {
            piggyAccountQueryModel = JSONUtil.fromJson(PiggyAccountQueryModel.class, payload);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unknown Piggy Account Query from PiggyBack " + payload, (Throwable)e);
            return this.getBadRequestResponse("Unknown Piggy Account Query from PiggyBack");
        }
        GuestAccountSummary guestAccountSummary = this.getAccountSummary(piggyAccountQueryModel);
        return this.getResponse(guestAccountSummary);
    }

    private GuestAccountSummary getAccountSummary(PiggyAccountQueryModel piggyAccountQueryModel) {
        Object[] params = null;
        List<DebtorSalesItemReport> debtorSalesItemReportList = PersistenceManager.getObjectList(DebtorSalesItemReport.class, this.getDebtorSalesQuery(piggyAccountQueryModel).toString(), params);
        if (debtorSalesItemReportList == null || debtorSalesItemReportList.size() == 0) {
            return null;
        }
        GuestAccountSummary guestAccountSummary = new GuestAccountSummary();
        guestAccountSummary.setAccountId(piggyAccountQueryModel.getAccountId());
        guestAccountSummary.setLocationId(Long.valueOf(piggyAccountQueryModel.getLocationId()));
        guestAccountSummary.setReservationId(Long.valueOf(piggyAccountQueryModel.getReservationId()));
        guestAccountSummary.setStartDate(piggyAccountQueryModel.getStartDate());
        guestAccountSummary.setEndDate(piggyAccountQueryModel.getEndDate());
        for (DebtorSalesItemReport debtorSalesItemReport : debtorSalesItemReportList) {
            SalesItemInfo salesItemInfo = new SalesItemInfo();
            salesItemInfo.setName(debtorSalesItemReport.getSalesItem().getLabel());
            salesItemInfo.setPriceEX(debtorSalesItemReport.getPriceEx().toBigDecimal());
            salesItemInfo.setPriceINC(debtorSalesItemReport.getPriceInc().toBigDecimal());
            salesItemInfo.setPurchaseDate(Long.valueOf(debtorSalesItemReport.getPurchaseDate().getTime()));
            salesItemInfo.setQuantity(Integer.valueOf(debtorSalesItemReport.getQuantity().intValue()));
            salesItemInfo.setTax(debtorSalesItemReport.getTax().toBigDecimal());
            salesItemInfo.setTotalEX(debtorSalesItemReport.getTotalEx().toBigDecimal());
            salesItemInfo.setTotalINC(debtorSalesItemReport.getTotalInc().toBigDecimal());
            salesItemInfo.setTotalTAX(debtorSalesItemReport.getTotalTax().toBigDecimal());
            guestAccountSummary.getItems().add(salesItemInfo);
        }
        return guestAccountSummary;
    }

    public void setCloudProperty(String payload) throws JSONException {
        OrderMate.LOG.info("Incoming Piggy Config:" + payload);
        if (StringUtils.isEmpty(payload)) {
            return;
        }
        JSONObject data = new JSONObject(payload);
        String searchRoomCardValue = data.getString("SearchByRoomCard");
        String postPaymentValue = data.getString("EnablePostPayments");
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig(CloudServerType.PiggyBack);
        if (config == null) {
            config = new CloudBackConfig(CloudServerType.PiggyBack);
        }
        if (!config.isEnabled()) {
            config.setEnabled(true);
        }
        config.setCloudProperty("SearchByRoomCard", searchRoomCardValue);
        config.setCloudProperty("EnablePostPayments", postPaymentValue);
        config.save();
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        return XMLHelper.getDateType(date == null ? new Date(0L) : date);
    }

    private ObjectQuery getDebtorSalesQuery(PiggyAccountQueryModel piggyAccountQueryModel) {
        long reservationID = piggyAccountQueryModel.getReservationId();
        int accountID = piggyAccountQueryModel.getAccountId();
        Date startDate = null;
        Date endDate = null;
        if (piggyAccountQueryModel.getStartDate() != null) {
            startDate = piggyAccountQueryModel.getStartDate().toGregorianCalendar().getTime();
        }
        if (piggyAccountQueryModel.getStartDate() != null) {
            endDate = piggyAccountQueryModel.getEndDate().toGregorianCalendar().getTime();
        }
        ObjectQuery query = Query.select(SalesItemQuantity.Properties.ID).select(SalesItemQuantity.Properties.ID, "fk_sales_item_quantity").select(RoomAccount.Properties.ID, "fk_debtor").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, DebtorSale.Properties.SALE_ACCOUNT).linkUsing(DebtorSale.Properties.DEBTOR, AbstractDebtor.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).whereFunction("sales_item.type = 'SalesItem'");
        if (reservationID > 0L) {
            query = query.equals(RoomAccount.Properties.EXT_ID, reservationID);
        }
        if (accountID > 0) {
            query = query.equals(RoomAccount.Properties.ROOMACCOUNTID, accountID);
        }
        if (startDate != null && endDate != null) {
            query = query.wherePropertyBetween(SalesItemQuantity.Properties.CREATION_TIME, startDate, endDate, SQLDateType.DATE);
        }
        query = query.orderBy(AbstractDebtor.Properties.GROUP).orderBy(DebtorSale.Properties.DEBTOR).orderBy(SalesItemQuantity.Properties.CREATION_TIME).orderBy(SalesItemQuantity.Properties.ID);
        return query;
    }
}

