/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.printing;

import au.com.ordermate.dockets.XMLDocketScanner;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.StringReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.transform.stream.StreamSource;
import ordermate.OrderMate;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.ExternalPrintJob;
import ordermate.webresource.AbstractResource;
import org.xml.sax.SAXException;

@Path(value="")
public class PrintingResource
extends AbstractResource {
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    @Path(value="/printdocket/{printerName}")
    public Response printDocket(@PathParam(value="printerName") String printerName, String docketXML) {
        try {
            XMLDocketScanner.getDocketXMLValidator().validate(new StreamSource(new StringReader(docketXML)));
            VirtualPrinter printer = PersistenceManager.getObject(VirtualPrinter.class, Query.select(VirtualPrinter.class).equals(VirtualPrinter.Properties.LABEL, printerName).toString());
            if (printer != null) {
                DocketProcessor.printExternalDocket(new ExternalPrintJob(docketXML, printer));
                return Response.status((Response.Status)Response.Status.OK).type("text/plain").entity((Object)("Successfully printed to " + printerName)).build();
            }
            return this.getBadRequestResponse("Non-existent printer requested");
        }
        catch (SAXException e) {
            return this.getBadRequestResponse("Malformed XML sent: " + e.getMessage());
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception occurred attempting to service online print request", (Throwable)e);
            if (e.getMessage() != null) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)e.getMessage()).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Unknown Internal Server Error").build();
        }
    }
}

