/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.reports;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.control.SearchFilterControl;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.reports.ReportMaker;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigFilter;
import ordermate.database.config.report.ReportConfigRowAction;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;
import ordermate.database.reports.maker.ReportMeta;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;
import ordermate.database.users.User;
import ordermate.integration.jaxb.smreport.SMReportConfig;
import ordermate.integration.jaxb.smreport.SMReportConfigList;
import ordermate.integration.jaxb.smreport.SMReportFilter;
import ordermate.integration.jaxb.smreport.SMReportFilterOptions;
import ordermate.integration.jaxb.smreport.SMReportPeriodFunction;
import ordermate.integration.jaxb.smreport.SMReportRowAction;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.reports.ReportMakerExportType;
import ordermate.webresource.reports.export.ReportMakerCSVExporter;
import ordermate.webresource.reports.export.ReportMakerExporter;
import ordermate.webresource.reports.export.ReportMakerJSONExporter;
import ordermate.webresource.reports.export.ReportMakerPDFExporter;

@Path(value="")
public class ReportMakerResource
extends AbstractResource {
    @Override
    protected MediaType getMediaType() {
        List acceptedHeaders = this.getHeaders().getAcceptableMediaTypes();
        if (acceptedHeaders.isEmpty()) {
            return MediaType.TEXT_PLAIN_TYPE;
        }
        return (MediaType)acceptedHeaders.get(0);
    }

    private ReportMakerExporter<?> getExporter() {
        String mediaType = this.getMediaType().toString();
        if (ReportMakerExportType.PDF.getMediaType().equals(mediaType)) {
            return new ReportMakerPDFExporter();
        }
        if (ReportMakerExportType.JSON.getMediaType().equals(mediaType)) {
            return new ReportMakerJSONExporter();
        }
        if (ReportMakerExportType.XML.getMediaType().equals(mediaType)) {
            return new ReportMakerJSONExporter();
        }
        if (ReportMakerExportType.CSV.getMediaType().equals(mediaType)) {
            return new ReportMakerCSVExporter();
        }
        return new ReportMakerCSVExporter();
    }

    @GET
    @Produces(value={"text/plain", "application/xml", "application/json", "application/pdf"})
    @Path(value="/runReport")
    public Response runReport(@QueryParam(value="reportConfig") String reportConfig) {
        ReportConfig report = PersistenceManager.getObject(ReportConfig.class, Query.select(ReportConfig.class).equals(ReportConfig.Properties.LABEL, reportConfig).toString());
        if (report == null) {
            return this.getBadRequestResponse("Report unavailable.");
        }
        ConfigurableReportMaker maker = OMReportMakerFactory.getInstance().createReportMaker(report);
        return this.getOKResponse(this.getExporter().export(maker));
    }

    @GET
    @Produces(value={"text/plain", "application/xml", "application/json", "application/pdf"})
    @Path(value="/runReportForToday")
    public Response runReportForToday(@QueryParam(value="reportTitle") String reportTitle) {
        OMReportMakerFactory factory = OMReportMakerFactory.getInstance();
        ConfigurableReportMaker maker = (ConfigurableReportMaker)factory.createReportMaker(reportTitle);
        if (maker == null) {
            return this.getBadRequestResponse("Report unavailable.");
        }
        ReportConfig config = this.buildConfig(maker, "now", "startofday(now) : endofday(now)");
        maker.setReportConfig(config);
        return this.getOKResponse(this.getExporter().export(maker));
    }

    @GET
    @Produces(value={"text/plain", "application/xml", "application/json", "application/pdf"})
    @Path(value="/runReportForYesterday")
    public Response runReportForYesterday(@QueryParam(value="reportTitle") String reportTitle) {
        OMReportMakerFactory factory = OMReportMakerFactory.getInstance();
        ConfigurableReportMaker maker = (ConfigurableReportMaker)factory.createReportMaker(reportTitle);
        if (maker == null) {
            return this.getBadRequestResponse("Report unavailable.");
        }
        ReportConfig config = this.buildConfig(maker, "-1d", "startofday(-1d) : endofday(-1d)");
        maker.setReportConfig(config);
        return this.getOKResponse(this.getExporter().export(maker));
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="dynamicConfig")
    public final Response getDynamicConfiguration(@QueryParam(value="reportType") String reportType) {
        OMReportMakerFactory factory = OMReportMakerFactory.getInstance();
        ConfigurableReportMaker maker = (ConfigurableReportMaker)factory.createReportMaker(reportType);
        if (maker == null) {
            return this.getBadRequestResponse("No configuration available for " + reportType);
        }
        ReportConfig config = new ReportConfig(maker.getReportType(), "Dynamic");
        maker.setReportConfig(config);
        SMReportConfig exportConfig = new SMReportConfig();
        exportConfig.setVersion(OrderMate.VERSION);
        exportConfig.setLabel(config.getLabel());
        exportConfig.setType(config.getType());
        ReportMeta meta = factory.getMeta(config.getType());
        exportConfig.setCategory(meta.category);
        exportConfig.setSubcategory(this.getStringAsNullIfEmpty(meta.subcategory));
        exportConfig.setPeriod(SMReportPeriodFunction.valueOf(meta.period.name()));
        if (!this.validatePermission(meta.permission)) {
            exportConfig.setDisabled(meta.permission);
        }
        Iterator<SearchFilterControl> iterator = maker.getReportFilterControls().iterator();
        while (iterator.hasNext()) {
            SearchFilterControl next;
            SearchFilterControl control = next = iterator.next();
            SMReportFilter exFilter = new SMReportFilter();
            exFilter.setLabel(control.getName());
            exFilter.setType(control.getTranslator().getFormat());
            exFilter.setEmptyAllowed(control.isAllowNull());
            exFilter.setPriority(control.isPriority());
            exFilter.setSequence(control.getSequence());
            exFilter.setMakerName(control.getMakerName());
            exFilter.setDefaultValue(control.getDefaultValue());
            if (control.getMakerName() == null || control.getMakerName().equals("")) {
                List<SMReportFilterOptions> options = control.getOptions();
                if (control.getName().equals("Time") && options == null) {
                    options = new ArrayList<SMReportFilterOptions>();
                    List<DayPart> dayParts = DayPart.getAllDayParts(true);
                    for (DayPart d : dayParts) {
                        SMReportFilterOptions newOption = new SMReportFilterOptions();
                        Integer ID = dayParts.indexOf(d);
                        newOption.setId(ID.toString());
                        newOption.setLabel(d.getLabel() + "~" + new SimpleDateFormat("HH:mm:ss").format(d.getStartTime()) + "~" + new SimpleDateFormat("HH:mm:ss").format(d.getEndTime()));
                        options.add(newOption);
                    }
                }
                if (options != null) {
                    for (SMReportFilterOptions option : options) {
                        exFilter.getOptions().add(option);
                    }
                }
            }
            exportConfig.getFilters().add(exFilter);
        }
        ReportConfig reportConfig = PersistenceManager.getObject(ReportConfig.class, Query.select(ReportConfig.class).equals(ReportConfig.Properties.TYPE, reportType).toString());
        List<ReportConfigRowAction> actions = PersistenceManager.getObjectList(ReportConfigRowAction.class, Query.select(ReportConfigRowAction.class).equals(ReportConfigRowAction.Properties.REPORT_CONFIG, reportConfig).toString());
        for (ReportConfigRowAction action : actions) {
            SMReportRowAction smAction = new SMReportRowAction();
            smAction.setName(action.getActionName());
            smAction.setLabel(action.getActionLabel());
            exportConfig.getRowActions().add(smAction);
        }
        return this.getOKResponse(exportConfig);
    }

    private boolean validatePermission(String permissiomName) {
        if (this.getHeaders().getRequestHeader("userEmail") == null) {
            return false;
        }
        String userEmail = (String)this.getHeaders().getRequestHeader("userEmail").get(0);
        if (userEmail.isEmpty()) {
            return false;
        }
        User user = PersistenceManager.getObject(User.class, Query.select(User.class).equals(User.Properties.EMAIL, userEmail).toString());
        if (user == null) {
            return false;
        }
        Permission permission = PersistenceManager.getObject(Permission.class, Query.select(Permission.class).equals(Permission.Properties.NAME, permissiomName).toString());
        if (permission == null) {
            return false;
        }
        return user.getPermissionAccessLevel(permission).equals("ENABLED");
    }

    private Map<String, String> getPermissionAccessLevelMap(PermissionGroup permissionGroup) {
        List<PermissionGroupLink> permissionGroupLinkList = PersistenceManager.getObjectList(PermissionGroupLink.class, Query.select(PermissionGroupLink.class).equals(PermissionGroupLink.Properties.PERMISSION_GROUP, permissionGroup).toString());
        if (permissionGroupLinkList.isEmpty()) {
            return null;
        }
        HashMap<String, String> permissionAccessLevelMap = new HashMap<String, String>();
        for (int i = 0; i < permissionGroupLinkList.size(); ++i) {
            PermissionGroupLink permissionGroupLink = permissionGroupLinkList.get(i);
            permissionAccessLevelMap.put(permissionGroupLink.getPermission().getName(), permissionGroupLink.getAccessLevel());
        }
        return permissionAccessLevelMap;
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/plain", "application/xml", "application/json", "application/pdf"})
    @Path(value="/dynamicReport")
    public Response runDynamicReport(SMReportConfig exConfig) {
        if (exConfig == null) {
            return this.getBadRequestResponse("Configuration cannot be null");
        }
        ConfigurableReportMaker maker = (ConfigurableReportMaker)OMReportMakerFactory.getInstance().createReportMaker(exConfig.getType());
        if (maker == null) {
            return this.getBadRequestResponse("No report can be made for " + exConfig.getType());
        }
        ReportConfig config = new ReportConfig(exConfig.getType(), exConfig.getLabel());
        maker.setReportConfig(config);
        for (SMReportFilter exFilter : exConfig.getFilters()) {
            ReportConfigFilter filter = config.getFilter(exFilter.getLabel());
            if (filter != null) {
                filter.setSearchValue(exFilter.getValue());
                continue;
            }
            return this.getBadRequestResponse("Filter " + exFilter.getLabel() + " doesn't exist for " + exConfig.getLabel());
        }
        try {
            return this.getOKResponse(this.getExporter().export(maker));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot perform report " + config.getLabel(), (Throwable)ex);
            if (ex instanceof IllegalStateException) {
                return this.getBadRequestResponse("Invalid report configuration: " + ex.getMessage());
            }
            return this.getInternalServerErrorResponse("Error while performing report.");
        }
    }

    @GET
    @Produces(value={"text/plain", "application/xml", "application/json"})
    @Path(value="/listReportConfigs")
    public final Response listReportConfigs() {
        List<ReportConfig> configs = PersistenceManager.getObjectList(ReportConfig.class, Query.select(ReportConfig.class).active(ReportConfig.class).toString());
        ArrayList<String> configLabels = new ArrayList<String>(configs.size());
        for (ReportConfig rc : configs) {
            configLabels.add(rc.getLabel());
        }
        return this.getOKResponse(this.getExporter().exportList(configLabels));
    }

    @GET
    @Produces(value={"text/plain", "application/xml", "application/json"})
    @Path(value="/listReports")
    public final Response listReports() {
        return this.getOKResponse(this.getExporter().exportList(OMReportMakerFactory.getInstance().getTypes()));
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/listDynamicReports")
    public final Response listDynamicReports() {
        User user;
        SMReportConfigList configList = new SMReportConfigList();
        OMReportMakerFactory factory = OMReportMakerFactory.getInstance();
        List<String> reportTypes = factory.getTypes();
        Map<String, String> permissionAccessLevelMap = null;
        String userEmail = null;
        if (this.getHeaders().getRequestHeader("userEmail") != null) {
            userEmail = (String)this.getHeaders().getRequestHeader("userEmail").get(0);
        }
        if (!StringUtils.isEmpty(userEmail) && (user = PersistenceManager.getObject(User.class, Query.select(User.class).equals(User.Properties.EMAIL, userEmail).active(User.class).toString())) != null) {
            permissionAccessLevelMap = this.getPermissionAccessLevelMap(user.getPermissionGroup());
        }
        for (String type : reportTypes) {
            SMReportConfig exportConfig = new SMReportConfig();
            exportConfig.setType(type);
            ReportMeta meta = factory.getMeta(type);
            exportConfig.setVersion(OrderMate.VERSION);
            exportConfig.setLabel(meta.description);
            exportConfig.setCategory(meta.category);
            exportConfig.setSubcategory(this.getStringAsNullIfEmpty(meta.subcategory));
            exportConfig.setPeriod(SMReportPeriodFunction.valueOf(meta.period.name()));
            if (permissionAccessLevelMap != null) {
                String access_level = permissionAccessLevelMap.get(meta.permission);
                if (access_level == null || access_level.equals("HIDDEN")) continue;
                if (access_level.equals("DISABLED")) {
                    exportConfig.setCanRun(false);
                } else if (access_level.equals("ENABLED")) {
                    exportConfig.setCanRun(true);
                }
                configList.getSMReportConfigs().add(exportConfig);
                continue;
            }
            if (userEmail != null) continue;
            exportConfig.setCanRun(true);
            configList.getSMReportConfigs().add(exportConfig);
        }
        return this.getOKResponse(configList);
    }

    private String getStringAsNullIfEmpty(String s) {
        return s == "" ? null : s;
    }

    private ReportConfig buildConfig(ReportMaker maker, String fixedDateValue, String dateRangeValue) {
        ReportConfig config = new ReportConfig(maker.getReportType(), "Temp_" + maker.getReportType());
        ArrayList<ReportConfigFilter> filters = new ArrayList<ReportConfigFilter>();
        for (SearchFilterControl sfc : maker.getReportFilterControls()) {
            if (!sfc.getName().contains("Date") && !sfc.getName().contains("Trading")) continue;
            ReportConfigFilter date = new ReportConfigFilter(config, sfc.getName());
            date.setSearchValue(sfc.getName().contains("Range") ? dateRangeValue : fixedDateValue);
            filters.add(date);
        }
        config.setFilters(filters);
        return config;
    }
}

