/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.reports.export;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.oquery.search.control.SearchFilterControl;
import au.com.ordermate.reports.ReportMaker;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.ReportMakerUtility;
import ordermate.webresource.reports.export.JSONUtils;
import ordermate.webresource.reports.export.ReportMakerExporter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportMakerJSONExporter
implements ReportMakerExporter<String> {
    private static final String currencyFormat = "$#,##0.00";

    @Override
    public String export(ReportMaker maker) {
        Object provider = null;
        List<Pair<String, ReportMakerUtility.TabulatedReport>> reportList = null;
        if (maker instanceof ConfigurableReportMaker) {
            ConfigurableReportMaker configurableReportMaker = (ConfigurableReportMaker)maker;
            provider = configurableReportMaker.makeProvider();
            try {
                reportList = configurableReportMaker.tabulateResults(provider);
            }
            catch (BuilderException ex) {
                OrderMate.LOG.error("Cannot make report for JSON", (Throwable)ex);
                return "";
            }
        }
        if (reportList == null) {
            return null;
        }
        JSONObject root = new JSONObject();
        if (maker instanceof ConfigurableReportMaker) {
            this.tryPut(root, "filters", this.getFilters((ConfigurableReportMaker)maker));
        }
        JSONArray reportArray = new JSONArray();
        for (Pair<String, ReportMakerUtility.TabulatedReport> nextReport : reportList) {
            JSONObject subReportData = this.translateReportToJSON((String)nextReport.key, (ReportMakerUtility.TabulatedReport)nextReport.value);
            ReportMakerUtility.TabulatedReportMetaData metadata = ((ReportMakerUtility.TabulatedReport)nextReport.value).getMetaData();
            JSONObject jsonMeta = new JSONObject();
            ArrayList<JSONObject> cols = new ArrayList<JSONObject>(metadata.getColumnMetaData().size());
            for (ReportMakerUtility.ReportColumnMetaData colMeta : metadata.getColumnMetaData()) {
                JSONObject jsonMetaCol = new JSONObject();
                this.tryPut(jsonMetaCol, "type", colMeta.type);
                this.tryPut(jsonMetaCol, "header", colMeta.header);
                if (colMeta.pattern != null && (colMeta.pattern.equals("$0.00") || colMeta.pattern.equals("$#0.00"))) {
                    this.tryPut(jsonMetaCol, "format", currencyFormat);
                } else {
                    this.tryPut(jsonMetaCol, "format", colMeta.pattern);
                }
                this.tryPut(jsonMetaCol, "grouped", colMeta.grouped);
                if (colMeta.totaled) {
                    this.tryPut(jsonMetaCol, "totaled", colMeta.totaled);
                }
                if (colMeta.locked) {
                    this.tryPut(jsonMetaCol, "locked", colMeta.locked);
                }
                cols.add(jsonMetaCol);
            }
            JSONArray jsonMetaCols = new JSONArray(cols);
            this.tryPut(jsonMeta, "created", DateTimeUtils.getConsistent24HourReportDateFormat().format(metadata.getDateCreated()));
            this.tryPut(jsonMeta, "columns", jsonMetaCols);
            this.tryPut(subReportData, "metadata", jsonMeta);
            this.tryAdd(reportArray, subReportData);
        }
        this.tryPut(root, "reports", reportArray);
        return root.toString();
    }

    @Override
    public String exportList(List<String> toExport) {
        return JSONUtils.toJSONArray(toExport).toString();
    }

    private JSONObject getFilters(ConfigurableReportMaker maker) {
        JSONObject filterObj = new JSONObject();
        for (SearchFilterControl sfc : maker.getReportFilterControls()) {
            Object value = sfc.getTranslatedValue(maker.getReportConfig().getFilter(sfc.getName()).getSearchValue());
            if (value == null) continue;
            this.tryPut(filterObj, sfc.getName(), this.standardiseFilterValue(value));
        }
        return filterObj;
    }

    private String standardiseFilterValue(Object value) {
        ArrayList listVal;
        if (value instanceof Date) {
            return String.valueOf(((Date)value).getTime());
        }
        if (value instanceof ArrayList && (listVal = (ArrayList)value).size() == 2 && listVal.get(0) instanceof Date) {
            return Arrays.asList(((Date)listVal.get(0)).getTime(), ((Date)listVal.get(1)).getTime()).toString();
        }
        return value.toString();
    }

    private String standardiseDate(Date date) {
        Date dateVal = DateTimeUtils.clearTimePart(date);
        return new SimpleDateFormat("EEE MMM dd yyyy").format(dateVal);
    }

    private JSONObject translateReportToJSON(String label, ReportMakerUtility.TabulatedReport report) {
        JSONArray rows = new JSONArray();
        Object[][] data = report.getData();
        for (int i = 1; i < data.length; ++i) {
            JSONArray row = new JSONArray();
            Object[] objectArray = data[i];
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object datum;
                Object next = datum = objectArray[j];
                this.tryAdd(row, next);
            }
            this.tryAdd(rows, row);
        }
        JSONObject root = new JSONObject();
        this.tryPut(root, "label", label);
        this.tryPut(root, "rows", rows);
        return root;
    }

    private void tryAdd(JSONArray json, Object value) {
        try {
            json.put(json.length(), value);
        }
        catch (JSONException e) {
            OrderMate.LOG.error("Couldn't pump " + value + " into JSONArray for export. Expect bad data!", (Throwable)e);
        }
    }

    private void tryPut(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            OrderMate.LOG.error("Couldn't pump " + key + " into JSONObject for export. Expect bad data!", (Throwable)e);
        }
    }
}

