/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.reports.export;

import au.com.ordermate.reports.ReportMaker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.OrderMate;
import ordermate.webresource.reports.export.ReportMakerExporter;

public class ReportMakerPDFExporter
implements ReportMakerExporter<byte[]> {
    @Override
    public byte[] export(ReportMaker maker) {
        return this.buildPDF(maker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildPDF(ReportMaker maker) {
        JasperPrint print = maker.createJasperReport();
        if (print != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)bout);
                bout.flush();
                bout.close();
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            catch (JRException ex) {
                OrderMate.LOG.error("Cannot export report, jasper error ", (Throwable)ex);
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot export report, io error ", (Throwable)ex);
            }
            finally {
                if (bout != null) {
                    try {
                        bout.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return new byte[0];
    }

    @Override
    public byte[] exportList(List<String> toExport) {
        throw new IllegalStateException("This data is not available in PDF form.");
    }
}

