/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.sales.time.SalesByTimeReport;
import ordermate.database.searchers.reports.sales.time.SalesByTimeSearcher;
import ordermate.database.stock.StockArea;
import ordermate.integration.jaxb.webservice.sales.ObjectFactory;
import ordermate.integration.jaxb.webservice.sales.SalesByTimeEntry;
import ordermate.integration.jaxb.webservice.sales.SalesByTimeList;
import ordermate.integration.jaxb.webservice.sales.StockAreaEntry;
import ordermate.webresource.WebResourceExporter;

public class SalesByTimeExporter
extends WebResourceExporter<SalesByTimeList> {
    private ObjectFactory objFactory = new ObjectFactory();
    private Calendar fromReportDate;
    private Calendar toReportDate;
    private StockArea selectedStockArea;
    private SalesLocation selectedLocation;

    SalesByTimeList generateSalesByTimeReport(String fromDate, String toDate, Long stockAreaId, Long locationId) {
        if (this.helper == null) {
            OrderMate.LOG.error("SalesByTimeExporter cannot export if helper is null.");
            return this.objFactory.createSalesByTimeList();
        }
        this.setupAndValidateDates(fromDate, toDate);
        SalesByTimeSearcher searcher = new SalesByTimeSearcher();
        searcher.getTradingDayDateRangeFilter().setStart(this.fromReportDate.getTime());
        searcher.getTradingDayDateRangeFilter().setEnd(this.toReportDate.getTime());
        searcher.getStockAreaFilter().clearSearch();
        if (stockAreaId != null && stockAreaId > 0L && SystemProperty.getInstance().isStockControlEnabled()) {
            this.selectedStockArea = PersistenceManager.getByID(stockAreaId, StockArea.class);
            if (this.selectedStockArea != null) {
                searcher.getStockAreaFilter().setSearchValue(this.selectedStockArea);
            } else {
                OrderMate.LOG.warn("Cannot export sales for stock area :" + stockAreaId + " doesn't exist");
            }
        }
        if (locationId != null && locationId > 0L) {
            this.selectedLocation = PersistenceManager.getByID(locationId, SalesLocation.class);
            if (this.selectedLocation != null) {
                searcher.getLocationFilter().setSearchValue(this.selectedLocation);
            } else {
                OrderMate.LOG.warn("Cannot export sales for location :" + locationId + " doesn't exist");
            }
        }
        List<SalesByTimeReport> salesReportList = searcher.search();
        return this.buildSalesListFromResult(salesReportList);
    }

    private void setupAndValidateDates(String fromDate, String toDate) {
        this.fromReportDate = Calendar.getInstance();
        this.toReportDate = Calendar.getInstance();
        if (fromDate != null) {
            this.fromReportDate.setTime(this.helper.convertLongStringToDate(fromDate));
        }
        if (toDate != null) {
            this.toReportDate.setTime(this.helper.convertLongStringToDate(toDate));
        }
        DateTimeUtils.clearTimePart(this.fromReportDate);
        DateTimeUtils.lastMillisecond(this.toReportDate);
        this.helper.validateDates(this.fromReportDate, this.toReportDate);
    }

    private SalesByTimeList buildSalesListFromResult(List<SalesByTimeReport> salesList) {
        SalesByTimeList salesReportList = this.objFactory.createSalesByTimeList();
        salesReportList.setBusinessName(BusinessInfo.getInstance().getName());
        salesReportList.setToDate(this.helper.makeDate(this.toReportDate.getTime()));
        salesReportList.setFromDate(this.helper.makeDate(this.fromReportDate.getTime()));
        salesReportList.setStockArea(this.selectedStockArea != null ? this.selectedStockArea.getID() : null);
        for (StockArea area : StockArea.getStockAreas()) {
            salesReportList.getStockAreas().add(this.getStockAreaEntry(area));
        }
        for (SalesByTimeReport reportItem : salesList) {
            salesReportList.getSales().add(this.convertToSaleEntry(reportItem));
        }
        return salesReportList;
    }

    private SalesByTimeEntry convertToSaleEntry(SalesByTimeReport salesReport) {
        SalesByTimeEntry entry = this.objFactory.createSalesByTimeEntry();
        entry.setDate(this.helper.makeDate(salesReport.getDate()));
        entry.setLocation(salesReport.getLocation());
        entry.setNumPatrons(BigInteger.valueOf(salesReport.getNumPatrons()));
        entry.setSalesTotal(salesReport.getSalesTotal().doubleValue());
        entry.setSalesExTax(salesReport.getSalesExTax().doubleValue());
        entry.setTotalDiscounts(salesReport.getTotalDiscounts().doubleValue());
        entry.setTotalSurcharges(salesReport.getTotalSurcharges().doubleValue());
        entry.setFromTime(this.getCalHourFor(salesReport.getFromTime()));
        entry.setToTime(this.getCalHourFor(salesReport.getToTime()));
        entry.setStockareaId(salesReport.getStockAreaId());
        entry.setStockareaLabel(salesReport.getStockAreaLabel());
        return entry;
    }

    private StockAreaEntry getStockAreaEntry(StockArea area) {
        StockAreaEntry entry = this.objFactory.createStockAreaEntry();
        entry.setStockareaId(area.getID());
        entry.setLabel(area.getLabel());
        entry.setIsActive(Boolean.TRUE);
        return entry;
    }

    private XMLGregorianCalendar getCalHourFor(int hour) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(10, hour);
        return this.helper.makeTime(cal);
    }

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{SalesByTimeEntry.class, SalesByTimeList.class, StockAreaEntry.class};
    }

    @Override
    public String getName() {
        return "Daily Sales Exporter";
    }
}

