/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.sync;

import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.xmlintegration.ccpos.CCSyncMessage;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.integration.permission.StoreSyncManager;
import ordermate.webresource.AbstractResource;

@Path(value="")
public class SyncResource
extends AbstractResource {
    @GET
    @Path(value="/permissions")
    public Response notifySyncUp() {
        try {
            StoreSyncManager storeSyncMagager = StoreSyncManager.getInstance();
            storeSyncMagager.scheduleSyncNow();
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within updatePermissions method");
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }

    @POST
    @Path(value="/permissions")
    @Consumes(value={"text/plain"})
    public Response updatePermissions(String cCMessageJson) throws JsonMappingException, IOException {
        try {
            List<CCSyncMessage> cCMessages = JSONUtil.fromJsonToList(CCSyncMessage.class, cCMessageJson);
            StoreSyncManager storeSyncMagager = StoreSyncManager.getInstance();
            storeSyncMagager.updateUserPermissions(cCMessages);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error within updatePermissions method", (Throwable)ex);
            return this.getInternalServerErrorResponse(ex.getMessage());
        }
    }
}

