/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.tpx;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TPXDocketSummary")
public class TPXDocketSummary {
    @XmlAttribute(name="docketId")
    private long docketId;
    @XmlAttribute(name="createDate")
    private long createdDate;
    @XmlAttribute(name="modifiedDate")
    private long modifiedDate;
    @XmlAttribute(name="customerName")
    private String customerName;
    @XmlAttribute(name="shortenedCustomerName")
    private String shortenedCustomerName;
    @XmlAttribute(name="customerId")
    private Long customerId;
    @XmlAttribute(name="accountId")
    private Long accountId;
    @XmlAttribute(name="printerId")
    private Long printerId;
    @XmlAttribute(name="state")
    private KTSDocketState state;
    @XmlAttribute(name="nowReadyTimeout")
    private int nowReadyTimeout = 40000;

    @Deprecated
    public TPXDocketSummary() {
    }

    private String getNameShortened(Customer c) {
        String s = "";
        if (c == null) {
            return s;
        }
        if (c.getFirstName() != null && !c.getFirstName().isEmpty()) {
            s = s + c.getFirstName() + " ";
        }
        if (c.getLastName() != null && !c.getLastName().isEmpty()) {
            s = s + c.getLastName().substring(0, 1) + ".";
        }
        return s;
    }

    public TPXDocketSummary(KTSDocketData data) {
        this.docketId = data.getKtsId();
        this.printerId = data.getPrinter().getID();
        this.createdDate = data.getCreated().getTime();
        this.modifiedDate = data.getModified().getTime();
        this.state = data.getState();
        Account account = data.getSalesAccount();
        if (account != null) {
            this.accountId = account.getID();
            Customer customer = account.getCustomer();
            if (customer != null) {
                this.customerId = customer.getID();
                this.customerName = customer.getNameAndTitle();
                this.shortenedCustomerName = this.getNameShortened(customer);
            } else if (account.hasTicketData()) {
                StringBuilder SB = new StringBuilder();
                for (String ticket : account.getTicketData()) {
                    SB.append(ticket).append(" ");
                }
                this.customerName = SB.toString();
            }
        }
    }

    public final long getDocketId() {
        return this.docketId;
    }

    public final long getCreatedDate() {
        return this.createdDate;
    }

    public final long getModifiedDate() {
        return this.modifiedDate;
    }

    public final String getCustomerName() {
        return this.customerName;
    }

    public final String getShortenedCustomerName() {
        return this.shortenedCustomerName;
    }

    public final Long getCustomerId() {
        return this.customerId;
    }

    public final Long getAccountId() {
        return this.accountId;
    }

    public final KTSDocketState getState() {
        return this.state;
    }

    public final Long getPrinterId() {
        return this.printerId;
    }

    public void setNowReadyTimeout(int timeout) {
        this.nowReadyTimeout = timeout;
    }

    public final int getNowReadyTimeout() {
        return this.nowReadyTimeout;
    }

    public boolean equals(Object otherSumm) {
        return this.getDocketId() == ((TPXDocketSummary)otherSumm).getDocketId();
    }
}

