/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.tpx;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.webresource.tpx.TPXDocketSummary;

public class TPXDocketSummaryTool {
    private ObjectMapper mapper;

    private void initMapper() {
        this.mapper = new ObjectMapper();
        JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.getDeserializationConfig().with((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().with((AnnotationIntrospector)introspector);
    }

    public String marshal(Object toMarshal) {
        if (this.mapper == null) {
            this.initMapper();
        }
        String output = "";
        if (toMarshal == null) {
            OrderMate.LOG.error("Cannot marshal a null object");
        } else {
            try {
                output = this.mapper.writeValueAsString(toMarshal);
            }
            catch (JsonProcessingException ex) {
                OrderMate.LOG.error("Cannot marshal object into JSON format", (Throwable)ex);
            }
        }
        return output;
    }

    public List<TPXDocketSummary> unmarshal(String value) {
        this.initMapper();
        if (value == null || value.isEmpty()) {
            OrderMate.LOG.error("Cannot unmarshal empty string");
            return null;
        }
        List unmarshalled = null;
        try {
            CollectionType t = CollectionType.construct(ArrayList.class, (JavaType)SimpleType.construct(TPXDocketSummary.class));
            unmarshalled = (List)this.mapper.readValue(value.getBytes(), (JavaType)t);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in object of type List<TPXDocketSummary>", (Throwable)ex);
        }
        return unmarshalled;
    }

    public ConfigSmallImage reconstructImage(byte[] imageData, String label) {
        ConfigSmallImage toReturn = new ConfigSmallImage(label);
        toReturn.setImageData(imageData);
        return toReturn;
    }
}

