/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.tpx;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.sales.Customer;
import ordermate.webresource.tpx.TPXDocketSummary;
import ordermate.webresource.tpx.TPXDocketSummaryTool;

@Path(value="")
public class TPXStatusResource {
    private TPXDocketSummaryTool tool = new TPXDocketSummaryTool();

    @GET
    @Path(value="dockets")
    @Produces(value={"application/json"})
    public String getDocketsModifiedSince(@QueryParam(value="tpxId") Long tpxId, @QueryParam(value="modifiedSince") Long modifiedSince) {
        ArrayList<TPXDocketSummary> summaries = new ArrayList<TPXDocketSummary>();
        Long minDate = System.currentTimeMillis() - Long.valueOf(5184000000L);
        if (modifiedSince < minDate) {
            modifiedSince = minDate;
        }
        if (tpxId != null && modifiedSince != null) {
            Date date = new Date(modifiedSince);
            ObjectQuery query = Query.select(KTSDocketData.class).equals(KTSDocketData.Properties.PRINTER, tpxId).greaterThan(KTSDocketData.Properties.MODIFIED, date, SQLDateType.TIMESTAMP);
            for (KTSDocketData data : PersistenceManager.getObjectList(KTSDocketData.class, query.toString())) {
                summaries.add(new TPXDocketSummary(data));
            }
        } else {
            OrderMate.LOG.warn("Cannot get data for null tpx or modified since.");
        }
        return this.tool.marshal(summaries);
    }

    @GET
    @Path(value="customerimage")
    @Produces(value={"application/octet-stream"})
    public byte[] getCustomerImage(@QueryParam(value="customerId") Long customerId) {
        if (customerId != null) {
            Customer customer = PersistenceManager.getObject(Customer.class, Query.select(Customer.class).equals(Customer.Properties.ID, customerId).active(Customer.class).toString());
            if (customer == null) {
                return new byte[0];
            }
            if (customer.getImage() == null) {
                return new byte[0];
            }
            return customer.getImage().getImageData();
        }
        return new byte[0];
    }
}

