/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.tyromobile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import org.eclipse.jetty.util.ajax.JSON;

class TyroMobileJSONHelper {
    TyroMobileJSONHelper() {
    }

    public static Map<String, String> convertToJSONObject(Account account) {
        HashMap<String, String> accMap = new HashMap<String, String>();
        accMap.put("pos-reference", String.valueOf(account.getID()));
        accMap.put("amount", String.valueOf(account.getDue().getNumCents()));
        accMap.put("display-text", TyroMobileJSONHelper.getAccountDisplayText(account));
        if (account instanceof TableAccount) {
            accMap.put("table", ((TableAccount)account).getTable().getPrimaryPhysicalTable().getName());
        }
        return accMap;
    }

    public static Object[] convertToJSONObject(List<? extends Account> accountList) {
        Object[] openSales = new Object[accountList.size()];
        int i = 0;
        for (Account account : accountList) {
            openSales[i] = TyroMobileJSONHelper.convertToJSONObject(account);
            ++i;
        }
        return openSales;
    }

    private static String getAccountDisplayText(Account account) {
        String accDesc = account.getLabel();
        if (account instanceof TableAccount) {
            accDesc = ((TableAccount)account).getTable().getPrimaryPhysicalTable().getLogicalTable().getTableGroup().getName();
        }
        if (!accDesc.isEmpty() && accDesc.length() > 6) {
            return accDesc.substring(0, 6);
        }
        return accDesc;
    }

    public static Object convertFromJSON(String tyroJSONString) {
        if (tyroJSONString != null && tyroJSONString.contains("{\"open-sales\":[")) {
            return JSON.parse((String)tyroJSONString.substring("{\"open-sales\":[".length() - 1, tyroJSONString.length() - 1));
        }
        return JSON.parse((String)tyroJSONString);
    }
}

