/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.tyromobile;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceType;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.users.User;
import ordermate.gui.SimpleSaveAccount;
import ordermate.integration.eftpos.tyro.TyroHelper;
import ordermate.webresource.WebResourceHelper;
import ordermate.webresource.tyromobile.TyroMobileJSONHelper;
import org.eclipse.jetty.util.ajax.JSON;

@Path(value="")
public class TyroMobileResource {
    private static final String SECRET_KEY = "secret";
    private static final String EMPTY_RESULT_STR = "";
    private static final String NO_OPEN_SALES_STR = "{\"open-sales\":[]}";
    private static final List<String> txnList = new ArrayList<String>();

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/opensales")
    public Response getOpenSales(@QueryParam(value="operatorId") Long operatorId, @QueryParam(value="mid") String mid, @QueryParam(value="tid") String tid, @QueryParam(value="table") Long table) {
        try {
            String responseStr;
            if (operatorId == null || !this.validateOperatorId(operatorId)) {
                return this.getInvalidOperatorResponse();
            }
            if (this.getEftposTerminal(mid, tid) == null) {
                return this.getUnknownDeviceResponse();
            }
            if (table != null) {
                if (!this.validateTableExists(table)) {
                    return this.getTableDoesNotExistResponse();
                }
                responseStr = this.getOpenSalesForTable(table);
            } else {
                responseStr = this.getOpenSalesList();
            }
            Response.ResponseBuilder response = Response.ok((Object)responseStr).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(responseStr, this.getSecretKey()));
            return response.build();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("TyroMobileResource - Error occured within the getOpenSales method.", (Throwable)ex);
            Response.ResponseBuilder response = Response.status((int)405).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
            return response.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/transactionresult")
    public Response transactionResult(@HeaderParam(value="x-tyro-mac") String tyroMac, String transactionData) {
        VirtualEftpos eftposTerminal;
        String txnRef;
        boolean wasUnlocked;
        Map transactionMap;
        block19: {
            block18: {
                block17: {
                    block16: {
                        transactionMap = null;
                        wasUnlocked = false;
                        txnRef = null;
                        if (this.validateHMAC(transactionData, tyroMac)) break block16;
                        Response response = this.getInvalidHMACResponse();
                        if (wasUnlocked) {
                            this.safeRemoveTransactionFromList(txnRef);
                        }
                        this.unlockAccount(transactionMap);
                        return response;
                    }
                    transactionMap = (Map)TyroMobileJSONHelper.convertFromJSON(transactionData);
                    wasUnlocked = this.lockIfNotAlreadyWorkingOnIt(transactionMap);
                    if (wasUnlocked) break block17;
                    Response.ResponseBuilder response = Response.status((int)405).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
                    Response response2 = response.build();
                    if (wasUnlocked) {
                        this.safeRemoveTransactionFromList(txnRef);
                    }
                    this.unlockAccount(transactionMap);
                    return response2;
                }
                txnRef = (String)transactionMap.get("transaction-reference");
                eftposTerminal = this.getEftposTerminal((String)transactionMap.get("mid"), (String)transactionMap.get("tid"));
                if (this.validateOperatorId(Integer.valueOf((String)transactionMap.get("operator-id")).intValue())) break block18;
                this.unlockAccount(transactionMap);
                this.safeRemoveTransactionFromList(txnRef);
                Response response = this.getInvalidOperatorResponse();
                if (wasUnlocked) {
                    this.safeRemoveTransactionFromList(txnRef);
                }
                this.unlockAccount(transactionMap);
                return response;
            }
            if (eftposTerminal != null) break block19;
            this.unlockAccount(transactionMap);
            this.safeRemoveTransactionFromList(txnRef);
            Response response = this.getUnknownDeviceResponse();
            if (wasUnlocked) {
                this.safeRemoveTransactionFromList(txnRef);
            }
            this.unlockAccount(transactionMap);
            return response;
        }
        try {
            if (this.checkNotDuplicateTransaction(transactionMap)) {
                this.processTransaction(transactionMap, eftposTerminal);
                this.unlockAccount(transactionMap);
            }
            Response.ResponseBuilder response = Response.ok((Object)EMPTY_RESULT_STR).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
            this.safeRemoveTransactionFromList(txnRef);
            Response response3 = response.build();
            if (wasUnlocked) {
                this.safeRemoveTransactionFromList(txnRef);
            }
            this.unlockAccount(transactionMap);
            return response3;
        }
        catch (Exception ex) {
            try {
                OrderMate.LOG.error("TyroMobileResource - Error occured within the transactionResult method.", (Throwable)ex);
                Response.ResponseBuilder response = Response.status((int)405).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
                Response response4 = response.build();
                if (wasUnlocked) {
                    this.safeRemoveTransactionFromList(txnRef);
                }
                this.unlockAccount(transactionMap);
                return response4;
            }
            catch (Throwable throwable) {
                if (wasUnlocked) {
                    this.safeRemoveTransactionFromList(txnRef);
                }
                this.unlockAccount(transactionMap);
                throw throwable;
            }
        }
    }

    private synchronized boolean lockIfNotAlreadyWorkingOnIt(Map<String, String> transactionMap) {
        String txnRef = transactionMap.get("transaction-reference");
        if (!txnList.contains(txnRef)) {
            txnList.add(txnRef);
            return true;
        }
        return false;
    }

    private synchronized void safeRemoveTransactionFromList(String txnRef) {
        if (txnList.contains(txnRef)) {
            txnList.remove(txnRef);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/diagnostic")
    public Response getDiagnostic() {
        Response.ResponseBuilder response = Response.ok((Object)NO_OPEN_SALES_STR).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(NO_OPEN_SALES_STR, this.getSecretKey()));
        return response.build();
    }

    private FinanceUnit getFinanceUnit(String cardType) {
        FinanceUnit unit = TyroHelper.getFinanceUnitFor(cardType);
        if (unit == null) {
            unit = FinanceUnit.getUnitForName("Savings Acc");
            OrderMate.LOG.warn("TyroMobileResource cannot match finance unit, defaulting to savings.");
        }
        return unit;
    }

    private boolean checkNotDuplicateTransaction(Map<String, String> transactionMap) {
        FinanceTransaction eftTrans = PersistenceManager.getObject(FinanceTransaction.class, Query.select(FinanceTransaction.class).equals(EftposTransaction.Properties.TIP_REFERENCE, transactionMap.get("rrn")).equals(EftposTransaction.Properties.TRANSACTION_REFERENCE, transactionMap.get("transaction-reference")).whereFunction("fk_payoff_account = " + transactionMap.get("pos-reference")).limit(1).toString(), null);
        if (eftTrans != null) {
            OrderMate.LOG.info("TyroMobileResource - Duplicate transaction rrn: " + transactionMap.get("rrn") + ", reference: " + transactionMap.get("transaction-reference") + ", pos reference: " + transactionMap.get("pos-reference"));
        }
        return eftTrans == null;
    }

    private void unlockAccount(Map<String, String> transactionMap) {
        Account account;
        if (transactionMap != null && (account = this.resolveAccount(transactionMap)) != null) {
            if (account.isLocked(User.getSystemUser())) {
                OrderMate.LOG.info("Tyro Mobile Resource unlocking account held by system user " + account.getID());
                account.unlock();
            } else {
                OrderMate.LOG.warn("Cannot unlock account - " + account.toString() + " locked by " + account.getUser());
            }
        }
    }

    private void processTransaction(Map<String, String> transactionMap, VirtualEftpos virtualEftpos) {
        FinanceTransaction financeTrans = this.getFinanceTransaction(transactionMap, virtualEftpos);
        if (financeTrans == null) {
            return;
        }
        Account account = this.resolveAccount(transactionMap);
        if (account == null) {
            return;
        }
        if (!account.lock(User.getSystemUser()) || !account.isLocked()) {
            OrderMate.LOG.warn("TyroMobileResource - Locking the account to process transaction, account ID: " + account.getID());
            account.unlock();
            account.lock(User.getSystemUser());
        }
        if (financeTrans.getSurcharge() != null && !Price.ZERO_DOLLAR.equals(financeTrans.getSurcharge())) {
            EventContext context = new EventContext(Terminal.getServerMateTerminal(), User.getUserByPin(transactionMap.get("operator-id")), TradingDay.getCurrentTradingDay(), Terminal.getServerMateTerminal().getShift());
            FinanceSurchargeCalculator.applySurcharge(account, financeTrans.getSubType(), financeTrans.getSurcharge(), context);
        }
        account.addFinanceTransaction(financeTrans);
        this.saveAccount(account);
    }

    private void saveAccount(Account account) {
        SimpleSaveAccount simpleSaveAccount = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
        EventContext eventContext = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
        if (!simpleSaveAccount.closeAccount(account, true, true, eventContext)) {
            simpleSaveAccount.saveAccount(account, eventContext);
            OrderMate.LOG.info("The account " + account + " is saved, but it was unable to be closed.");
        }
    }

    private Account resolveAccount(Map<String, String> transactionMap) {
        Account account;
        String accountId = transactionMap.get("pos-reference");
        if (accountId != null) {
            account = PersistenceManager.getByID(Long.valueOf(accountId), Account.class);
        } else {
            accountId = transactionMap.get("table");
            OrderMate.LOG.info("Tyro cannot resolve by null id, will attempt by table name " + accountId);
            account = PersistenceManager.getObject(TableAccount.class, Query.select(TableAccount.class).linkUsing(TableAccount.Properties.TABLE).linkUsing(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE).equals(TableAccount.Properties.ACCOUNT_STATE, "OPEN").equals(PhysicalTable.Properties.NAME, accountId).active(PhysicalTable.class).toString());
        }
        if (account == null) {
            OrderMate.LOG.error("Cannot find account for " + accountId + " cannot process the transaction.");
        }
        return account;
    }

    private FinanceTransaction getFinanceTransaction(Map<String, String> transactionMap, VirtualEftpos virtualEftpos) {
        String srchgAmount;
        Price paid;
        if (transactionMap.get("base-amount") == null && transactionMap.get("transaction-reference") == null) {
            OrderMate.LOG.info("Cancelled or voided transaction with no amount or reference.");
            return null;
        }
        FinanceUnit financeUnit = this.getFinanceUnit(transactionMap.get("card-type"));
        CashDrawer cashDrawer = this.getCashdrawerForDevice(transactionMap.get("mid"), transactionMap.get("tid"));
        EftposTransaction financeTran = null;
        Price tipAmt = transactionMap.get("tip-amount") != null ? Price.parsePrice(transactionMap.get("tip-amount")) : Price.ZERO_DOLLAR;
        Price price = paid = transactionMap.get("base-amount") == null ? Price.ZERO_DOLLAR : Price.parsePrice(transactionMap.get("base-amount"));
        if (FinanceUnit.DEBIT_TYPE.toString().equals(financeUnit.getType())) {
            financeTran = new DebitTransaction(User.getUserByPin(transactionMap.get("operator-id")), Terminal.getServerMateTerminal(), paid, tipAmt, Price.ZERO_DOLLAR, cashDrawer, financeUnit, Terminal.getServerMateTerminal().getShift());
        } else if (FinanceUnit.CREDIT_TYPE.toString().equals(financeUnit.getType())) {
            financeTran = new CreditTransaction(User.getUserByPin(transactionMap.get("operator-id")), Terminal.getServerMateTerminal(), paid, tipAmt, cashDrawer, financeUnit, Terminal.getServerMateTerminal().getShift());
        } else {
            OrderMateLog.LOG.warn("Type is not an Eftpos type: " + financeUnit.getType());
            return null;
        }
        if (virtualEftpos.isEnableTip() && transactionMap.get("tip-completion-reference") != null) {
            financeTran.setTipReference(transactionMap.get("tip-completion-reference"));
            financeTran.setAllowTipAdjustment(true);
        } else {
            financeTran.setTipReference(transactionMap.get("rrn"));
            financeTran.setAllowTipAdjustment(false);
        }
        if (virtualEftpos.isAutoSurcharge() && (srchgAmount = transactionMap.get("surcharge-amount")) != null) {
            try {
                Price surchargeAmount = Price.parsePrice(srchgAmount);
                financeTran.setSurcharge(surchargeAmount);
                Price totalPaid = financeTran.getPaid().add(surchargeAmount);
                financeTran.setPaid(totalPaid);
                financeTran.setTendered(totalPaid);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("TyroMobileResource - Invalid surcharge amount from TYRO, given: " + srchgAmount);
            }
        }
        financeTran.setTransactionReference(transactionMap.get("transaction-reference"));
        financeTran.setAuthCode(transactionMap.get("approval-code"));
        financeTran.setTransactionProcessed(true);
        financeTran.setVirtualEftpos(virtualEftpos);
        String transactionResult = String.valueOf(transactionMap.get("result"));
        if (!"APPROVED".equals(transactionResult)) {
            financeTran.setSystemState("DELETED");
        }
        return financeTran;
    }

    private boolean validateHMAC(String message, String givenHMAC) {
        String calcedHMC = WebResourceHelper.generateHMAC(message, this.getSecretKey());
        boolean result = calcedHMC.equalsIgnoreCase(givenHMAC);
        if (!result) {
            OrderMate.LOG.info("TyroMobileResource - Invalid HMAC expected: " + calcedHMC + ", given: " + givenHMAC);
        }
        return result;
    }

    private boolean validateOperatorId(long operatorId) {
        boolean result;
        boolean bl = result = User.getUserByPin(String.valueOf(operatorId)) != null;
        if (!result) {
            OrderMate.LOG.info("TyroMobileResource - Invalid operator id: " + operatorId);
        }
        return result;
    }

    private boolean validateTableExists(long tableId) {
        PhysicalTable table = PersistenceManager.getObject(PhysicalTable.class, Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.NAME, String.valueOf(tableId)).active(PhysicalTable.class).limit(1).toString(), null);
        if (table == null) {
            OrderMate.LOG.info("TyroMobileResource - Invalid table, does not exist table: " + tableId);
        }
        return table != null;
    }

    private VirtualEftpos getEftposTerminal(String mid, String tid) {
        VirtualEftpos eftpos = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.TYROMOBILE).equals(VirtualEftpos.Properties.MERCHANT_ID, mid).equals(VirtualEftpos.Properties.TERMINAL_ID, tid).active(VirtualEftpos.class).limit(1).toString(), null);
        if (eftpos == null) {
            OrderMate.LOG.info("TyroMobileResource - Invalid terminal, not found mid: " + mid + ", tid: " + tid);
        }
        return eftpos;
    }

    private CashDrawer getCashdrawerForDevice(String mid, String tid) {
        VirtualEftpos eftPosDevice = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.TYROMOBILE).equals(VirtualEftpos.Properties.MERCHANT_ID, mid).equals(VirtualEftpos.Properties.TERMINAL_ID, tid).active(VirtualEftpos.class).limit(1).toString(), null);
        if (eftPosDevice != null) {
            return eftPosDevice.getCashDrawer();
        }
        OrderMate.LOG.info("TyroMobileResource - Cashdrawer cannot be found for device mid: " + mid + ", tid: " + tid);
        return null;
    }

    private String getOpenSalesList() {
        List<Account> accounts = PersistenceManager.getObjectList(Account.class, Query.select(Account.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).not().equals(Account.Properties.ACCOUNT_TYPE, AccountType.tableType).orderBy(Account.Properties.CREATION_DATE_TIME).limit(10).toString());
        return "{\"open-sales\":" + JSON.toString((Object[])TyroMobileJSONHelper.convertToJSONObject(accounts)) + this.getReturnOutcomeString() + "}";
    }

    private String getReturnOutcomeString() {
        return ",\"always-return-outcome\":\"true\"";
    }

    private String getOpenSalesForTable(long tableNo) {
        List<TableAccount> accounts = PersistenceManager.getObjectList(TableAccount.class, Query.select(TableAccount.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).linkUsing(TableAccount.Properties.TABLE, LogicalTable.Properties.ID).linkUsing(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE, PhysicalTable.Properties.ID).equals(PhysicalTable.Properties.NAME, tableNo).active(LogicalTable.class).active(PhysicalTable.class).toString());
        ArrayList<TableAccount> accountsLocked = new ArrayList<TableAccount>();
        if (accounts != null) {
            for (TableAccount tableAccount : accounts) {
                if (!tableAccount.isLocked() || tableAccount.isLocked(User.getSystemUser())) {
                    tableAccount.relock(User.getSystemUser());
                    accountsLocked.add(tableAccount);
                    continue;
                }
                LogicalTable table = tableAccount.getTable();
                OrderMate.LOG.warn("TyroMobileResource - table locked when trying to get open sales, table " + table.getID() + " " + table.getGroupAndLabel());
            }
        }
        return "{\"open-sales\":" + JSON.toString((Object[])TyroMobileJSONHelper.convertToJSONObject(accountsLocked)) + this.getReturnOutcomeString() + "}";
    }

    private Response getInvalidHMACResponse() {
        Response.ResponseBuilder response = Response.status((int)403).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
        return response.build();
    }

    private Response getInvalidOperatorResponse() {
        Response.ResponseBuilder response = Response.status((int)401).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
        return response.build();
    }

    private Response getTableDoesNotExistResponse() {
        Response.ResponseBuilder response = Response.status((int)400).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
        return response.build();
    }

    private Response getUnknownDeviceResponse() {
        Response.ResponseBuilder response = Response.status((int)404).header("x-tyro-mac", (Object)WebResourceHelper.generateHMAC(EMPTY_RESULT_STR, this.getSecretKey()));
        return response.build();
    }

    private String getSecretKey() {
        WebResource resource = PersistenceManager.getObject(WebResource.class, WebResource.getByType(WebResourceType.TyroPayAtTable).toString());
        if (resource != null) {
            return resource.getResourceProperty(SECRET_KEY, null).getValue();
        }
        return null;
    }
}

