/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.users;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.departments.Payrate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.User;
import ordermate.integration.jaxb.webservice.user.ObjectFactory;
import ordermate.integration.jaxb.webservice.user.PayrateEntry;
import ordermate.integration.jaxb.webservice.user.UserEntry;
import ordermate.integration.jaxb.webservice.user.UserList;
import ordermate.integration.jaxb.webservice.user.UserPermissionGroup;
import ordermate.webresource.WebResourceExporter;

class UserExporter
extends WebResourceExporter<UserList> {
    UserExporter() {
    }

    UserList createUserList() {
        ObjectFactory myFactory = new ObjectFactory();
        if (this.helper == null) {
            OrderMate.LOG.error("Couldn't create a datatype factory. Date of Birth will not be exported.");
            return myFactory.createUserList();
        }
        UserList exportList = myFactory.createUserList();
        exportList.setBusinessName(BusinessInfo.getInstance().getName());
        List<UserEntry> users = exportList.getUsers();
        List<User> allUsers = User.getUsers();
        for (User nextUser : allUsers) {
            UserEntry userEntry = myFactory.createUserEntry();
            userEntry.setActive(nextUser.isActive());
            userEntry.setFirstname(nextUser.getFirstName());
            userEntry.setSurname(nextUser.getLastName());
            userEntry.setUserId(nextUser.getID());
            userEntry.setCardId(nextUser.getCardID());
            userEntry.setMobile(nextUser.getMobile());
            userEntry.setEmail(nextUser.getEmail());
            userEntry.setDateOfBirth(this.helper.makeDate(nextUser.getDateOfBirth()));
            userEntry.setStaffId(nextUser.getPayrollID());
            if (nextUser.getPermissionGroup() != null) {
                userEntry.setPermissionGroup(UserPermissionGroup.fromValue(nextUser.getPermissionGroup().getLabel()));
            } else {
                StringBuilder SB = new StringBuilder("User is with a null permission group, default to 'Trainee'. User_ID:");
                SB.append(userEntry.getUserId());
                SB.append(" Surname:").append(userEntry.getSurname()).append(" Name:").append(userEntry.getFirstname());
                OrderMate.LOG.warn(SB.toString());
                userEntry.setPermissionGroup(UserPermissionGroup.TRAINEE);
            }
            for (Payrate payrate : nextUser.getPayrates()) {
                PayrateEntry entry = this.createPayrate(myFactory, payrate);
                if (entry == null) continue;
                userEntry.getPayrates().add(entry);
            }
            users.add(userEntry);
        }
        return exportList;
    }

    @Override
    public String getName() {
        return "Users";
    }

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{UserList.class, UserEntry.class, UserPermissionGroup.class};
    }

    private PayrateEntry createPayrate(ObjectFactory factory, Payrate rate) {
        PayrateEntry entry = factory.createPayrateEntry();
        entry.setDepartmentId(rate.getDepartment().getID());
        entry.setPayrate(rate.getPayRate().doubleValue());
        return entry;
    }
}

