/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.versiondiff;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.xmlintegration.humpback.versioning.HMObjectDiff;
import au.com.ordermate.xmlintegration.humpback.versioning.HMVersionDiff;
import au.com.ordermate.xmlintegration.humpback.versioning.HMVersionName;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.diff.VersionControl;
import ordermate.database.diff.VersionDiff;
import ordermate.diff.BOExportMappingContainer;
import ordermate.diff.online.OnlineOrderDiffMapping;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.versiondiff.ObjectDiffWrapper;

@Path(value="")
public class MenuVersionDiffResource
extends AbstractResource {
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/diff")
    public Response getDiff(@QueryParam(value="fromVersion") long fromVersion, @QueryParam(value="toVersion") long toVersion, @QueryParam(value="versionName") String versionName) {
        this.validateVersionParams(fromVersion, toVersion);
        try {
            VersionControl propVersControl = this.getVersionControl(versionName);
            this.validateVersControl(versionName, propVersControl);
            this.validateVersionNumbersExist(fromVersion, toVersion, propVersControl);
            HMVersionDiff versionDiff = this.getVersionDiff(propVersControl);
            versionDiff.setVersionFrom(Long.valueOf(fromVersion).longValue());
            versionDiff.setVersionTo(Long.valueOf(toVersion).longValue());
            List<VersionDiff> propVersChanges = propVersControl.getVersionDiff(fromVersion, toVersion);
            if (propVersChanges != null) {
                CacheManager.getInstance().clearEntireCache();
                List<HMObjectDiff> objDiffs = this.transformPropVersChanges(propVersChanges);
                versionDiff.getDiffs().addAll(objDiffs);
            }
            if (versionDiff.getDiffs().isEmpty()) {
                return this.getNoContentResponse(versionDiff);
            }
            return this.getResponse(versionDiff);
        }
        catch (WebApplicationException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call integration/version/diff webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private HMVersionDiff getVersionDiff(VersionControl propVersControl) {
        HMVersionDiff versionDiff = new HMVersionDiff();
        versionDiff.setCreationTime(XMLHelper.getDateType(new Date()));
        versionDiff.setCurrentVersion(propVersControl.getCurrentVersion());
        try {
            versionDiff.setVersionName(HMVersionName.fromValue((String)propVersControl.getName()));
        }
        catch (IllegalArgumentException e) {
            OrderMate.LOG.warn("There is version name jaxb enum type for the given version name:  " + propVersControl.getName());
        }
        return versionDiff;
    }

    public List<HMObjectDiff> transformPropVersChanges(List<VersionDiff> propVersChanges) throws Exception {
        BOExportMappingContainer container = new OnlineOrderDiffMapping().getMappingContainer();
        ObjectDiffWrapper objDiffWrapper = new ObjectDiffWrapper(propVersChanges, container);
        return objDiffWrapper.getObjectDiffs();
    }

    private void validateVersionNumbersExist(long fromVersion, long toVersion, VersionControl propVersControl) {
        if (fromVersion > propVersControl.getCurrentVersion() || toVersion > propVersControl.getCurrentVersion()) {
            this.throwBadRequestException("Version numbers cannot be greater than the current version: " + propVersControl.getCurrentVersion());
        }
    }

    private void validateVersionParams(long fromVersion, long toVersion) {
        if (fromVersion == 0L) {
            this.throwBadRequestException("There is NO any menu version for the given parameter, fromVersion: " + fromVersion);
        }
        if (toVersion != 0L && fromVersion > toVersion) {
            this.throwBadRequestException("fromVersion: " + fromVersion + " must be smaller than toVersion: " + toVersion);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/current")
    public Response getCurrentVersion(@QueryParam(value="versionName") String versionName) {
        try {
            VersionControl propVersControl = this.getVersionControl(versionName);
            this.validateVersControl(versionName, propVersControl);
            HMVersionDiff versionDiff = this.getVersionDiff(propVersControl);
            return this.getResponse(versionDiff);
        }
        catch (WebApplicationException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call integration/version/current webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private void validateVersControl(String versionName, VersionControl propVersControl) {
        if (propVersControl == null) {
            this.throwBadRequestException("There is NO any online menu version control for the given menu version name: " + versionName);
        }
    }

    private VersionControl getVersionControl(String versionName) {
        VersionControl propVersControl = PersistenceManager.getByID(1L, VersionControl.class);
        if (versionName != null) {
            propVersControl = PersistenceManager.getObject(VersionControl.class, Query.select(VersionControl.class).equals(VersionControl.Properties.NAME, versionName).toString());
        }
        return propVersControl;
    }
}

