/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.versiondiff;

import ordermate.database.diff.VersionDiff;

public final class ObjectDiffKey {
    private final long objectId;
    private final String classType;
    private final String xmlAlias;
    private final VersionDiff.ChangeType changeType;

    private ObjectDiffKey(ObjectDiffKeyBuilder builder) {
        this.objectId = builder.objectId;
        this.classType = builder.classType;
        this.xmlAlias = builder.xmlAlias;
        this.changeType = builder.changeType;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getXmlAlias() {
        return this.xmlAlias;
    }

    public VersionDiff.ChangeType getChangeType() {
        return this.changeType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changeType == null ? 0 : this.changeType.hashCode());
        result = 31 * result + (this.classType == null ? 0 : this.classType.hashCode());
        result = 31 * result + (int)(this.objectId ^ this.objectId >>> 32);
        result = 31 * result + (this.xmlAlias == null ? 0 : this.xmlAlias.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectDiffKey other = (ObjectDiffKey)obj;
        if (this.changeType != other.changeType) {
            return false;
        }
        if (this.classType == null ? other.classType != null : !this.classType.equals(other.classType)) {
            return false;
        }
        if (this.objectId != other.objectId) {
            return false;
        }
        return !(this.xmlAlias == null ? other.xmlAlias != null : !this.xmlAlias.equals(other.xmlAlias));
    }

    public static class ObjectDiffKeyBuilder {
        private final long objectId;
        private final String classType;
        private String xmlAlias = null;
        private final VersionDiff.ChangeType changeType;

        public ObjectDiffKeyBuilder(long objectId, String classType, VersionDiff.ChangeType changeType) {
            this.objectId = objectId;
            this.classType = classType;
            this.changeType = changeType;
        }

        public ObjectDiffKeyBuilder alias(String xmlAlias) {
            this.xmlAlias = xmlAlias;
            return this;
        }

        public ObjectDiffKey build() {
            return new ObjectDiffKey(this);
        }
    }
}

