/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.versiondiff;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.humpback.versioning.HMObjectDiff;
import au.com.ordermate.xmlintegration.humpback.versioning.HMPropertyChange;
import au.com.ordermate.xmlintegration.humpback.versioning.HMVersionChangeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.diff.VersionDiff;
import ordermate.diff.BOExportMappingContainer;
import ordermate.diff.BusinessExportMapping;
import ordermate.webresource.versiondiff.ObjectDiffKey;

public class ObjectDiffWrapper {
    private Map<ObjectDiffKey, HMObjectDiff> objDiffsMap = new HashMap<ObjectDiffKey, HMObjectDiff>();
    private final BOExportMappingContainer mappingContainer;

    public ObjectDiffWrapper(List<VersionDiff> versionDiffs, BOExportMappingContainer exportMappingContainer) throws Exception {
        if (exportMappingContainer == null) {
            throw new IllegalArgumentException("BO Export Mapping Container should be valid!");
        }
        this.mappingContainer = exportMappingContainer;
        for (VersionDiff versionDiff : versionDiffs) {
            this.processVersionDiff(versionDiff);
        }
    }

    public List<HMObjectDiff> getObjectDiffs() {
        return new ArrayList<HMObjectDiff>(this.objDiffsMap.values());
    }

    private void processVersionDiff(VersionDiff versionDiff) {
        List<BusinessExportMapping> exportMappings = this.mappingContainer.getMappings(versionDiff.getChangedProperty());
        if (exportMappings != null && !exportMappings.isEmpty()) {
            for (BusinessExportMapping exportMapping : exportMappings) {
                this.addObjectDiff(versionDiff, exportMapping);
            }
        } else {
            OrderMate.LOG.warn("There is NO any mapping for the changed property: " + versionDiff.getChangedProperty());
            return;
        }
    }

    private void addObjectDiff(VersionDiff versionDiff, BusinessExportMapping exportMapping) {
        Object boObj = versionDiff.getChangedBO();
        if (boObj == null) {
            OrderMate.LOG.warn("There is NO object of " + versionDiff.getClassType() + " for the ID: " + versionDiff.getObjectId());
            return;
        }
        HMObjectDiff objDiff = this.getObjectDiff(versionDiff, exportMapping);
        if (VersionDiff.ChangeType.Creation.equals((Object)versionDiff.getChangeType())) {
            this.addPropChangesForCreation(versionDiff, boObj, objDiff);
        } else {
            if (VersionDiff.ChangeType.Update.equals((Object)versionDiff.getChangeType())) {
                this.addLinkProps(versionDiff, boObj, objDiff);
            }
            this.addPropertyChange(versionDiff, objDiff, exportMapping.getXmlAttributeName(), exportMapping.exportValueToString(boObj));
        }
    }

    private void addPropChangesForCreation(VersionDiff propVersChange, Object boObj, HMObjectDiff objDiff) {
        List<BusinessExportMapping> mappedProps = this.mappingContainer.getPropMappingsByClass(propVersChange.getClassType());
        if (mappedProps == null) {
            OrderMate.LOG.warn("There is no any mapped properties for the changed class: " + propVersChange.getClassType());
            return;
        }
        for (BusinessExportMapping prop : mappedProps) {
            if (prop.getBusinessPropertyAccessor().getBaseProperty().getName().equalsIgnoreCase("ID")) continue;
            this.addPropertyChange(propVersChange, objDiff, prop.getXmlAttributeName(), prop.exportValueToString(boObj));
        }
    }

    private void addLinkProps(VersionDiff propVersChange, Object boObj, HMObjectDiff objDiff) {
        List<BusinessExportMapping> linkageProps = this.mappingContainer.getLinkPropsMapByClass(propVersChange.getClassType());
        if (linkageProps == null) {
            return;
        }
        for (BusinessExportMapping linkProp : linkageProps) {
            this.addPropertyChange(propVersChange, objDiff, linkProp.getXmlAttributeName(), linkProp.exportValueToString(boObj));
        }
    }

    private void addPropertyChange(VersionDiff versionDiff, HMObjectDiff objDiff, String xmlAttribute, String exportValue) {
        HMPropertyChange propChange = this.getPropertyChange(versionDiff.getVersionNumber(), objDiff, xmlAttribute, exportValue);
        if (propChange != null) {
            objDiff.getProps().add(propChange);
        }
    }

    private HMPropertyChange getPropertyChange(long versionNumber, HMObjectDiff objDiff, String xmlAttribute, String exportValue) {
        HMPropertyChange propChange = this.getExistingPropChange(objDiff, xmlAttribute, versionNumber);
        if (propChange != null) {
            objDiff.getProps().remove(propChange);
        } else {
            propChange = this.getNewPropChange(versionNumber, xmlAttribute);
        }
        this.setValueOfPropChange(exportValue, propChange);
        return propChange;
    }

    private void setValueOfPropChange(String exportValue, HMPropertyChange propChange) {
        String previousValue;
        String string = previousValue = propChange.getValue() != null ? propChange.getValue() : "";
        if (!exportValue.isEmpty()) {
            if (previousValue.isEmpty()) {
                propChange.setValue(exportValue);
            } else {
                propChange.setValue(StringUtils.mergeWithSeparator(StringUtils.splitToSet(previousValue.concat(",").concat(exportValue), ","), ","));
            }
        }
    }

    private HMPropertyChange getExistingPropChange(HMObjectDiff objDiff, String xmlAttribute, long versionNumber) {
        for (HMPropertyChange existingProp : objDiff.getProps()) {
            if (!existingProp.getProp().equals(xmlAttribute) || existingProp.getChangedVersion() != versionNumber) continue;
            return existingProp;
        }
        return null;
    }

    private HMPropertyChange getNewPropChange(long versionNumber, String xmlAttribute) {
        HMPropertyChange propChange = new HMPropertyChange();
        propChange.setChangedVersion(Long.valueOf(versionNumber).longValue());
        propChange.setProp(xmlAttribute);
        propChange.setValue("");
        return propChange;
    }

    private HMObjectDiff getObjectDiff(VersionDiff propVersChange, BusinessExportMapping exportMapping) {
        ObjectDiffKey objDiffKey = this.getObjectDiffKey(propVersChange, exportMapping);
        HMObjectDiff objDiff = this.objDiffsMap.get(objDiffKey);
        if (objDiff == null) {
            objDiff = this.getNewObjectDiff(objDiffKey);
            this.objDiffsMap.put(objDiffKey, objDiff);
        }
        return objDiff;
    }

    private ObjectDiffKey getObjectDiffKey(VersionDiff versionDiff, BusinessExportMapping exportMapping) {
        return new ObjectDiffKey.ObjectDiffKeyBuilder(versionDiff.getExportId(), exportMapping.getXmlTypeName(), versionDiff.getChangeType()).alias(exportMapping.getXmlAlias()).build();
    }

    private HMObjectDiff getNewObjectDiff(ObjectDiffKey objDiffKey) {
        HMObjectDiff objDiff = new HMObjectDiff();
        objDiff.setId(Long.valueOf(objDiffKey.getObjectId()).longValue());
        objDiff.setClazzType(objDiffKey.getClassType());
        if (objDiffKey.getXmlAlias() != null) {
            objDiff.setAlias(objDiffKey.getXmlAlias());
        }
        try {
            objDiff.setChangeType(HMVersionChangeType.fromValue((String)objDiffKey.getChangeType().toString()));
        }
        catch (IllegalArgumentException e) {
            OrderMate.LOG.warn("There is VersionDiff jaxb change type for the given change type: " + (Object)((Object)objDiffKey.getChangeType()));
        }
        return objDiff;
    }
}

