/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.webpayment;

import au.com.ordermate.persistence.PersistenceManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.integration.paypal.PayPalComms;

@Path(value="")
public class WebPaymentResource {
    @Path(value="/authorise/{id}")
    @GET
    @Produces(value={"text/html"})
    public String PayPalAuthorise(@PathParam(value="id") long serviceId, @QueryParam(value="code") String code) {
        OrderMate.LOG.info("Received callback from Paypal for id " + serviceId + " " + code);
        WebPaymentIntegration integration = PersistenceManager.getByID(serviceId, WebPaymentIntegration.class);
        if (integration != null && code != null && !code.isEmpty()) {
            if ("1".equals(integration.getAuthCode())) {
                OrderMate.LOG.info("Received PayPal Authorisation code for payment integration " + integration.getMerchantEmail());
                integration.setAuthCode(code);
                integration.save();
                PayPalComms comms = new PayPalComms(integration);
                comms.doOAuthPairing();
                return "<html><img src=\"http://localhost/WebStart/images/PayPalAuthorised.png\"></html>";
            }
            OrderMate.LOG.info("Call made to set authorisation code, when the code has not been requested.");
            return "<html><h1>This call is invalid</h1></html>";
        }
        OrderMate.LOG.error("Invalid path or code:" + serviceId + " code:" + code);
        return "<html><h1>OrderMate POS Cannot configure PayPal Payments due to an error.<br><br>Please close the browser window.</h1></html>";
    }
}

