/*
 * Decompiled with CFR 0.152.
 */
package ordermate.xml.serializers.stock;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockTakeEntryI;
import stockmate.xml.serializers.stock.StockTakeEntrySerializer;

public class DBStockTakeEntrySerializer
extends StockTakeEntrySerializer {
    private Map<Long, StockTakeEntryHolder> cache;

    public void preload(StockTake take) {
        Object[][] values;
        this.cache = new HashMap<Long, StockTakeEntryHolder>();
        String query = "SELECT ste.id, soh.Quantity, ste.ActualQty, soh.fk_stock_area FROM stock_take_entry ste JOIN stock_on_hand soh on (soh.fk_stock_item = ste.fk_stock_item AND soh.fk_stock_area = ste.fk_stock_area) WHERE fk_stock_take = ?";
        for (Object[] entry : values = PersistenceManager.getPersistenceDelegate().executeQuery(query, new Object[]{take.getID()})) {
            StockTakeEntryHolder holder = new StockTakeEntryHolder();
            holder.id = ((Number)entry[0]).longValue();
            holder.expAmount = (Number)entry[1];
            holder.actAmount = (Number)entry[2];
            holder.areaId = String.valueOf(entry[3]);
            this.cache.put(holder.id, holder);
        }
    }

    public void clearCache() {
        this.cache = null;
    }

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        StockTakeEntryI entry = (StockTakeEntryI)objectToSerialise;
        docSerializer.startTag(null, "entry");
        StockTakeEntryHolder holder = this.cache.get(entry.intID());
        docSerializer.attribute(null, "id", String.valueOf(holder.id));
        docSerializer.attribute(null, "item", String.valueOf(entry.getStockItem().intID()));
        docSerializer.attribute(null, "area", holder.areaId);
        if (entry.getActualQuantity() != null) {
            docSerializer.attribute(null, "actual_qty", MathsUtils.neatenDouble(((Quantity)entry.getActualQuantity()).doubleValue(), 3));
        }
        Quantity qty = new Quantity(((StockItem)entry.getStockItem()).getDisplayMeasureUnitContainer(), holder.expAmount.doubleValue(), true);
        docSerializer.attribute(null, "expected_qty", MathsUtils.neatenDouble(qty.doubleValue(), 3));
        docSerializer.endTag(null, "entry");
    }

    class StockTakeEntryHolder {
        Number expAmount;
        Number actAmount;
        String areaId;
        Long id;

        StockTakeEntryHolder() {
        }
    }
}

