/*
 * Decompiled with CFR 0.152.
 */
package ordermate.xml.serializers.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import ordermate.xml.serializers.stock.DBStockTakeEntrySerializer;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockTakeI;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.StockTakeEntrySerializer;

public class DBStockTakeSerializer
implements XMLObjectSerializer {
    public static final String TAG_NAME = "stocktake";
    public static final String ID = "id";
    public static final String DATE = "date";
    public static final String LIVENESS = "is_live";
    private StockTakeEntrySerializer entrySerializer;
    private DateFormat dateFormat;

    public DBStockTakeSerializer() {
        this(null);
    }

    public DBStockTakeSerializer(DateFormat dateFormatToUse) {
        if (dateFormatToUse == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        }
        this.entrySerializer = new DBStockTakeEntrySerializer();
    }

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        docSerializer.startTag(null, TAG_NAME);
        StockTakeI take = (StockTakeI)objectToSerialise;
        docSerializer.attribute(null, ID, Long.toString(take.intID()));
        docSerializer.attribute(null, DATE, this.dateFormat.format(take.getDate()));
        docSerializer.attribute(null, LIVENESS, Boolean.toString(take.isLive()));
        ((DBStockTakeEntrySerializer)this.entrySerializer).preload((StockTake)take);
        Iterator<StockTakeEntry> it = this.getStockableEntries((StockTakeI)objectToSerialise).iterator();
        while (it.hasNext()) {
            this.entrySerializer.serializeToXML(docSerializer, (Object)it.next());
        }
        ((DBStockTakeEntrySerializer)this.entrySerializer).clearCache();
        docSerializer.endTag(null, TAG_NAME);
    }

    private List<StockTakeEntry> getStockableEntries(StockTakeI stockTake) {
        ObjectQuery query = Query.select(StockTakeEntry.class).linkUsing(StockTakeEntry.Properties.STOCK_ITEM, StockOnHand.Properties.STOCK_ITEM).linkUsing(StockTakeEntry.Properties.STOCK_AREA, StockOnHand.Properties.STOCK_AREA).equals((PropertiedObject.Property)StockTakeEntry.Properties.STOCK_TAKE, stockTake.intID()).equals(StockOnHand.Properties.STOCK_ALLOWED, "1").orderBy(StockTakeEntry.Properties.STOCK_ITEM).orderBy(StockTakeEntry.Properties.STOCK_AREA, true);
        return PersistenceManager.getObjectList(StockTakeEntry.class, query.toString());
    }
}

