/*
Welcome to my humble abode, young traveler.
Your quest must be to update the sales_customer_stats page, no?
Well I must get you acquainted with our tools.
*ahem*
In this SQL file we're using correlated subqueries to do the heavy lifting. (check out the wikipedia page on it)
Instead of iterating over every customer and setting individual values, we're updating an entire table with sequenced joins! By golly!

You'll need to provide your column tied to the sales_customer ID column, updated like this (feel free to copy/paste):
-- ------------------------------------------------------------ NAME OF COLUMN
UPDATE sales_customer_stats scs 

LEFT JOIN (
	-- SELECT statement that grabs all rows with customer ID attached
    -- also use aliases for comfort
) totals ON scs.FK_sales_customer = ALIASEDTABLE.custID

SET
scs.total_orders = ALIASEDTABLE.COLUMN;

Take a look at some examples below as well :)

After that you should be ready to go young warrior.
*/

-- ------------------------------------------------------------ total orders
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT FK_sales_customer custID, COUNT(*) total_orders 
    FROM sales_item 
    WHERE FK_sales_customer IS NOT NULL 
    GROUP BY FK_sales_customer
) totals ON scs.FK_sales_customer = totals.custID

SET scs.total_orders = totals.total_orders;

-- ------------------------------------------------------------ first order
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, closed_time as first_order 
    FROM (SELECT FK_sales_customer custID, closed_time FROM sales_account ORDER BY closed_time ASC) AS s 
    GROUP BY custID
) firsts ON scs.FK_sales_customer = firsts.custID

SET scs.first_order = firsts.first_order;

-- ------------------------------------------------------------ last order
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, closed_time as last_order 
    FROM (SELECT FK_sales_customer custID, closed_time FROM sales_account ORDER BY closed_time DESC) AS s 
    GROUP BY custID
) lasts ON scs.FK_sales_customer = lasts.custID

SET scs.last_order = lasts.last_order;

-- ------------------------------------------------------------ order frequency
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT FK_sales_customer as custID, CONCAT("Every ", ROUND(365/COUNT(*),1), " days") as order_frequency 
    FROM sales_account 
    WHERE FK_sales_customer IS NOT NULL
    AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
    GROUP BY FK_sales_customer
) freqs ON scs.FK_sales_customer = freqs.custID

SET scs.order_frequency = freqs.order_frequency;

-- ------------------------------------------------------------ average spend
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT FK_sales_customer custID, ROUND(AVG(saved_total),2) average_spend 
    FROM sales_account 
    WHERE FK_sales_customer IS NOT NULL 
    AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
    GROUP BY FK_sales_customer
) avgspend ON scs.FK_sales_customer = avgspend.custID

SET scs.average_spend = avgspend.average_spend;

-- ------------------------------------------------------------ most ordered item
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, most_ordered_item FROM (
		SELECT sales_item.FK_sales_customer custID, inventory_item.Name most_ordered_item, COUNT(*) count
		FROM sales_item
		INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID
		INNER JOIN sales_component ON sales_item.FK_sales_component = sales_component.ID
		INNER JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID
		WHERE sales_component.saved_total_price > 0
		AND sales_item.FK_sales_customer IS NOT NULL
        AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
		GROUP BY custID, most_ordered_item
		ORDER BY sales_item.FK_sales_customer, count DESC, inventory_item.Name
	) as s 
	GROUP BY custID
) mostitem ON scs.FK_sales_customer = mostitem.custID

SET scs.most_ordered_item = mostitem.most_ordered_item;

-- ------------------------------------------------------------ most ordered section
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, most_ordered_section FROM (
		SELECT sales_item.FK_sales_customer custID, inventory_group.Name most_ordered_section, COUNT(*) count
		FROM sales_item
		INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID
		INNER JOIN sales_component ON sales_item.FK_sales_component = sales_component.ID
		INNER JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID
		INNER JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID
		WHERE sales_component.saved_total_price > 0
		AND sales_item.FK_sales_customer IS NOT NULL
        AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
		GROUP BY custID, most_ordered_section
		ORDER BY sales_item.FK_sales_customer, count DESC, inventory_item.Name
	) as s 
	GROUP BY custID
) mostsection ON scs.FK_sales_customer = mostsection.custID

SET scs.most_ordered_section = mostsection.most_ordered_section;

-- ------------------------------------------------------------ highest grossing item
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, highest_grossing_item FROM (
		SELECT sales_item.FK_sales_customer custID, inventory_item.Name highest_grossing_item, SUM(sales_component.saved_total_price) total
		FROM sales_item
			INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID
			INNER JOIN sales_component ON sales_item.FK_sales_component = sales_component.ID
			INNER JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID
			WHERE sales_component.saved_total_price > 0
			AND sales_item.FK_sales_customer IS NOT NULL
            AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
			GROUP BY sales_item.FK_sales_customer, inventory_item.Name
			ORDER BY custID, total DESC
	) as s
	GROUP BY custID
) grossitem ON scs.FK_sales_customer = grossitem.custID

SET scs.highest_grossing_item = grossitem.highest_grossing_item;

-- ------------------------------------------------------------ highest grossing section
UPDATE sales_customer_stats scs 

LEFT JOIN (
	SELECT custID, highest_grossing_section FROM (
		SELECT sales_item.FK_sales_customer custID, inventory_group.Name highest_grossing_section, ROUND(SUM(sales_component.saved_total_price),2) total
		FROM sales_item
			INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID
			INNER JOIN sales_component ON sales_item.FK_sales_component = sales_component.ID
			INNER JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID
			INNER JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID
			WHERE sales_component.saved_total_price > 0
			AND sales_item.FK_sales_customer IS NOT NULL
            AND sales_account.closed_time >= DATE_SUB(NOW(),INTERVAL 1 YEAR)
			GROUP BY sales_item.FK_sales_customer, inventory_group.Name
			ORDER BY custID, total DESC
	) as s
	GROUP BY custID
) grosssection ON scs.FK_sales_customer = grosssection.custID

SET scs.highest_grossing_section = grosssection.highest_grossing_section;

-- ------------------------------------------------------------ highest grossing section
UPDATE sales_customer_stats scs 

LEFT JOIN (
		SELECT FK_sales_customer custID, ROUND(SUM(saved_total),2) total_spend 
		FROM sales_account 
		WHERE FK_sales_customer IS NOT NULL 
		GROUP BY FK_sales_customer
) tspends ON scs.FK_sales_customer = tspends.custID

SET scs.total_spend = tspends.total_spend;