/*
 * Decompiled with CFR 0.152.
 */
package stockmate;

import au.com.ordermate.OrderMateLog;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import pocketmate.Configuration;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.gui.display.WaitPanel;

public class DefaultDisplayController
extends JFrame
implements DisplayController {
    private JPanel currentScreen = null;
    private JMenuBar currentNavBar = null;
    private WaitPanel waitPanel = new WaitPanel();
    private JPanel tempScreen = null;
    private JMenuBar tempNavBar = null;
    private Component previousPane;
    private boolean isModal;
    private boolean isDebug;

    public DefaultDisplayController() {
        this(ApplicationContext.getAppName());
    }

    public DefaultDisplayController(String appTitle) {
        super(appTitle);
        this.setGlassPane(this.waitPanel);
        this.waitPanel.setVisible(false);
        this.getContentPane().setLayout(new BorderLayout());
        String debug = Configuration.current.getData("debug");
        this.isDebug = debug != null ? debug.equalsIgnoreCase("true") : false;
        try {
            this.setUndecorated(!this.isDebug);
        }
        catch (Error ex) {
            OrderMate.LOG.info((Object)"set undecorated is not supported in java 1.1", (Throwable)ex);
        }
        this.setDefaultCloseOperation(3);
        ((Component)this).setBackground(new Color(255, 255, 255));
        this.setVisible(true);
        this.setSize(240, 320);
        this.isModal = false;
    }

    public void setDisplay(JPanel display) {
        Container pane = this.getContentPane();
        if (this.currentScreen != null) {
            pane.remove(this.currentScreen);
        }
        this.currentScreen = display;
        if (this.currentNavBar != null) {
            pane.remove(this.currentNavBar);
        }
        this.currentNavBar = null;
        if (this.currentScreen != null) {
            pane.add((Component)this.currentScreen, "Center");
        }
        this.validate();
        this.repaint();
    }

    public void setDisplay(JPanel display, JMenuBar navBar) {
        this.setDisplay(display);
        this.setNavBar(navBar);
    }

    public void setNavBar(JMenuBar navBar) {
        Container pane = this.getContentPane();
        if (this.currentNavBar != null) {
            pane.remove(this.currentNavBar);
        }
        this.currentNavBar = navBar;
        if (this.currentNavBar != null) {
            pane.add((Component)this.currentNavBar, "North");
        }
        this.validate();
        this.repaint();
    }

    public JPanel getDisplay() {
        return this.currentScreen;
    }

    public JMenuBar getNavBar() {
        return this.currentNavBar;
    }

    public void displayWaitIcon() {
        this.waitPanel.setVisible(true);
    }

    public void removeWaitIcon() {
        this.waitPanel.setVisible(false);
        this.clearEventQueue();
    }

    public void startModalScreen(JPanel dialog, JMenuBar navBar) {
        this.tempScreen = this.currentScreen;
        this.tempNavBar = this.currentNavBar;
        this.setDisplay(dialog, navBar);
        this.repaint();
        try {
            dialog.setVisible(true);
            this.isModal = true;
            this.waitOnModal(dialog);
        }
        catch (InterruptedException e) {
            this.stopModalScreen();
        }
    }

    public void stopModalScreen() {
        this.currentScreen.setVisible(false);
        this.isModal = false;
        this.setDisplay(this.tempScreen, this.tempNavBar);
        this.tempScreen = null;
        this.tempNavBar = null;
    }

    public void startModalWindow(Component dialog) {
        this.previousPane = this.getGlassPane();
        this.setGlassPane(dialog);
        dialog.setVisible(true);
        this.getGlassPane().validate();
        this.getGlassPane().repaint();
        this.isModal = true;
        try {
            this.waitOnModal(dialog);
        }
        catch (InterruptedException e) {
            this.stopModalWindow();
        }
    }

    public void stopModalWindow() {
        this.getGlassPane().setVisible(false);
        this.previousPane.setVisible(false);
        this.setGlassPane(this.previousPane);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void clearEventQueue() {
        Vector<AWTEvent> events = new Vector<AWTEvent>();
        boolean finished = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue queue = toolkit.getSystemEventQueue();
        while (!finished) {
            AWTEvent obj = queue.peekEvent();
            if (obj != null) {
                try {
                    obj = queue.getNextEvent();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (obj instanceof MouseEvent) continue;
                events.addElement(obj);
                continue;
            }
            finished = true;
        }
        for (int i = 0; i < events.size(); ++i) {
            queue.postEvent((AWTEvent)events.elementAt(i));
        }
    }

    private void waitOnModal(Component waitComponent) throws InterruptedException {
        if (waitComponent.isVisible() && !waitComponent.isShowing()) {
            for (Container parent = waitComponent.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueue theQueue = this.getToolkit().getSystemEventQueue();
            while (waitComponent.isVisible() && this.isModal) {
                AWTEvent event = theQueue.getNextEvent();
                Object src = event.getSource();
                if (event instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)event)).dispatch();
                    continue;
                }
                if (src instanceof Component) {
                    ((Component)src).dispatchEvent(event);
                    continue;
                }
                if (src instanceof MenuComponent) {
                    ((MenuComponent)src).dispatchEvent(event);
                    continue;
                }
                OrderMateLog.LOG.error((Object)"Could not dispatch AWTEvent.");
            }
        } else {
            while (waitComponent.isVisible() && this.isModal) {
                Thread.sleep(500L);
            }
        }
    }
}

