/*
 * Decompiled with CFR 0.152.
 */
package stockmate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import pocketmate.Configuration;

class SplashPanel
extends JPanel {
    private String contactLine1;
    private String contactLine2;
    private String contactLine3;
    private JProgressBar progressBar;

    public SplashPanel() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        JLabel imageLabel = new JLabel(IconLoader.get((String)"/pocketmate/images/pocketmate_splash_gradiant.png"));
        this.add((Component)imageLabel, "Center");
        this.contactLine1 = Configuration.current.getContactLine1();
        this.contactLine2 = Configuration.current.getContactLine2();
        this.contactLine3 = Configuration.current.getContactLine3();
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "South");
    }

    public void paint(Graphics g) {
        super.paint(g);
        Font font = new Font("Arial", 0, 9);
        g.setFont(font);
        g.drawString("2.7.10", 170, 28);
        if (this.contactLine1 != null) {
            g.drawString(this.contactLine1, 3, 245);
        }
        if (this.contactLine2 != null) {
            g.drawString(this.contactLine2, 3, 257);
        }
        if (this.contactLine2 != null) {
            g.drawString(this.contactLine3, 3, 269);
        }
    }

    public void setNumTasks(int totalNumTasks) {
        this.progressBar.setMaximum(0);
        this.progressBar.setMaximum(totalNumTasks);
    }

    public void setProgress(Integer progress) {
        try {
            SwingUtilities.invokeAndWait(new ProgressUpdater(progress));
        }
        catch (Exception e) {
            OrderMateLog.LOG.error((Object)"Error setting progress bar progress", (Throwable)e);
        }
    }

    public void setMessage(String message) {
        try {
            SwingUtilities.invokeAndWait(new MessageUpdater(message));
        }
        catch (Exception e) {
            OrderMateLog.LOG.error((Object)"Error setting progress bar message", (Throwable)e);
        }
    }

    private class MessageUpdater
    implements Runnable {
        private String startupMessage;

        public MessageUpdater(String message) {
            this.startupMessage = message;
        }

        public void run() {
            SplashPanel.this.progressBar.setString(this.startupMessage);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private Integer progress;

        public ProgressUpdater(Integer newProgress) {
            this.progress = newProgress;
        }

        public void run() {
            SplashPanel.this.progressBar.setValue(this.progress);
        }
    }
}

