/*
 * Decompiled with CFR 0.152.
 */
package stockmate;

import ordermate.OrderMate;
import pocketmate.Configuration;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.application.ConnectionManager;
import stockmate.http.HttpDownloader;

public class StockConnectionManager
implements ConnectionManager {
    private String address = Configuration.current.getServerIPAddress();

    public String getAddress() {
        return this.address;
    }

    public void handleConnectionError(int errorCode) {
        if (errorCode != 1) {
            StringBuffer SB = new StringBuffer("Could not establish a connection");
            SB.append(" with the server on:\n");
            SB.append(this.address);
            Dialogs.displayWarningDialog((String)"Error with Connection", (String)SB.toString());
        } else {
            StringBuffer SB = new StringBuffer("Connection is hunky dory ");
            SB.append(" with the server on:\n");
            SB.append(this.address);
            Dialogs.displayWarningDialog((String)"Connection Established", (String)SB.toString());
        }
    }

    public void setAddress(String newAddress) {
        if (newAddress != null) {
            this.address = newAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryConnect() {
        int error = 1;
        HttpDownloader downloader = null;
        try {
            downloader = Configuration.current.createDownloader("user");
            int response = downloader.validateGet();
            if (response != 200) {
                error = 2;
                OrderMate.LOG.warn((Object)("Couldn't connect on:" + this.address + " response:" + response));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn((Object)("Couldn't connect on:" + this.address), (Throwable)ex);
            error = 2;
        }
        finally {
            if (downloader != null) {
                downloader.cleanUp();
            }
        }
        return error;
    }
}

