/*
 * Decompiled with CFR 0.152.
 */
package stockmate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.progress.CompositeTask;
import au.com.ordermate.gui.progress.ProgressLogger;
import au.com.ordermate.gui.progress.Task;
import ordermate.OrderMate;
import ordermate.signals.Signals;
import ordermate.startup.OrderMateSetupException;
import org.apache.log4j.BasicConfigurator;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.SplashPanel;
import stockmate.StockConnectionManager;
import stockmate.StockMateFrame;
import stockmate.application.ApplicationContext;
import stockmate.login.StockItLoginManager;
import stockmate.startup.CreateStockObjectRegisterTask;
import stockmate.startup.SetupDevice;
import stockmate.startup.SetupMainStateTask;
import stockmate.startup.SetupPocketmateGuiDefaults;
import stockmate.tasks.ValidConnectionTask;

public class StockMate {
    private static final String APP_NAME = "StockMate";
    private static StockMateFrame frame;
    public static String VERSION;

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
        }
        catch (NoClassDefFoundError e) {
            OrderMate.LOG.warn((Object)("Log4J configurator failed: " + e.getLocalizedMessage()));
        }
        OrderMate.LOG.info((Object)("Pocket StockMate started, StockMate version : " + VERSION));
        Signals.setSignalType((int)1);
        ApplicationContext.setAppName(APP_NAME);
        frame = new StockMateFrame();
        ApplicationContext.setDisplayController(frame);
        frame.setDefaultCloseOperation(2);
        SplashPanel splashPanel = new SplashPanel();
        frame.setVisible(true);
        frame.setDisplay(splashPanel);
        StockItLoginManager login = new StockItLoginManager();
        ApplicationContext.setLoginManager(login);
        StockConnectionManager connection = new StockConnectionManager();
        ApplicationContext.setConnectionManager(connection);
        CompositeTask startup = StockMate.createStartupTask(splashPanel);
        StockMate.runTasks(startup);
        OrderMate.LOG.info((Object)"StockMate startup complete");
    }

    static StockMateFrame getStockItFrame() {
        return frame;
    }

    private static CompositeTask createStartupTask(SplashPanel splashPanel) {
        CompositeTask startup = new CompositeTask("Stockit Startup", null);
        startup.addTask((Task)new CreateStockObjectRegisterTask());
        startup.addTask((Task)new SetupPocketmateGuiDefaults());
        startup.addTask((Task)new ValidConnectionTask());
        startup.addTask((Task)new SetupMainStateTask());
        if (System.getProperty("java.vendor").equalsIgnoreCase("nsicom")) {
            startup.addTask((Task)new SetupDevice());
        }
        startup.taskStarted.connect((Object)new ProgressLogger(), "logProgress");
        splashPanel.setNumTasks(startup.getTotalSubTasks());
        startup.progress.connect((Object)splashPanel, "setProgress");
        startup.taskStarted.connect((Object)splashPanel, "setMessage");
        return startup;
    }

    private static void runTasks(CompositeTask startup) {
        while (!startup.hasRun()) {
            try {
                startup.runLocal();
            }
            catch (OrderMateSetupException e) {
                if (e.isFatal()) {
                    Dialogs.displayCriticalDialog((String)"Startup Error", (String)e.getStringMessage());
                    OrderMateLog.LOG.error((Object)"Problem starting up PocketMate, exiting", (Throwable)e);
                    ApplicationContext.exit();
                    continue;
                }
                OrderMateLog.LOG.error((Object)"Problem starting up PocketMate, exiting", (Throwable)e);
                if (!Dialogs.displayChoiceDialog((String)"Startup Error", (String)e.getStringMessage(), (String)"Continue", (String)"Exit")) {
                    ApplicationContext.exit();
                    continue;
                }
                startup.removeTask(e.getFailedTask());
            }
            catch (Throwable e) {
                Dialogs.displayCriticalDialog((String)"Startup Error", (String)"Problem starting up PocketMate, please contact OrderMate support");
                OrderMateLog.LOG.error((Object)"Problem starting up PocketMate, exiting", e);
                ApplicationContext.exit();
            }
        }
    }

    static {
        VERSION = "0.2";
    }
}

