/*
 * Decompiled with CFR 0.152.
 */
package stockmate.application;

import au.com.ordermate.OrderMateLog;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.UIManager;
import stockmate.application.ConnectionManager;
import stockmate.application.DisplayController;
import stockmate.application.LoginManager;
import stockmate.device.scanner.Scanner;

public abstract class ApplicationContext {
    private static DisplayController displayController;
    private static LoginManager loginManager;
    private static ConnectionManager connectionManager;
    private static String appName;

    public static final DisplayController getDisplayController() {
        if (displayController == null) {
            throw new IllegalStateException("Default DisplayController has not been initialised.");
        }
        return displayController;
    }

    public static final void setDisplayController(DisplayController controller) {
        displayController = controller;
    }

    public static final LoginManager getLoginManager() {
        if (loginManager == null) {
            throw new IllegalStateException("LoginManager has not been initialised.");
        }
        return loginManager;
    }

    public static final void setLoginManager(LoginManager manager) {
        loginManager = manager;
    }

    public static final void setConnectionManager(ConnectionManager manager) {
        connectionManager = manager;
    }

    public static final ConnectionManager getConnectionManager() {
        if (connectionManager == null) {
            throw new IllegalStateException("ConnectionManager has not been initialised.");
        }
        return connectionManager;
    }

    public static final String getAppName() {
        return appName;
    }

    public static final void setAppName(String name) {
        appName = name;
    }

    public static synchronized void exit() {
        Scanner.stop();
        OrderMateLog.LOG.info((Object)(ApplicationContext.getAppName() + " exiting."));
        System.exit(0);
    }

    public static void sizePanelToFullScreen(JPanel panel) {
        panel.setPreferredSize(new Dimension(240, 290));
        panel.setMinimumSize(new Dimension(240, 290));
        panel.setMaximumSize(new Dimension(240, 290));
    }

    public static Font getHeadingFont() {
        return UIManager.getFont("HeadingFont");
    }
}

