/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import pocketmate.Configuration;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.asyncstock.AsyncStockDataUploader;
import stockmate.asyncstock.AsyncStockRequestUploader;
import stockmate.asyncstock.SimpleQuantity;
import stockmate.asyncstock.SimpleStockArea;
import stockmate.asyncstock.SimpleStockBarcode;
import stockmate.asyncstock.SimpleStockGroup;
import stockmate.asyncstock.SimpleStockInvoice;
import stockmate.asyncstock.SimpleStockInvoiceEntry;
import stockmate.asyncstock.SimpleStockItem;
import stockmate.asyncstock.SimpleStockSupplier;
import stockmate.asyncstock.SimpleStockTake;
import stockmate.asyncstock.SimpleStockTakeEntry;
import stockmate.asyncstock.visitor.AsyncRegisterParser;
import stockmate.database.interfaces.stock.QuantityI;
import stockmate.database.interfaces.stock.StockAreaI;
import stockmate.database.interfaces.stock.StockBarcodeI;
import stockmate.database.interfaces.stock.StockGroupI;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;
import stockmate.database.interfaces.stock.StockInvoiceI;
import stockmate.database.interfaces.stock.StockItemI;
import stockmate.database.interfaces.stock.StockObjectRegister;
import stockmate.database.interfaces.stock.StockSupplierI;
import stockmate.database.interfaces.stock.StockTakeEntryI;
import stockmate.database.interfaces.stock.StockTakeI;
import stockmate.http.HttpDownloader;
import stockmate.http.HttpUploader;
import stockmate.xml.XMLObjectHelper;
import stockmate.xml.XMLObjectSerializer;

public class AsyncStockObjectRegister
implements StockObjectRegister {
    private static final String rootNode = "stock";
    private static final String NEW_STOCKTAKE = "new stocktake";
    private static final List EMPTY_LIST = new ArrayList();
    private Map stockMap;
    private List barcodePrefixes;
    private Map stockItemByIDMap;
    private StockItemI[] allItems;
    private Map barcodeMap;
    private boolean isSynchronised = false;
    private AsyncRegisterParser parser = new AsyncRegisterParser(this);
    private AsyncStockDataUploader dataUploader = new AsyncStockDataUploader();
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockSupplier;
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockArea;
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockGroup;
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockTake;
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockInvoice;
    static /* synthetic */ Class class$stockmate$asyncstock$SimpleStockBarcode;

    public AsyncStockObjectRegister() {
        this.stockItemByIDMap = new HashMap();
        this.barcodeMap = new HashMap();
        this.barcodePrefixes = new ArrayList();
        this.stockMap = new HashMap();
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockSupplier == null ? (class$stockmate$asyncstock$SimpleStockSupplier = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockSupplier")) : class$stockmate$asyncstock$SimpleStockSupplier, new ArrayList());
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockArea == null ? (class$stockmate$asyncstock$SimpleStockArea = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockArea")) : class$stockmate$asyncstock$SimpleStockArea, new ArrayList());
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockGroup == null ? (class$stockmate$asyncstock$SimpleStockGroup = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockGroup")) : class$stockmate$asyncstock$SimpleStockGroup, new ArrayList());
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockTake == null ? (class$stockmate$asyncstock$SimpleStockTake = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockTake")) : class$stockmate$asyncstock$SimpleStockTake, new ArrayList());
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockInvoice == null ? (class$stockmate$asyncstock$SimpleStockInvoice = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockInvoice")) : class$stockmate$asyncstock$SimpleStockInvoice, new ArrayList());
        this.stockMap.put(class$stockmate$asyncstock$SimpleStockBarcode == null ? (class$stockmate$asyncstock$SimpleStockBarcode = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockBarcode")) : class$stockmate$asyncstock$SimpleStockBarcode, new ArrayList());
    }

    public void clearCache() {
        Iterator it = this.stockMap.keySet().iterator();
        while (it.hasNext()) {
            ((Collection)this.stockMap.get(it.next())).clear();
        }
        this.allItems = null;
        this.barcodePrefixes.clear();
        this.stockItemByIDMap.clear();
        this.barcodeMap.clear();
        this.isSynchronised = false;
    }

    public List getCachedList(Class cachedClass) {
        return (List)this.stockMap.get(cachedClass);
    }

    public StockInvoiceI createInvoice() {
        Iterator invoices = this.getCachedList(class$stockmate$asyncstock$SimpleStockInvoice == null ? (class$stockmate$asyncstock$SimpleStockInvoice = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockInvoice")) : class$stockmate$asyncstock$SimpleStockInvoice).iterator();
        int idValue = -1;
        while (invoices.hasNext() && this.getStockInvoice(idValue) != null) {
            --idValue;
        }
        SimpleStockInvoice newInvoice = new SimpleStockInvoice(idValue);
        this.addStockObject(newInvoice);
        newInvoice.setStockArea((StockAreaI)this.getStockAreas().get(0));
        newInvoice.setSupplier((StockSupplierI)this.getSuppliers().get(0));
        newInvoice.setInvoiceNumber(String.valueOf("DELIVERY-" + newInvoice.hashCode()));
        newInvoice.setInvoiceType("Delivery Note");
        return newInvoice;
    }

    public StockInvoiceEntryI createInvoiceEntry(double quantity, StockItemI stockItem) {
        SimpleStockInvoiceEntry newEntry = new SimpleStockInvoiceEntry(0L, quantity);
        newEntry.setStockItem(stockItem);
        return newEntry;
    }

    public StockTakeI getLiveStockTake() {
        Iterator it = this.getCachedList(class$stockmate$asyncstock$SimpleStockTake == null ? (class$stockmate$asyncstock$SimpleStockTake = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockTake")) : class$stockmate$asyncstock$SimpleStockTake).iterator();
        while (it.hasNext()) {
            SimpleStockTake nextTake = (SimpleStockTake)it.next();
            if (!nextTake.isLive()) continue;
            return nextTake;
        }
        return null;
    }

    public StockTakeI createStockTake() {
        StockTakeI stocktake = this.getLiveStockTake();
        if (stocktake == null && this.uploadRequest(NEW_STOCKTAKE)) {
            this.updateStockData();
            stocktake = this.getLiveStockTake();
        }
        return stocktake;
    }

    public List getStockAreas() {
        return this.getCachedList(class$stockmate$asyncstock$SimpleStockArea == null ? (class$stockmate$asyncstock$SimpleStockArea = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockArea")) : class$stockmate$asyncstock$SimpleStockArea);
    }

    public StockAreaI getStockArea(long id) {
        Iterator it = this.getCachedList(class$stockmate$asyncstock$SimpleStockArea == null ? (class$stockmate$asyncstock$SimpleStockArea = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockArea")) : class$stockmate$asyncstock$SimpleStockArea).iterator();
        while (it.hasNext()) {
            SimpleStockArea nextArea = (SimpleStockArea)it.next();
            if (nextArea.intID() != id) continue;
            return nextArea;
        }
        return null;
    }

    public StockItemI[] getAllStockItems() {
        if (this.allItems == null) {
            this.allItems = new StockItemI[this.stockItemByIDMap.size()];
            this.allItems = this.stockItemByIDMap.values().toArray(this.allItems);
            Arrays.sort(this.allItems, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    StockItemI item0 = (StockItemI)arg0;
                    StockItemI item1 = (StockItemI)arg1;
                    if (item0 == null || item0.getLabel() == null || item1 == null) {
                        return 0;
                    }
                    return item0.getLabel().compareTo(item1.getLabel());
                }
            });
        }
        return this.allItems;
    }

    public StockItemI getStockItem(long id) {
        return (SimpleStockItem)this.stockItemByIDMap.get(new Long(id));
    }

    public List getStockItemsForBarcode(String barcode) {
        List results = (List)this.barcodeMap.get(barcode);
        if (results != null) {
            return results;
        }
        return EMPTY_LIST;
    }

    public void addBarcode(String barcode, StockItemI item) {
        Iterator it = item.getStockBarcodes().iterator();
        boolean found = false;
        while (it.hasNext()) {
            StockBarcodeI nextCode = (StockBarcodeI)it.next();
            if (!barcode.equals(nextCode.getBarcode())) continue;
            found = true;
            break;
        }
        if (!found) {
            SimpleStockBarcode newCode = new SimpleStockBarcode(barcode);
            newCode.setStockItem(item);
            item.getStockBarcodes().add(newCode);
            this.addItemBarcode(newCode);
        }
    }

    protected StockTakeI getStockTake(long stockTakeID) {
        Iterator it = this.getCachedList(class$stockmate$asyncstock$SimpleStockTake == null ? (class$stockmate$asyncstock$SimpleStockTake = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockTake")) : class$stockmate$asyncstock$SimpleStockTake).iterator();
        while (it.hasNext()) {
            StockTakeI nextStockTake = (StockTakeI)it.next();
            if (nextStockTake.intID() != stockTakeID) continue;
            return nextStockTake;
        }
        return null;
    }

    public List getStockTakeEntries(StockTakeI stockTakeID, StockAreaI stockAreaID, StockGroupI stockGroupID) {
        StockTakeI stockTake = this.getStockTake(stockTakeID.intID());
        ArrayList<SimpleStockTakeEntry> toReturn = new ArrayList<SimpleStockTakeEntry>();
        HashSet itemSet = new HashSet();
        this.getAllItems(this.getStockGroup(stockGroupID.intID()), itemSet);
        Iterator it = stockTake.getStockTakeEntries().iterator();
        while (it.hasNext()) {
            SimpleStockTakeEntry nextEntry = (SimpleStockTakeEntry)it.next();
            if (nextEntry.getStockArea().intID() != stockAreaID.intID() || !itemSet.contains(nextEntry.getStockItem())) continue;
            toReturn.add(nextEntry);
        }
        Collections.sort(toReturn, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null) {
                    if (arg1 == null) {
                        return 1;
                    }
                } else if (arg1 == null) {
                    return -1;
                }
                return ((SimpleStockTakeEntry)arg0).getStockItem().getLabel().compareTo(((SimpleStockTakeEntry)arg1).getStockItem().getLabel());
            }
        });
        return toReturn;
    }

    private void getAllItems(StockGroupI stockGroup, Collection itemList) {
        itemList.addAll(stockGroup.getStockItems());
        List subGroups = stockGroup.getSubGroups();
        if (subGroups != null) {
            Iterator it = subGroups.iterator();
            while (it.hasNext()) {
                StockGroupI subGroup = (StockGroupI)it.next();
                this.getAllItems(subGroup, itemList);
            }
        }
    }

    public List getSuppliers() {
        return this.getCachedList(class$stockmate$asyncstock$SimpleStockSupplier == null ? (class$stockmate$asyncstock$SimpleStockSupplier = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockSupplier")) : class$stockmate$asyncstock$SimpleStockSupplier);
    }

    public SimpleStockSupplier getSupplier(long id) {
        Iterator it = this.getCachedList(class$stockmate$asyncstock$SimpleStockSupplier == null ? (class$stockmate$asyncstock$SimpleStockSupplier = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockSupplier")) : class$stockmate$asyncstock$SimpleStockSupplier).iterator();
        while (it.hasNext()) {
            SimpleStockSupplier supplier = (SimpleStockSupplier)it.next();
            if (supplier.intID() != id) continue;
            return supplier;
        }
        return null;
    }

    public List getTopLevelStockGroups() {
        return this.getCachedList(class$stockmate$asyncstock$SimpleStockGroup == null ? (class$stockmate$asyncstock$SimpleStockGroup = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockGroup")) : class$stockmate$asyncstock$SimpleStockGroup);
    }

    public void removeInvoice(StockInvoiceI invoice) {
        this.getCachedList(class$stockmate$asyncstock$SimpleStockInvoice == null ? (class$stockmate$asyncstock$SimpleStockInvoice = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockInvoice")) : class$stockmate$asyncstock$SimpleStockInvoice).remove(invoice);
    }

    public boolean saveStockTake(StockTakeI stockTake) {
        if (this.isStockTakeModified()) {
            this.updateStockData();
            return this.isSynchronised;
        }
        return true;
    }

    public boolean saveStockTakeEntry(StockTakeEntryI entry) {
        return true;
    }

    public StockGroupI getStockGroup(long id) {
        Iterator groups = this.getCachedList(class$stockmate$asyncstock$SimpleStockGroup == null ? (class$stockmate$asyncstock$SimpleStockGroup = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockGroup")) : class$stockmate$asyncstock$SimpleStockGroup).iterator();
        while (groups.hasNext()) {
            SimpleStockGroup group = this.findStockGroup(id, (SimpleStockGroup)groups.next());
            if (group == null || group.intID() != id) continue;
            return group;
        }
        return null;
    }

    private SimpleStockGroup findStockGroup(long id, SimpleStockGroup parent) {
        if (id == parent.intID()) {
            return parent;
        }
        Iterator it = parent.getSubGroups().iterator();
        while (it.hasNext()) {
            SimpleStockGroup subGroup = this.findStockGroup(id, (SimpleStockGroup)it.next());
            if (subGroup == null) continue;
            return subGroup;
        }
        return null;
    }

    SimpleStockInvoice getStockInvoice(int invoiceID) {
        Iterator invoices = this.getCachedList(class$stockmate$asyncstock$SimpleStockInvoice == null ? (class$stockmate$asyncstock$SimpleStockInvoice = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockInvoice")) : class$stockmate$asyncstock$SimpleStockInvoice).iterator();
        while (invoices.hasNext()) {
            SimpleStockInvoice invoice = (SimpleStockInvoice)invoices.next();
            if (invoice.intID() != (long)invoiceID) continue;
            return invoice;
        }
        return null;
    }

    public List getStockTakes() {
        return this.getCachedList(class$stockmate$asyncstock$SimpleStockTake == null ? (class$stockmate$asyncstock$SimpleStockTake = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockTake")) : class$stockmate$asyncstock$SimpleStockTake);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean downloadStockInformation() {
        this.isSynchronised = false;
        this.clearCache();
        HttpDownloader downloader = Configuration.current.createDownloader(rootNode);
        try {
            InputStream input = downloader.openConnectionAndGetStream();
            if (input != null) {
                KXmlParser docParser = XMLObjectHelper.openDocumentForParsing(input);
                this.parser.parseFromXML(docParser);
                this.isSynchronised = true;
                OrderMate.LOG.info((Object)"Stock information downloaded.");
            } else {
                OrderMate.LOG.warn((Object)"Connection refused or lost when downloading stock information.");
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.warn((Object)"Problem parsing stock information, connection.", (Throwable)ex);
        }
        catch (XmlPullParserException ex) {
            OrderMate.LOG.warn((Object)"Problem parsing stock information, XML.", (Throwable)ex);
        }
        finally {
            OrderMate.LOG.info((Object)"Closing and cleaning up after download attempt.");
            downloader.cleanUp();
        }
        return this.isSynchronised;
    }

    boolean uploadStockInformation() {
        this.isSynchronised = false;
        return this.uploadData(this.dataUploader, this, "Stock Data");
    }

    public void updateStockData() {
        if (this.uploadStockInformation()) {
            this.downloadStockInformation();
        }
    }

    private boolean uploadRequest(String request) {
        return this.uploadData(new AsyncStockRequestUploader(), request, "Stock Request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadData(XMLObjectSerializer uploader, Object objectToSerialize, String uploadType) {
        boolean hasUploaded = false;
        OrderMate.LOG.info((Object)("Attempting to upload " + uploadType));
        HttpUploader httpUploader = Configuration.current.createUploader(rootNode);
        try {
            OutputStream output = httpUploader.getStreamForSerializing();
            if (output != null) {
                KXmlSerializer docSerializer = XMLObjectHelper.openDocumentForSerializing(output);
                uploader.serializeToXML(docSerializer, objectToSerialize);
                docSerializer.flush();
                if (httpUploader.postDataAccepted()) {
                    hasUploaded = true;
                    OrderMate.LOG.info((Object)(uploadType + " successfully uploaded."));
                    this.handleResponseMessage(httpUploader.getActiveInputStream());
                }
            } else {
                OrderMate.LOG.warn((Object)("Connection refused or lost when uploading " + uploadType));
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.warn((Object)("Problem while uploading " + uploadType + ", bad connection"), (Throwable)ex);
        }
        catch (XmlPullParserException ex) {
            OrderMate.LOG.warn((Object)("Problem while uploading " + uploadType + ", bad XML"), (Throwable)ex);
        }
        finally {
            httpUploader.cleanUp();
        }
        return hasUploaded;
    }

    private void handleResponseMessage(InputStream activeInputStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(activeInputStream));
        String line = in.readLine();
        while (line != null) {
            String title = line.substring(0, line.indexOf(":"));
            String text = line.substring(line.indexOf(":"), line.length() - 1);
            Dialogs.displayInfoDialog((String)title, (String)text);
            line = in.readLine();
        }
    }

    public boolean isStockDataSynchronised() {
        return this.isSynchronised;
    }

    public List getInvoices() {
        ArrayList invoices = new ArrayList();
        invoices.addAll(this.getCachedList(class$stockmate$asyncstock$SimpleStockInvoice == null ? (class$stockmate$asyncstock$SimpleStockInvoice = AsyncStockObjectRegister.class$("stockmate.asyncstock.SimpleStockInvoice")) : class$stockmate$asyncstock$SimpleStockInvoice));
        return invoices;
    }

    public void addStockObject(Object toAdd) {
        if (toAdd == null) {
            throw new IllegalArgumentException("Cannot add a null object to the Stock Register");
        }
        List stockList = (List)this.stockMap.get(toAdd.getClass());
        if (stockList == null) {
            throw new IllegalArgumentException("AsyncStockObjectRegister does not directly store:" + toAdd.getClass().getName());
        }
        if (!stockList.contains(toAdd)) {
            stockList.add(toAdd);
        }
        if (toAdd instanceof StockGroupI) {
            StockGroupI group = (StockGroupI)toAdd;
            Iterator it = group.getStockItems().iterator();
            while (it.hasNext()) {
                this.addStockItem((SimpleStockItem)it.next());
            }
            it = group.getSubGroups().iterator();
            while (it.hasNext()) {
                this.addStockObject(it.next());
            }
            if (group.getParentGroup() != null) {
                stockList.remove(group);
            }
        }
    }

    private void addStockItem(SimpleStockItem item) {
        Long id = new Long(item.intID());
        if (!this.stockItemByIDMap.containsKey(id)) {
            this.stockItemByIDMap.put(id, item);
            Iterator it = item.getStockBarcodes().iterator();
            while (it.hasNext()) {
                this.addItemBarcode((SimpleStockBarcode)it.next());
            }
        }
    }

    private void addItemBarcode(StockBarcodeI barcode) {
        StockItemI item;
        ArrayList<StockItemI> itemList = (ArrayList<StockItemI>)this.barcodeMap.get(barcode.getBarcode());
        if (itemList == null) {
            itemList = new ArrayList<StockItemI>();
            this.barcodeMap.put(barcode.getBarcode(), itemList);
        }
        if ((item = barcode.getStockItem()) != null && !itemList.contains(item)) {
            itemList.add(item);
        }
    }

    public QuantityI createQuantity(double value) {
        if (value == 0.0) {
            return SimpleQuantity.ZERO_QUANTITY;
        }
        return new SimpleQuantity(value);
    }

    public void addBarcodePrefix(String text) {
        if (text != null && text.length() > 0) {
            this.barcodePrefixes.add(text);
        }
    }

    public boolean isBarcodeString(String data) {
        Iterator it = this.barcodePrefixes.iterator();
        while (it.hasNext()) {
            String nextPrefix = (String)it.next();
            if (!data.startsWith(nextPrefix)) continue;
            return true;
        }
        return false;
    }

    public List getBarcodePrefixes() {
        return this.barcodePrefixes;
    }

    public void removeInvoiceEntry(StockInvoiceI invoice, StockInvoiceEntryI entry) {
        ((SimpleStockInvoice)invoice).removeEntry(entry);
    }

    public void addInvoiceEntry(StockInvoiceI invoice, StockInvoiceEntryI entry) {
        ((SimpleStockInvoice)invoice).addEntry(entry);
    }

    public void setInvoiceEntryParameters(StockInvoiceEntryI entry, double amount, StockItemI item) {
        ((SimpleStockInvoiceEntry)entry).setStockItem(item);
        ((SimpleStockInvoiceEntry)entry).setNumReceived(amount);
    }

    public void setInvoiceParameters(StockInvoiceI invoice, StockSupplierI supplier, StockAreaI area) {
        ((SimpleStockInvoice)invoice).setSupplier(supplier);
        ((SimpleStockInvoice)invoice).setStockArea(area);
    }

    public void setStockTakeEntryParameters(StockTakeEntryI entry, QuantityI actual) {
        ((SimpleStockTakeEntry)entry).setActualQuantity(actual);
    }

    public boolean isChecked(StockTakeEntryI entry) {
        return ((SimpleStockTakeEntry)entry).isChecked();
    }

    public void setChecked(StockTakeEntryI entry, boolean checked) {
        ((SimpleStockTakeEntry)entry).setChecked(checked);
    }

    public boolean saveInvoice(StockInvoiceI invoice, StockAreaI area, StockSupplierI supplier) {
        if (area == null) {
            throw new IllegalArgumentException("Cannot save the invoice area as null.");
        }
        if (supplier == null) {
            throw new IllegalArgumentException("Cannot save the invoice supplier as null.");
        }
        ((SimpleStockInvoice)invoice).setStockArea(area);
        ((SimpleStockInvoice)invoice).setSupplier(supplier);
        this.updateStockData();
        return this.isSynchronised;
    }

    boolean isStockTakeModified() {
        StockTakeI take = this.getLiveStockTake();
        if (take == null) {
            return false;
        }
        Iterator it = take.getStockTakeEntries().iterator();
        while (it.hasNext()) {
            SimpleStockTakeEntry nextEntry = (SimpleStockTakeEntry)it.next();
            if (!nextEntry.isChecked()) continue;
            return true;
        }
        return false;
    }

    public List getCheckedStockTakeEntries(SimpleStockTake stocktake) {
        ArrayList<SimpleStockTakeEntry> checkedList = new ArrayList<SimpleStockTakeEntry>();
        Iterator it = stocktake.getStockTakeEntries().iterator();
        while (it.hasNext()) {
            SimpleStockTakeEntry nextEntry = (SimpleStockTakeEntry)it.next();
            if (!nextEntry.isChecked()) continue;
            checkedList.add(nextEntry);
        }
        return checkedList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

