/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock;

import au.com.ordermate.util.MathsUtils;
import java.text.DecimalFormat;
import stockmate.database.interfaces.stock.QuantityI;

public class SimpleQuantity
implements QuantityI {
    public static final int DEFAULT_NUM_PLACES = 6;
    public static final SimpleQuantity ZERO_QUANTITY = new SimpleQuantity(0.0);
    private static final DecimalFormat format = new DecimalFormat("0.#######");
    private double value;
    private int numPlaces;

    public SimpleQuantity(double qtyValue) {
        this(qtyValue, 6);
    }

    public SimpleQuantity(double qtyValue, int numDecimalPlaces) {
        this.value = qtyValue;
        this.numPlaces = numDecimalPlaces;
    }

    public SimpleQuantity add(SimpleQuantity toadd) {
        return new SimpleQuantity(this.value + toadd.value);
    }

    public QuantityI add(QuantityI toAdd) {
        return new SimpleQuantity(Double.parseDouble(((Object)toAdd).toString()) + this.value, this.numPlaces);
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof SimpleQuantity) {
            return this.approxEquals(((SimpleQuantity)toCompare).doubleValue());
        }
        if (toCompare instanceof Number) {
            return this.approxEquals(((Number)toCompare).doubleValue());
        }
        return false;
    }

    public double doubleValue() {
        return this.value;
    }

    public int getNumDecimalPlaces() {
        return this.numPlaces;
    }

    public String toString() {
        return this.getAmountString();
    }

    public String getAmountString() {
        return format.format(MathsUtils.roundDoubleToDecPlaces((double)this.value, (int)this.numPlaces));
    }

    private boolean approxEquals(double toCompare) {
        return MathsUtils.roundDoubleToDecPlaces((double)this.value, (int)this.numPlaces) == MathsUtils.roundDoubleToDecPlaces((double)toCompare, (int)this.numPlaces);
    }

    public static final SimpleQuantity parseQuantity(String value) throws NumberFormatException {
        return new SimpleQuantity(Double.parseDouble(value));
    }
}

